/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kapplication.h>
#include <kurl.h>
#include <kprocess.h>
#include <klocale.h>

// Qt includes
#include <qcursor.h>

// command includes
#include "rotateimagecommand.h"
#include "rotateimagewidget.h"
#include "rotateimagedialog.h"
#include "checkbox.h"

using namespace WorKflow;

RotateImageCommand::RotateImageCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  RotateImageWidget* w = new RotateImageWidget(this);
  setWidget(w);

  // for now, this has to be here :(
  connect(w->m_interactiveCheckBox, SIGNAL(toggled(bool)), this, SIGNAL(sizeChanged()));
}

RotateImageCommand::~RotateImageCommand()
{
}

void RotateImageCommand::execute()
{
  QStringList files = value("images").asStringList();
  if (files.isEmpty())
    return;

  bool interactive = value("interactive").nextBoolean();

  if (interactive) {
    RotateImageDialog dialog(files, widget());
    dialog.exec();
  } else {
    int degrees;

    switch (int(value("mode").nextNumber())) {
      case 0: degrees = 90; break;
      case 1: degrees = -90; break;
      case 2: degrees = 180; break;
      case 3: degrees = int(value("degrees").nextNumber()); break;
    }

    int count = files.count();
    int num = 1;
    for (QStringList::ConstIterator i = files.begin(); i != files.end(); ++i, ++num) {
      emit progress(double(num) / double(count), i18n("Rotating image %1").arg(*i));
      rotateImage(degrees, *i);
    }
  }

  Command::execute();
}

void RotateImageCommand::rotateImage(int degrees, const QString& fileName, QString dest)
{
  KURL url(fileName);

  if (url.isLocalFile()) {
    QString path = url.path();
    if (dest.isNull())
      dest = path;

    KProcess proc;
    proc << "convert" << "-rotate" << QString::number(degrees);
    proc << path << dest;

    kapp->setOverrideCursor(QCursor(QCursor::BusyCursor));
    proc.start(KProcess::Block);
    kapp->restoreOverrideCursor();
  } else {
    // TODO
  }
}

#include "rotateimagecommand.moc"
