/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// WorKflow includes
#include "urlrequester.h"
#include "parameter.h"

using namespace WorKflow;

URLRequester::URLRequester(const QString& url, QWidget* parent, const char* name)
  : KURLRequester(url, parent, name), WidgetInterface()
{
  connect(this, SIGNAL(textChanged(const QString&)), this, SLOT(slotTextChanged()));
}

URLRequester::URLRequester(QWidget* parent, const char* name)
  : KURLRequester(parent, name), WidgetInterface()
{
  connect(this, SIGNAL(textChanged(const QString&)), this, SLOT(slotTextChanged()));
}

URLRequester::~URLRequester()
{
}

Value URLRequester::value()
{
  return Value::singleString(parameter()->typeId(), url());
}

void URLRequester::setValue(const Value& value)
{
  setURL(value.asStringList().first());
}

void URLRequester::slotTextChanged()
{
  if (!parameter())
    return;

  emit changed(value());
}

void URLRequester::setParameterId(const QString& paramId)
{
  WidgetInterface::setParameterId(paramId);
}

QString URLRequester::parameterId() const
{
  return WidgetInterface::parameterId();
}

#include "urlrequester.moc"
