/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef CONVERSIONDIALOG_H
#define CONVERSIONDIALOG_H

#include "conversiondialogbase.h"

// forward declarations
namespace WorKflow
{
  class Conversion;
  class LibraryDescription;
}

class ConversionDialog : public ConversionDialogBase
{
  Q_OBJECT

public:
  static bool editConversion(QWidget* parent, WorKflow::Conversion* desc);
  static WorKflow::Conversion* newConversion(QWidget* parent, WorKflow::LibraryDescription* library);

protected:
  ConversionDialog(QWidget* parent, WorKflow::Conversion* desc);
  ~ConversionDialog();

  void init();

protected slots:
  virtual void accept();
  virtual void browseSourceType();
  virtual void browseDestType();
  virtual void editFilter();

private:
  WorKflow::Conversion* m_conversion;
};

#endif

