/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kdebug.h>

// Qt includes
#include <qdom.h>

// WorKflow includes
#include "slotdescription.h"

using namespace WorKflow;

SlotDescription::SlotDescription(CommandDescription* parent)
  : XMLDescription(), m_parent(parent)
{
}

SlotDescription::~SlotDescription()
{
}

CommandDescription* SlotDescription::parent()
{
  return m_parent;
}

QStringList SlotDescription::typeIds() const
{
  return m_typeIds;
}

void SlotDescription::clearTypeIds()
{
  m_typeIds.clear();
}

void SlotDescription::addTypeId(const QString& id)
{
  m_typeIds << id;
}

void SlotDescription::readXML(const QDomElement& e)
{
  XMLDescription::readXML(e);

  QDomNode n = e.firstChild();
  while (!n.isNull()) {
    QDomElement e = n.toElement();
    if (!e.isNull()) {
      if (e.tagName() == "types") {
        QDomNode i = e.firstChild();
        while (!i.isNull()) {
          QDomElement item = i.toElement();
          if (!item.isNull()) {
            if (item.tagName() == "type") {
              QString id = item.attribute("id");

              if (id.isNull()) {
                kdWarning() << "malformed type item in slot " << this->id() << endl;
              } else {
                addTypeId(id);
              }
            }
          }
          i = i.nextSibling();
        }
      }
    }
    n = n.nextSibling();
  }
}

void SlotDescription::writeXML(QDomDocument& doc, QDomElement& e)
{
  XMLDescription::writeXML(doc, e);

  if (m_typeIds.isEmpty())
    return;

  QDomElement types = doc.createElement("types");

  for (QStringList::ConstIterator i = m_typeIds.begin(); i != m_typeIds.end(); ++i) {
    QDomElement type = doc.createElement("type");
    type.setAttribute("id", *i);
    types.appendChild(type);
  }

  e.appendChild(types);
}
