/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// Qt includes
#include <qdom.h>

// WorKflow includes
#include "resultdescription.h"
#include "commanddescription.h"

using namespace WorKflow;

ResultDescription::ResultDescription(CommandDescription* parent)
  : SlotDescription(parent), m_copyValue(false)
{
}

ResultDescription::~ResultDescription()
{
  parent()->removeResultDescription(this);
}

void ResultDescription::setParameter(const QString& param)
{
  m_parameter = param;
}

void ResultDescription::setCopyValue(bool copy)
{
  m_copyValue = copy;
}

QString ResultDescription::parameter()
{
  return m_parameter;
}

bool ResultDescription::copyValue()
{
  return m_copyValue;
}

void ResultDescription::readXML(const QDomElement& e)
{
  SlotDescription::readXML(e);

  QDomNode n = e.firstChild();
  while (!n.isNull()) {
    QDomElement e = n.toElement();
    if (!e.isNull()) {
      if (e.tagName() == "link") {
        m_parameter = e.attribute("param");
        m_copyValue = (e.attribute("copy") == "true");
      }
    }
    n = n.nextSibling();
  }

  parent()->addResultDescription(this);
}

void ResultDescription::writeXML(QDomDocument& doc, QDomElement& e)
{
  QDomElement result = doc.createElement("result");
  SlotDescription::writeXML(doc, result);

  if (!m_parameter.isEmpty()) {
    QDomElement link = doc.createElement("link");
    link.setAttribute("param", m_parameter);
    link.setAttribute("copy", m_copyValue ? "true" : "false");
    result.appendChild(link);
  }

  e.appendChild(result);
}
