/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kstandarddirs.h>

// Qt includes
#include <qimage.h>

// WorKflow includes
#include "previewwidget.h"
#include "checkbox.h"

// command includes
#include "flipimagewidget.h"
#include "flipimagecommand.h"

using namespace WorKflow;

FlipImageWidget::FlipImageWidget(Command* command)
  : FlipImageWidgetBase(0)
{
  setCommand(command);
}

FlipImageWidget::~FlipImageWidget()
{
}

void FlipImageWidget::updatePreview()
{
  FlipImageCommand::flipImage(m_flipHorzCheckBox->isChecked(), m_flipVertCheckBox->isChecked(), m_imagePreview->originalImagePath(), "/tmp/x.png");
  m_imagePreview->setProcessedImage("/tmp/x.png");
}

void FlipImageWidget::slotInteractiveChanged()
{
  bool interactive = m_interactiveCheckBox->isChecked();

  m_flipHorzCheckBox->setEnabled(!interactive);
  m_flipVertCheckBox->setEnabled(!interactive);
  m_imagePreview->setHidden(interactive);
}

#include "flipimagewidget.moc"
