/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef FLIPIMAGEDIALOG_H
#define FLIPIMAGEDIALOG_H

// Qt includes
#include <qstringlist.h>

// command includes
#include "flipimagedialogbase.h"

class FlipImageDialog : public FlipImageDialogBase
{
  Q_OBJECT

public:
  FlipImageDialog(const QStringList& images, QWidget* parent = 0, const char* name = 0, WFlags fl = 0);
  ~FlipImageDialog();

protected:
  virtual void showEvent(QShowEvent*);
//   virtual void keyPressEvent(QKeyEvent* e);
  virtual bool event(QEvent* e);

protected slots:
  virtual void setScaleImage(bool scale);
  virtual void next();
  virtual void flipVertical();
  virtual void flipHorizontal();
  virtual void showHelpText();

private:
  void updatePreview();

  QStringList m_files;
  QString m_current;
};

#endif

