/***************************************************************************
 *   Copyright (C) 2003 by Christoph Thielecke (crissi99@gmx.de)           *
 *   Copyright (C) 2003 by Ole Behrmann                                    *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "chpassdialog.h"
#include <qstring.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <klineedit.h>
#include <kpassdlg.h>
#include <qprocess.h>
#include <qpushbutton.h>
#include <qlabel.h>

ChPassDialog::ChPassDialog(QString username) : KDialogBase() {
    user = username;
    showButtonOK (true);
    showButtonCancel (true);
    showButtonApply (false);
    setCaption(i18n("change password for %1").arg(username));

    passDialog = new ChPassWidget (this);
    setMainWidget(passDialog);

    passDialog->label->setText(i18n("<b>change password for: %1</b>").arg(username));

    setMinimumSize(sizeHint());
}


ChPassDialog::~ChPassDialog() {
    delete passDialog;
    delete prcPass;
}


void ChPassDialog::slotOk() {
    QString pass1 = passDialog->pssPass->password ();
    QString pass2 = passDialog->pssRe->password ();

    if (pass1.isEmpty() || pass2.isEmpty()) {
        KMessageBox::sorry(this,i18n("password must be min one char!"));
    } else if (pass1 == pass2) {
        password =pass1;

        prcPass = new QProcess(this);

        prcPass->addArgument("pure-pw");
        prcPass->addArgument("passwd");
        prcPass->addArgument(user);
        prcPass->addArgument("-m");

        //start process
        if (!prcPass->start()) {
            KMessageBox::sorry(this,i18n("Unable to start process!"));
        } else {
            connect( prcPass, SIGNAL(readyReadStdout()), this, SLOT(readFromStdout()) );
            prcPass->writeToStdin(password+"\n");
            prcPass->writeToStdin(password+"\n");
        }

        this->close();
    } else {
        KMessageBox::sorry(this,i18n("Sorry passwords do not match!"));
        password ="";
    }

}

void ChPassDialog::slotCancel() {
    slotClose();
}

void ChPassDialog::readFromStdout() {
    stdout = prcPass->readLineStdout();


}
