  /*

  knetfilter v 2.1.0

  Copyright (C) 2001 Luigi Genoni
                     venom@DarkStar.sns.it
  */


#include <qlayout.h>
#include <qmultilinedit.h>
#include <qkeycode.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qstring.h>
#include <qstrlist.h>
#include <strings.h>

#include "knat.h"   

//  start mark rules

void knetfilter::addmarkRule() {

    QString mark, markchain, markpolicy, markrulepos, marksyn; 

    // let's check everything

    mark.sprintf((const char*)(markNumber->text()));
    markrulepos.sprintf((const char*)(markRuleNumber->text()));

    markaddp.clearArguments();

    if(mark.length()==0)
      {
	QMessageBox::critical(0, "Error",  
			      "You have to supply a mark number.\n");
      }
    else
      {
	if(markrulepos.length()==0)
	  {
	    markruleaction = "-A";
	    markrulepos.sprintf("-v");
	  }
	else
	  {
	    markruleaction = "-I";
	  }
	markaddp << "iptables" << markruleaction << markchainChoice << markrulepos << "-m" << "mark" << "--mark" << mark << "-j" << markpolicyChoice;

	  bool success=markaddp.start();
	if(success)
	  statusbar->message(i18n("Running..."), 2000);
	else
	  statusbar->message(i18n("Couldn't start iptables"), 2000);
      }
  };

//  stop mark rules            

void knetfilter::delmarkRule() {
    QString mark, markchain, markpolicy, markrulepos, marksyn; 

    // let's check everything

    mark.sprintf((const char*)(markNumber->text()));
    markrulepos.sprintf((const char*)(markRuleNumber->text()));

    markdelp.clearArguments();

    if(markrulepos.length()==0)
      {
	if(mark.length()==0)
	{
	  QMessageBox::critical(0, "Error",  
				"You have to supply a mark number.\n");
	}
	else
	{
	  markdelp << "iptables" << "-D" << markchainChoice << "-m" << "mark" << "--mark" << mark << "-j" << markpolicyChoice;
	}
      }
       else
      {
	markdelp << "iptables" << "-D" << markchainChoice << markrulepos;
      }

    bool success=markdelp.start();
    if(success)
      statusbar->message(i18n("Running..."), 2000);
    else
      statusbar->message(i18n("Couldn't start iptables"), 2000);

  };


//  open windows

void knetfilter::markRules() {
  if ( markList == NULL )
      {
	
	//	DBG(KNFDEBUG, "Creating markList");  
	setupConnect();
	
	markList = new KNFWidget();
	markList->resize(640,380);
	markList->setCaption("Set Mark based Rules");
	
	QBoxLayout *top = new QBoxLayout(markList, QBoxLayout::LeftToRight, 10);
	QGridLayout *grid = new QGridLayout(10,10); 
	top->addLayout(grid,10);  

	QLabel *markIntro = new QLabel(markList);
	markIntro->setText("Now you can choice what to do about");
	QLabel *markIntro2 = new QLabel(markList);
	markIntro2->setText("the packets you marked with mangling");
	QLabel *markIntro3 = new QLabel(markList);
	markIntro3->setText("in PREROUTING!!");

	grid->addMultiCellWidget(markIntro,0,0,0,3);
	grid->addMultiCellWidget(markIntro2,1,1,0,3);
	grid->addMultiCellWidget(markIntro3,2,2,0,3);

	QLabel *labelmarkNumber = new QLabel(markList);
	labelmarkNumber->setText("MARK:"); 

	markNumber = new QLineEdit(markList);
	markNumber->setFixedHeight(markNumber->sizeHint().height());
	markNumber->setText("");

	grid->addMultiCellWidget(labelmarkNumber,4,4,0,1);
	grid->addMultiCellWidget(markNumber,4,4,2,3);

	QLabel *labelmarkRuleNumber = new QLabel(markList);
	labelmarkRuleNumber->setText("Rule Position:"); 
	
	markRuleNumber = new QLineEdit(markList);
	markRuleNumber->setFixedHeight(markRuleNumber->sizeHint().height());
	markRuleNumber->setText("");

	grid->addMultiCellWidget(labelmarkRuleNumber,5,5,0,2);
	grid->addMultiCellWidget(markRuleNumber,5,5,2,3);

	QLabel *labelmarkChain = new QLabel(markList);
	labelmarkChain->setText("Chain:");
	
	markchain = new QComboBox( FALSE, markList, "Chain");
	markchain->insertItem("INPUT");
	markchain->insertItem("OUTPUT");
	markchain->insertItem("FORWARD");
	markchain->setFixedHeight(markchain->sizeHint().height());
	connect(markchain,SIGNAL(activated(int)), SLOT(markchainActivated(int)));
	
	grid->addMultiCellWidget(labelmarkChain,4,4,5,6);
	grid->addMultiCellWidget(markchain,4,4,6,7);
	
	
	QLabel *labelmarkPolicy = new QLabel(markList);
	labelmarkPolicy->setText("Policy:");
	
	markpolicy = new QComboBox( FALSE, markList, "Policy");
	markpolicy->insertItem("DROP");
	markpolicy->insertItem("REJECT");
	markpolicy->insertItem("ACCEPT");
	markpolicy->insertItem("RETURN");                 
	markpolicy->insertItem("QUEUE");
	markpolicy->insertItem("MIRROR");
	markpolicy->setFixedHeight(markpolicy->sizeHint().height());
	connect(markpolicy,SIGNAL(activated(int)), SLOT(markpolicyActivated(int)));
	
	grid->addMultiCellWidget(labelmarkPolicy,5,5,5,6);
	grid->addMultiCellWidget(markpolicy,5,5,6,7);

	/*	QLabel *labelmarkFlag = new QLabel(markList);
	labelmarkFlag->setText("tcp flags:");
	
      	markflags = new QComboBox( FALSE, markList, "Flags");
	markflags->insertItem(" ");
	markflags->insertItem("SYN");
	markflags->setFixedHeight(markflags->sizeHint().height());
	connect(markflags,SIGNAL(activated(int)), SLOT(markflagsActivated(int)));
	
	grid->addMultiCellWidget(labelmarkFlag,6,6,5,6);
	grid->addMultiCellWidget(markflags,6,6,6,7); */


	QPushButton *btnRules = new QPushButton(markList);
	btnRules->setText("Commit");
	btnRules->setFixedHeight(btnRules->sizeHint().height());
	connect(btnRules,SIGNAL(clicked()), this, SLOT(addmarkRule()));
	grid->addWidget(btnRules,9,1);                   

	QPushButton *btnDelete = new QPushButton(markList);
	btnDelete->setText("Delete");
	btnDelete->setFixedHeight(btnDelete->sizeHint().height());
	connect(btnDelete,SIGNAL(clicked()), this, SLOT(delmarkRule()));
	grid->addWidget(btnDelete,9,5);                   
 
	QPushButton *btnClose = new QPushButton(markList);
	btnClose->setText("Close");
	btnClose->setFixedHeight(btnClose->sizeHint().height());
	connect(btnClose,SIGNAL(clicked()), this, SLOT(closemarkRules()));
	grid->addWidget(btnClose,9,7);                   
     
      
	markList->show();
	setView(markList);
      }
    else
      
{
      if( !markList->isVisible() )
	{
	  markList->show();
	}
      else
	{
	  QMessageBox::critical(0,"Warning", "Already Running\n");
	}
    }
  };

void knetfilter::setmarkRules(KProcess *, char *data, int len) {
  if(len<0)
    return;
  static QString remainder;
  QString list;

  char dst[len+1];
  memmove(dst,data,len);
  dst[len]=0;

  list=remainder+dst;
  QStrList lines;
  int index=0;
  int newindex=0;

  while (1)
    {
      newindex=list.find('\n',index);
      if(newindex==-1) {
	remainder=list.right(list.length()-index);
	break;
      } else {
	lines.append(list.mid(index,newindex-index));
	index=newindex+1;
      };
    };
};
  

void knetfilter::closemarkRules() {

  markList->close();

};

// log facilities

void knetfilter::addmarkDone() {
  if (markaddp.normalExit() && (markaddp.exitStatus()==0)) {
    statusbar->message(i18n("Rule added"), 2000);
    QString msg;
    msg.sprintf("%s for packets marked as %s, %s chain", markpolicyChoice, ((const char*)(markNumber->text())), markchainChoice);
    messageLog->insertItem(msg);
    markNumber->clear();
    markRuleNumber->clear();
  } else
  statusbar->message(i18n("iptables died"), 2000); 
  markNumber->setFocus();
  markRuleNumber->setFocus();  
  };

void knetfilter::delmarkDone() {
  if (markdelp.normalExit() && (markdelp.exitStatus()==0)) {
    statusbar->message(i18n("Rule deleded"), 2000);
    QString msg;
    msg.sprintf("%s for packets marked as %s, %s chain", markpolicyChoice, ((const char*)(markNumber->text())), markchainChoice);
    messageLog->insertItem(msg);
    markNumber->clear();
    markRuleNumber->clear();
    
  } else
    statusbar->message(i18n("iptables died"), 2000); 
  markNumber->setFocus();
  markRuleNumber->setFocus();  
  };

// ComboBox contents

void knetfilter::markchainActivated(int index) {
  switch(index) {
  default:
    markchainChoice = "INPUT";
  case 0:
    markchainChoice = "INPUT";
    break;
  case 1:
    markchainChoice = "OUTPUT";
    break;
  case 2:
    markchainChoice = "FORWARD";
    break;
  };
};           


void knetfilter::markpolicyActivated(int index) {
  switch(index) {
  default:
    markpolicyChoice = "DROP";
  case 0:
    markpolicyChoice = "DROP";
    break;
  case 1:
    markpolicyChoice = "REJECT";
    break;
  case 2:
    markpolicyChoice = "ACCEPT";
    break;
  case 3:
    markpolicyChoice = "RETURN";
    break;
  case 4:
    markpolicyChoice = "QUEUE";
    break;
  case 5:
    markpolicyChoice = "MIRROR";
    break;                        
  };
};


void knetfilter::markflagsActivated(int index) {
  switch(index) {
  default:
    markflagChoice = "-v";
  case 0:
    markflagChoice = "-v";
    break;
  case 1:
    markflagChoice = "--syn";
    break;
  };
};

