/***************************************************************************
                          UserDialog.cpp  -  description
                             -------------------
    begin                : Tue Sep 19 2000
    copyright            : (C) 2000 by Henrik Stormer
    email                : stormer@ifi.unizh.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/****************************************************************************
** Form implementation generated from reading ui file 'UserDialog.ui'
**
** Created: Tue Sep 19 18:01:06 2000
**      by:  The User Interface Compiler (uic)
**
** WARNING! All changes made in this file will be lost!
****************************************************************************/
#include "userdialog.h"

#include <qgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qvaluelist.h>

#include <kfiledialog.h>
#include <kkeydialog.h>
#include <kaction.h>
#include <kmessagebox.h>

#include "usercommands.h"
#include "kncicondialog.h"
#include "selectdialog.h"

UserDialog::UserDialog(UserCommands* Commands, QWidget* parent,  const char* name)
    : BaseDialog(parent, name), _Commands(Commands)
{
    if ( !name )
	setName( "UserDialog" );
    resize( 544, 541 );
    setCaption( tr( "User Commands"  ) );
    setSizeGripEnabled( TRUE );

    GroupBox1 = new QGroupBox( this, "GroupBox1" );
    GroupBox1->setGeometry( QRect( 10, 160, 520, 120 ) );
    GroupBox1->setTitle( tr( "Settings"  ) );

    TextLabel2 = new QLabel( GroupBox1, "TextLabel2" );
    TextLabel2->setGeometry( QRect( 90, 70, 70, 20 ) );
    TextLabel2->setText( tr( "Command"  ) );

    TextLabel1 = new QLabel( GroupBox1, "TextLabel1" );
    TextLabel1->setGeometry( QRect( 90, 30, 70, 20 ) );
    TextLabel1->setText( tr( "Name"  ) );

    _IconButton = new QPushButton( GroupBox1, "_IconButton" );
    _IconButton->setGeometry( QRect( 10, 30, 60, 60 ) );
    _IconButton->setText( tr( ""  ) );

    _Command = new QLineEdit( GroupBox1, "_Command" );
    _Command->setGeometry( QRect( 190, 70, 300, 22 ) );

    _Name = new QLineEdit( GroupBox1, "_Name" );
    _Name->setGeometry( QRect( 190, 30, 300, 22 ) );
    _Name->setEnabled(false);

    _New = new QPushButton( this, "_New" );
    _New->setGeometry( QRect( 410, 20, 116, 31 ) );
    _New->setText( tr( "New"  ) );

    _Change = new QPushButton( this, "_Change" );
    _Change->setGeometry( QRect( 410, 70, 116, 31 ) );
    _Change->setText( tr( "Change"  ) );

    _Delete = new QPushButton( this, "_Delete" );
    _Delete->setGeometry( QRect( 410, 120, 116, 31 ) );
    _Delete->setText( tr( "Delete"  ) );

    _ListBox = new QListBox( this, "_ListBox" );
    _ListBox->setGeometry( QRect( 10, 20, 370, 130 ) );

    _OK = new QPushButton( this, "_OK" );
    _OK->setGeometry( QRect( 210, 500, 116, 31 ) );
    _OK->setText( tr( "OK"  ) );

    GroupBox2 = new QGroupBox( this, "GroupBox2" );
    GroupBox2->setGeometry( QRect( 10, 290, 520, 190 ) );
    GroupBox2->setTitle( tr( "Command Usage"  ) );

    TextLabel3 = new QLabel( GroupBox2, "TextLabel3" );
    TextLabel3->setGeometry( QRect( 30, 30, 150, 20 ) );
    TextLabel3->setText( tr( "%[first][second] with:"  ) );

    GroupBox4 = new QGroupBox( GroupBox2, "GroupBox4" );
    GroupBox4->setGeometry( QRect( 260, 50, 250, 130 ) );
    GroupBox4->setTitle( tr( "[second]"  ) );

    TextLabel14 = new QLabel( GroupBox4, "TextLabel14" );
    TextLabel14->setGeometry( QRect( 10, 20, 20, 20 ) );
    TextLabel14->setText( tr( "f"  ) );

    TextLabel17 = new QLabel( GroupBox4, "TextLabel17" );
    TextLabel17->setGeometry( QRect( 10, 40, 20, 20 ) );
    TextLabel17->setText( tr( "F"  ) );

    TextLabel13 = new QLabel( GroupBox4, "TextLabel13" );
    TextLabel13->setGeometry( QRect( 10, 60, 30, 20 ) );
    TextLabel13->setText( tr( "l"  ) );

    TextLabel18 = new QLabel( GroupBox4, "TextLabel18" );
    TextLabel18->setGeometry( QRect( 60, 40, 130, 20 ) );
    TextLabel18->setText( tr( "filename and path"  ) );

    TextLabel11 = new QLabel( GroupBox4, "TextLabel11" );
    TextLabel11->setGeometry( QRect( 60, 60, 180, 20 ) );
    TextLabel11->setText( tr( "selected file(s) without path"  ) );

    TextLabel16 = new QLabel( GroupBox4, "TextLabel16" );
    TextLabel16->setGeometry( QRect( 60, 20, 140, 20 ) );
    TextLabel16->setText( tr( "filename without path"  ) );

    TextLabel1_2 = new QLabel( GroupBox4, "TextLabel1_2" );
    TextLabel1_2->setGeometry( QRect( 60, 80, 160, 20 ) );
    TextLabel1_2->setText( tr( "selected file(s) and path"  ) );

    TextLabel2_2 = new QLabel( GroupBox4, "TextLabel2_2" );
    TextLabel2_2->setGeometry( QRect( 10, 80, 20, 20 ) );
    TextLabel2_2->setText( tr( "L"  ) );

    TextLabel7 = new QLabel( GroupBox4, "TextLabel7" );
    TextLabel7->setGeometry( QRect( 10, 100, 20, 20 ) );
    TextLabel7->setText( tr( "d"  ) );

    TextLabel8 = new QLabel( GroupBox4, "TextLabel8" );
    TextLabel8->setGeometry( QRect( 60, 100, 40, 20 ) );
    TextLabel8->setText( tr( "path"  ) );

    GroupBox3 = new QGroupBox( GroupBox2, "GroupBox3" );
    GroupBox3->setGeometry( QRect( 10, 50, 250, 130 ) );
    GroupBox3->setTitle( tr( "[first]"  ) );

    TextLabel5 = new QLabel( GroupBox3, "TextLabel5" );
    TextLabel5->setGeometry( QRect( 10, 20, 20, 20 ) );
    TextLabel5->setText( tr( "a"  ) );

    TextLabel6 = new QLabel( GroupBox3, "TextLabel6" );
    TextLabel6->setGeometry( QRect( 10, 40, 20, 20 ) );
    TextLabel6->setText( tr( "l"  ) );

    TextLabel12 = new QLabel( GroupBox3, "TextLabel12" );
    TextLabel12->setGeometry( QRect( 10, 60, 20, 20 ) );
    TextLabel12->setText( tr( "r"  ) );

    TextLabel9 = new QLabel( GroupBox3, "TextLabel9" );
    TextLabel9->setGeometry( QRect( 60, 20, 110, 20 ) );
    TextLabel9->setText( tr( "current listbox"  ) );

    TextLabel10 = new QLabel( GroupBox3, "TextLabel10" );
    TextLabel10->setGeometry( QRect( 60, 40, 120, 20 ) );
    TextLabel10->setText( tr( "left listbox"  ) );

    TextLabel15 = new QLabel( GroupBox3, "TextLabel15" );
    TextLabel15->setGeometry( QRect( 60, 60, 110, 20 ) );
    TextLabel15->setText( tr( "right listbox"  ) );

    TextLabel5_2 = new QLabel( GroupBox3, "TextLabel5_2" );
    TextLabel5_2->setGeometry( QRect( 20, 100, 70, 20 ) );
    TextLabel5_2->setText( tr( ""  ) );

    TextLabel4 = new QLabel( GroupBox3, "TextLabel4" );
    TextLabel4->setGeometry( QRect( 10, 80, 30, 20 ) );
    TextLabel4->setText( tr( "s(T)"  ) );

    TextLabel6_2 = new QLabel( GroupBox3, "TextLabel6_2" );
    TextLabel6_2->setGeometry( QRect( 60, 80, 140, 20 ) );
    TextLabel6_2->setText( tr( "Input Box with Title T"  ) );

    // tab order
    setTabOrder( _ListBox, _OK );
    setTabOrder( _OK, _New );
    setTabOrder( _New, _Delete );
    setTabOrder( _Delete, _Name );
    setTabOrder( _Name, _Command );

    connect(_OK, SIGNAL(clicked()), SLOT(slotOk()));

    initConfig();
}

/*  
 *  Destroys the object and frees any allocated resources
 */
UserDialog::~UserDialog()
{
    // no need to delete child widgets, Qt does it all for us
}

void UserDialog::showCommand(const UserCommandEntry& Entry)
{
  _Name->setText(Entry._Name);
  _Command->setText(Entry._Command);
  _IconButton->setPixmap(KGlobal::iconLoader()->loadIcon(Entry._IconName, KIcon::Desktop));
  _ActFileName = Entry._IconName;
}

void UserDialog::initConfig()
{
  QValueList<UserCommandEntry>::Iterator it = _Commands->_Commands.begin();
  for (;it != _Commands->_Commands.end();it++)
  {
    _ListBox->insertItem((*it)._Name);
  }
  connect (_ListBox, SIGNAL(highlighted(const QString&)), SLOT(slotSelected(const QString&)));
  connect (_New, SIGNAL(clicked()), SLOT(slotAdd()));
  connect (_Change, SIGNAL(clicked()), SLOT(slotChange()));
  connect (_Delete, SIGNAL(clicked()), SLOT(slotDelete()));
  connect (_IconButton, SIGNAL(clicked()), SLOT(slotChangeIcon()));

  _ActCommand = _Commands->_Commands.end();
  if (_ListBox->count() > 0) _ListBox->setSelected(0, true);
}

void UserDialog::saveActConfig()
{
 if (_ActCommand == _Commands->_Commands.end()) return;
 (*_ActCommand)._Name = _Name->text();
 (*_ActCommand)._Command = _Command->text();
 (*_ActCommand)._IconName = _ActFileName;
}

void UserDialog::slotSelected(const QString& Name)
{
  QValueList<UserCommandEntry>::Iterator it = _Commands->_Commands.find(Name);
  if (it != _Commands->_Commands.end())
  {
    saveActConfig();
    _ActCommand = it;
    showCommand(*it);
  }
  else KMessageBox::error(this, "Internal Error in Select!");
}

void UserDialog :: slotAdd()
{
  SelectDialog Dialog(this, 0, "Insert new Command Name: ");
  if (!Dialog.exec()) return;

  _Commands->addEntry(Dialog.getText(), "", "");
  _ListBox->insertItem(Dialog.getText());
  _ListBox->setCurrentItem(_ListBox->index(_ListBox->findItem(Dialog.getText())));
}

void UserDialog :: slotDelete()
{
 if (_ListBox->currentItem() != -1)
 {
   _Commands->removeEntry((*_ActCommand)._Name);
   _ActCommand = _Commands->_Commands.end();
   delete _ListBox->item(_ListBox->currentItem());
//   if (_ListBox->count() > 0) _ListBox->setSelected(0,true);
 }
}

void UserDialog :: slotChangeIcon()
{
  KNCIconDialog Dialog;
  if (Dialog.exec())
  {
    _ActFileName = Dialog.getSelectedIconName();
    _IconButton->setPixmap(KGlobal::iconLoader()->loadIcon(_ActFileName, KIcon::Desktop));
  }
}

void UserDialog :: slotOk()
{
  saveActConfig();
  BaseDialog::slotOk();
}