/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Tue Aug 29 14:51:43 CEST 2000
    copyright            : (C) 2000 by Henrik Stormer
    email                : stormer@ifi.unizh.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "config.h"

#include "knc.h"
#include <kapp.h>

static const char *description =
	I18N_NOOP("KNC");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
	
	
static KCmdLineOptions options[] =
{
  { "+[File]", I18N_NOOP("file to open"), 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{

	KAboutData aboutData( "knc", I18N_NOOP("KNC"),
		VERSION, description, KAboutData::License_GPL,
		"(c) 2000, Henrik Stormer");
	aboutData.addAuthor("Henrik Stormer",0, "stormer@ifi.unizh.ch");
	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication app;
 
  if (app.isRestored())
  {
    RESTORE(KNCApp);
  }
  else 
  {
    KNCApp *knc = new KNCApp();
    knc->show();

  }
  return app.exec();
}  
