/***************************************************************************
                          knc.cpp  -  description
                             -------------------
    begin                : Tue Aug 29 14:51:43 CEST 2000
    copyright            : (C) 2000 by Henrik Stormer
    email                : stormer@ifi.unizh.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include <iostream.h>
#include <pwd.h>
#include <grp.h>
#include <unistd.h>

// include files for QT
#include <qdir.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qmessagebox.h>
// include files for KDE
#include <krun.h>
#include <kstdaction.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kconfig.h>
#include <kapp.h>
#include <kaction.h>
#include <klibloader.h>
#include <kuserprofile.h>
#include <ktrader.h>
#include <kkeydialog.h>
#include <kedittoolbar.h>
#include <kio/job.h>
#include <kbookmarkmenu.h>
#include <kpopupmenu.h>
#include <kopenwith.h>
#include <kmimetype.h>
#include <ktoolbarbutton.h>
// application specific includes
#include "helpfuncs.h"
#include "knc.h"
#include "kncview.h"
#include "kncfilecommand.h"
#include "selectdialog.h"
#include "knccommandtoolbar.h"
#include "knclistviewitem.h"
#include "kncdirectorytoolbar.h"
#include "attributedialog.h"
#include "knccursortoolbar.h"
#include "usercommands.h"
#include "optiondialog.h"

KNCApp::KNCApp() : _Part(0L), _bShowPartComplete(true), _bUseParts(false)
{

  setXMLFile ("kncui.rc");
  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initKeyAccel();
  initMenuBar();
  initToolBar();
  initStatusBar();
  initView();

  readSettings(kapp->config());
}

KNCApp::~KNCApp()
{
  delete _UserCommands;
}

void KNCApp::initKeyAccel()
{
  (void)new KAction(i18n("&Copy"), UserIcon("copy"), Key_F5, this, SLOT(slotCommandCopy()),
                    actionCollection(), "copy");
  (void)new KAction(i18n("&Move"), UserIcon("move"), Key_F6, this, SLOT(slotCommandMove()),
                    actionCollection(), "move");
  (void)new KAction(i18n("&New Directory"), "folder_new", Key_F7, this, SLOT(slotCommandNewDir()),
                    actionCollection(), "newdir");
  (void)new KAction(i18n("&Delete"), "edittrash", Key_F8, this, SLOT(slotCommandDelete()),
                    actionCollection(), "delete");
  (void)new KAction(i18n("&OpenUserMenu"), Key_F9, this, SLOT(slotCommandOpenUserMenu()),
                    actionCollection(), "openusermenu");
  (void)new KAction(i18n("&Select"), Key_Plus, this, SLOT(slotCommandSelect()),
                    actionCollection(), "select");
  (void)new KAction(i18n("&Unselect"), Key_Minus, this, SLOT(slotCommandUnselect()),
                    actionCollection(), "unselect");
//  (void)new KAction(i18n("&Open Find Utility"), "find", CTRL+Key_F, this, SLOT(slotCommandOpenFindUtility()),
//                    actionCollection(), "openfindutility");
//  (void)new KAction(i18n("&Open Terminal"), UserIcon("terminal"), CTRL+Key_T, this, SLOT(slotCommandOpenTerminal()),
//                    actionCollection(), "openterminal");
  (void)new KAction(i18n("&Change Attributes"), UserIcon("changeattrib"), CTRL+Key_A, this, SLOT(slotCommandChangeAttributes()),
                    actionCollection(), "changeattributes");
  KStdAction::quit(this, SLOT(slotCommandQuit()), actionCollection(), "quit");

  // Bookmarks menu
  _Bookmarks = new KActionMenu( i18n( "&Bookmarks" ), actionCollection(), "bookmarks" );
  _BookmarkMenu = new KBookmarkMenu( this, _Bookmarks->popupMenu(), actionCollection(), true );


  _ViewToolBarAction = (KToggleAction*) KStdAction::showToolbar(this, SLOT(slotViewToolBar()), actionCollection(), "viewtoolbar");
  _ViewCursorAction = new KToggleAction(i18n("&Show Cursor Line"), 0, this, SLOT(slotViewCursorLine()),
                    actionCollection(), "viewcursorline");
  _ViewCommandAction = new KToggleAction(i18n("&Show Command Line"), 0, this, SLOT(slotViewCommandLine()),
                    actionCollection(), "viewcommandline");
  _ViewDirectoryAction = new KToggleAction(i18n("&Show Directory Line"), 0, this, SLOT(slotViewDirectoryLine()),
                    actionCollection(), "viewdirectoryline");
//  (void)new KAction(i18n("&Remove Part"), CTRL+Key_Escape, this, SLOT(slotRemovePart()),
//                    actionCollection(), "removepart");

  KStdAction::home(this, SLOT(slotCommandHome()), actionCollection(), "home");
  KStdAction::preferences(this, SLOT(slotOptionsPreferences()), actionCollection(), "preferences");
  KStdAction::keyBindings(this, SLOT(slotOptionsEditKeys()), actionCollection(),"configurekeys");
  KStdAction::configureToolbars(this, SLOT(slotOptionsEditToolBar()), actionCollection(),"configuretoolbars");

  KStdAction::up(this, SLOT(slotCommandUp()), actionCollection(), "up" );
  KStdAction::redisplay(this, SLOT(slotCommandRefresh()), actionCollection(), "refresh" );

  KActionMenu* Commands = new KActionMenu( i18n( "&User Commands" ), actionCollection(), "commands" );
  _UserCommands = new UserCommands(kapp->config(), actionCollection(), Commands->popupMenu());
  connect (_UserCommands, SIGNAL(executeCommand(const QString&)), SLOT(slotExecuteCommand(const QString&)));
}


void KNCApp::slotCommandHome()
{
  _ActListView->openURL(QDir::homeDirPath());
}

void KNCApp::slotCommandUp()
{
  _ActListView->slotDirectoryUp();
}

void KNCApp::initMenuBar()
{
}

void KNCApp::initToolBar()
{

  _DirectoryToolBar = new KNCDirectoryToolBar(this, "DirectoryToolBar");
  addToolBar(_DirectoryToolBar, Top);
  _DirectoryToolBar->show();

  _DirectoryToolBar->getLeft()->setFocusPolicy(ClickFocus);
  _DirectoryToolBar->getRight()->setFocusPolicy(ClickFocus);

  connect (_DirectoryToolBar->getLeft(), SIGNAL(returnPressed()), SLOT(slotLeftReturnPressed()));
  connect (_DirectoryToolBar->getRight(), SIGNAL(returnPressed()), SLOT(slotRightReturnPressed()));

  _CursorToolBar = new KNCCursorToolBar(this, "CursorToolBar");
  addToolBar(_CursorToolBar, Bottom);
  _CursorToolBar->show();

  _CommandToolBar = new KNCCommandToolBar(this, "CommandToolBar");
  addToolBar(_CommandToolBar, Bottom);
  _CommandToolBar->show();
  _CommandToolBar->getEdit()->setFocusPolicy(ClickFocus);

  connect(this, SIGNAL(directoryChanged(const KURL&)), _CommandToolBar, SLOT(slotSetDirectory(const KURL&)));
  connect(_CommandToolBar->getEdit(), SIGNAL(returnPressed()), SLOT(slotExecuteCommandLine()));

//  toolBar("mainToolBar")->setXMLGUIClient(this);
//  toolBar("DirectoryToolBar")->setXMLGUIClient(this);
//  toolBar("CommandToolBar")->setXMLGUIClient(this);
}

void KNCApp::initStatusBar()
{
}

void KNCApp::initView()
{
  _LRSplitter = new QSplitter(this);
  _LeftListView = new KNCListView(_LRSplitter);
  _RightListView = new KNCListView(_LRSplitter);

  _ActListView = _LeftListView;

  setCentralWidget(_LRSplitter);

  connect(_LeftListView, SIGNAL(focusIn()),SLOT(slotLeftViewFocusIn()));
  connect(_RightListView, SIGNAL(focusIn()),SLOT(slotRightViewFocusIn()));
  connect(_LeftListView, SIGNAL(cursorChanged()), SLOT(slotLeftCursorChanged()));
  connect(_RightListView, SIGNAL(cursorChanged()), SLOT(slotRightCursorChanged()));
  connect(_LeftListView, SIGNAL(selectChanged()), SLOT(slotLeftSelectionChanged()));
  connect(_RightListView, SIGNAL(selectChanged()), SLOT(slotRightSelectionChanged()));
  connect(_LeftListView, SIGNAL(directoryChanged(const KURL&)), SLOT(slotLeftDirectoryChanged(const KURL&)));
  connect(_RightListView, SIGNAL(directoryChanged(const KURL&)), SLOT(slotRightDirectoryChanged(const KURL&)));
  connect(_LeftListView, SIGNAL(executeFile(const KURL&)), SLOT(slotExecuteFile(const KURL&)));
  connect(_RightListView, SIGNAL(executeFile(const KURL&)), SLOT(slotExecuteFile(const KURL&)));

  connect (_CursorToolBar->getLeftSizeButton(), SIGNAL(clicked()), _LeftListView, SLOT(slotCalculateDirSize()));
  connect (_CursorToolBar->getRightSizeButton(), SIGNAL(clicked()), _RightListView, SLOT(slotCalculateDirSize()));

  _LeftListView->setFocus();
  createGUI(_Part);

}


void KNCApp::saveSettings(KConfig* Config)
{	
  _LeftListView->saveSettings(Config, "LeftListView");
  _RightListView->saveSettings(Config, "RightListView");

  Config->setGroup("General Options");
  Config->writeEntry("Geometry", size());
  Config->writeEntry("Position", pos());
  Config->writeEntry("View Toolbar", toolBar("mainToolBar")->isVisible());
  Config->writeEntry("View Cursor Line",toolBar("CursorToolBar")->isVisible());
  Config->writeEntry("View Directory Line", toolBar("DirectoryToolBar")->isVisible());
  Config->writeEntry("View Command Line",  toolBar("CommandToolBar")->isVisible());

  //this is only until XML is working correctly
  toolBar("mainToolBar")->saveSettings(Config, "mainToolBar");
  toolBar("DirectoryToolBar")->saveSettings(Config, "DirectoryToolBar");
  toolBar("CursorToolBar")->saveSettings(Config, "CursorToolBar");
  toolBar("CommandToolBar")->saveSettings(Config, "CommandToolBar");
//  toolBar("mainToolBar")->saveState();
//  toolBar("DirectoryToolBar")->saveState();
//  toolBar("CommandToolBar")->saveState();
}


void KNCApp::readSettings(KConfig* Config)
{
  _LeftListView->readSettings(Config, "LeftListView");
  _RightListView->readSettings(Config, "RightListView");
	
  _Edit = "kwrite";
  _View = "kedit";
  _Terminal = "ktv";
  _Find = "kfind";
  Config->setGroup("General Options");

  // bar status settings
  bool b = Config->readBoolEntry("View Toolbar", true);
  _ViewToolBarAction->setChecked(b);
//  if(!b) toolBar("mainToolBar")->hide();
	
  b = Config->readBoolEntry("View Cursor Line", true);
  _ViewCursorAction->setChecked(b);
//  if(!b) statusBar()->hide();

  b = Config->readBoolEntry("View Directory Line", true);
  _ViewDirectoryAction->setChecked(b);
//  if(!b) toolBar("DirectoryToolBar")->hide();

  b = Config->readBoolEntry("View Command Line", true);
  _ViewCommandAction->setChecked(b);
//  viewMenu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
//  if(!b) toolBar("CommandToolBar")->hide();

  //this is only until XML is working correctly
  toolBar("mainToolBar")->applySettings(Config, "mainToolBar");
  toolBar("DirectoryToolBar")->applySettings(Config, "DirectoryToolBar");
  toolBar("CursorToolBar")->applySettings(Config, "CursorToolBar");
  toolBar("CommandToolBar")->applySettings(Config, "CommandToolBar");


  QSize size= Config->readSizeEntry("Geometry");
  if(!size.isEmpty())
    resize(size);

  QPoint pos = Config->readPointEntry("Position");
  move(pos);
}

void KNCApp::setActListView (bool LeftView)
{
  if ((LeftView) && (_ActListView != _LeftListView))
  {
    _ActListView = _LeftListView;
    _ActListView->setFocus();
    emit directoryChanged(_ActListView->getURL());
  }
  if ((!LeftView) && (_ActListView != _RightListView))
  {
    _ActListView = _RightListView;
    _ActListView->setFocus();
    emit directoryChanged(_ActListView->getURL());
  }
}

void KNCApp::slotLeftViewFocusIn()
{
 setActListView(true);
}
void KNCApp::slotRightViewFocusIn()
{
 setActListView(false);
}

void KNCApp::slotCommandLineFocusIn()
{}

void KNCApp::slotCommandLineFocusOut()
{}


void KNCApp::slotCommandRefresh()
{
  _ActListView->slotRefresh();
}
void KNCApp::slotCommandView()
{
  KNCListViewItem* Item = (KNCListViewItem*) _ActListView->currentItem();
  QString command = _View + " \"" + Item->getFileItem()->url().path() + "\" &";
  system(command);
}
void KNCApp::slotCommandEdit()
{
  KNCListViewItem* Item = (KNCListViewItem*) _ActListView->currentItem();
  QString command = _Edit + " \"" + Item->getFileItem()->url().path() + "\" &";
  system(command);
}
void KNCApp::slotCommandCopy()
{
 KNCListView *Source, *Target;

 if (_ActListView == _LeftListView) {Source = _LeftListView; Target = _RightListView;}
 else {Source = _RightListView, Target = _LeftListView;}

 SelectDialog Select (this, i18n("Copy"), i18n("Copy file(s) to"), Target->getURL().url());
 if (Select.exec())
 {
   KURL URL = Select.getText();
   if (URL.isMalformed()) {KURL URLT; URLT.setPath(Select.getText()); URL = URLT;}
   KNCFileCommand::instance().copy(Source->getSelectedURLs(), URL);
 }
}
void KNCApp::slotCommandMove()
{
 KNCListView *Source, *Target;

 if (_ActListView == _LeftListView) {Source = _LeftListView; Target = _RightListView;}
 else {Source = _RightListView, Target = _LeftListView;}

 SelectDialog Select (this, i18n("Move"), i18n("Move file(s) to"), Target->getURL().url());
 if (Select.exec())
 {
   KURL URL = Select.getText();
   if (URL.isMalformed()) {KURL URLT; URLT.setPath(Select.getText()); URL = URLT;}
   KNCFileCommand::instance().move(Source->getSelectedURLs(), URL);
 }
}

void KNCApp::slotCommandNewDir()
{
 KNCFileCommand::instance().newDir(_ActListView->getURL());
}
void KNCApp::slotCommandDelete()
{
 KNCFileCommand::instance().deleteFiles(_ActListView->getSelectedURLs());
}

void KNCApp::select(bool Selection, QString Text)
{
 SelectDialog Select (this, i18n("Selection"), Text,"*");
 if (Select.exec())
 {
   QRegExp RegExp(Select.getText(), true, true);
   if (!_ActListView->select(RegExp, Selection))
   {
     QMessageBox::information( this, i18n("knc"),
        i18n("The Wildcard you entered is not correct.") );
     return;
   }
 }

}

void KNCApp::slotCommandSelect()
{
 select(true, i18n("Select Files:"));
}

void KNCApp::slotCommandUnselect()
{
  select(false, i18n("Unselect Files:"));
}

void KNCApp::slotCommandOpenTerminal()
{
  QString command;
  command = QString("cd \"") + _ActListView->getURL().path() + "\";"+ _Terminal + "&";
  system(command);
}
void KNCApp::slotCommandOpenFindUtility()
{
  QString command;
  command = QString("cd \"") + _ActListView->getURL().path() + "\";"+ _Find + "&";
  system(command);
}

void setAttrib(char& State, int Permission, int Attrib)
{
  if (Permission & Attrib)
  {
     if (State == UNDEF) State = SET;
     if (State == UNSET) State = NOSTATE;
  }
  else
  {
     if (State == UNDEF) State = UNSET;
     if (State == SET)   State = NOSTATE;
  }
}

void KNCApp::slotCommandChangeAttributes()
{
 char ReadUser = UNDEF, ReadGroup = UNDEF, ReadOther = UNDEF;
 char WriteUser = UNDEF, WriteGroup = UNDEF, WriteOther = UNDEF;
 char ExecuteUser = UNDEF, ExecuteGroup = UNDEF, ExecuteOther = UNDEF;
 QString Owner = NULL;
 QString Group = NULL;
 QList<KFileItem> FileList = _ActListView->getSelectedItems();
 KFileItem* Item = FileList.first();
 while (Item != NULL)
 {
   int Attrib = Item->permissions();

   setAttrib(ReadUser, Attrib, QFileInfo::ReadUser);
   setAttrib(WriteUser,Attrib, QFileInfo::WriteUser);
   setAttrib(ExecuteUser, Attrib, QFileInfo::ExeUser);

   setAttrib(ReadGroup, Attrib, QFileInfo::ReadGroup);
   setAttrib(WriteGroup, Attrib, QFileInfo::WriteGroup);
   setAttrib(ExecuteGroup, Attrib, QFileInfo::ExeGroup);

   setAttrib(ReadOther, Attrib, QFileInfo::ReadOther);
   setAttrib(WriteOther, Attrib, QFileInfo::WriteOther);
   setAttrib(ExecuteOther, Attrib, QFileInfo::ExeOther);

   if (Owner == NULL) Owner = Item->user();
   if (Owner != Item->user()) Owner = "";

   if (Group == NULL) Group = Item->group();
   if (Group != Item->group()) Group = "";

   Item = FileList.next();
 }

 AttributeDialog ADialog(this, i18n("Change Attributes"));
 ADialog.setReadUser(ReadUser);
 ADialog.setWriteUser(WriteUser);
 ADialog.setExecuteUser(ExecuteUser);

 ADialog.setReadGroup(ReadGroup);
 ADialog.setWriteGroup(WriteGroup);
 ADialog.setExecuteGroup(ExecuteGroup);

 ADialog.setReadOther(ReadOther);
 ADialog.setWriteOther(WriteOther);
 ADialog.setExecuteOther(ExecuteOther);

 QStrList OwnerList, GroupList;

 bool Enabled = ((geteuid() == 0) && (FileList.first()->isLocalFile()));

 if (Owner) ADialog.setOwner(Owner, Enabled);
 if (Group) ADialog.setGroup(Group, Enabled);

 if (!ADialog.exec()) return;
 int SetAttrib = 0;
 int UnsetAttrib = 0;
 if (ADialog.getReadUser() == SET)  SetAttrib |= QFileInfo::ReadUser;
 if (ADialog.getReadUser() == UNSET) UnsetAttrib |= QFileInfo::ReadUser;
 if (ADialog.getWriteUser() == SET)  SetAttrib |= QFileInfo::WriteUser;
 if (ADialog.getWriteUser() == UNSET) UnsetAttrib |= QFileInfo::WriteUser;
 if (ADialog.getExecuteUser() == SET) SetAttrib |= QFileInfo::ExeUser;
 if (ADialog.getExecuteUser() == UNSET)UnsetAttrib |= QFileInfo::ExeUser;

 if (ADialog.getReadGroup() == SET) SetAttrib |= QFileInfo::ReadGroup;
 if (ADialog.getReadGroup() == UNSET) UnsetAttrib |= QFileInfo::ReadGroup;
 if (ADialog.getWriteGroup() == SET) SetAttrib |= QFileInfo::WriteGroup;
 if (ADialog.getWriteGroup() == UNSET) UnsetAttrib |= QFileInfo::WriteGroup;
 if (ADialog.getExecuteGroup() == SET) SetAttrib |= QFileInfo::ExeGroup;
 if (ADialog.getExecuteGroup() == UNSET) UnsetAttrib |= QFileInfo::ExeGroup;

 if (ADialog.getReadOther() == SET)  SetAttrib |= QFileInfo::ReadOther;
 if (ADialog.getReadOther() == UNSET) UnsetAttrib |= QFileInfo::ReadOther;
 if (ADialog.getWriteOther() == SET) SetAttrib |= QFileInfo::WriteOther;
 if (ADialog.getWriteOther() == UNSET) UnsetAttrib |= QFileInfo::WriteOther;
 if (ADialog.getExecuteOther() == SET) SetAttrib |= QFileInfo::ExeOther;
 if (ADialog.getExecuteOther() == UNSET) UnsetAttrib |= QFileInfo::ExeOther;

 Item = FileList.first();
 while(Item != NULL)
 {
   int Attrib = Item->permissions();
   Attrib |= SetAttrib;
   Attrib &= ~UnsetAttrib;
   KIO::chmod(Item->url(), Attrib);

   if ((ADialog.getOwner() != Owner) || (ADialog.getGroup() != Group))
   {
     struct passwd* pw = getpwnam(ADialog.getOwner());
     struct group* gr = getgrnam(ADialog.getGroup());
     if (( pw == 0L ) || ( gr == 0L ))  continue;

     if ( chown( Item->url().path(), pw->pw_uid, gr->gr_gid ) != 0 )
       KMessageBox::sorry( 0, i18n( "<qt>Could not modify the ownership of file <b>%1</b>.You have insufficient access to the file to perform the change.</qt>" ).arg(Item->url().path()));
   }
   Item = FileList.next();
 }
}

void KNCApp::slotCommandQuit()
{
  saveSettings(kapp->config());
  qApp->quit();
}

void KNCApp::slotViewToolBar()
{
  if(toolBar("mainToolBar")->isVisible()) toolBar("mainToolBar")->hide();
  else toolBar("mainToolBar")->show();
}

void KNCApp::slotViewCursorLine()
{
  if (toolBar("CursorToolBar")->isVisible()) toolBar("CursorToolBar")->hide();
  else toolBar("CursorToolBar")->show();
}

void KNCApp::slotViewDirectoryLine()
{
  if (toolBar("DirectoryToolBar")->isVisible()) toolBar("DirectoryToolBar")->hide();
  else toolBar("DirectoryToolBar")->show();
}

void KNCApp::slotViewCommandLine()
{
  if(toolBar("CommandToolBar")->isVisible()) toolBar("CommandToolBar")->hide();
  else toolBar("CommandToolBar")->show();
}

void KNCApp::slotBookmarkAdd()
{}

void KNCApp::slotBookmarkRemove()
{}
void KNCApp::slotBookmarkChosen(int id)
{}
void KNCApp::slotOptionsPreferences()
{
 KNCOptionDialog Dialog(this, 0, true);
 Dialog.exec();
}
void KNCApp::slotOptionsEditKeys()
{
  KKeyDialog::configureKeys(actionCollection(), xmlFile());
}

void KNCApp::slotOptionsEditToolBar()
{
  KEditToolbar dlg(factory());

  if (dlg.exec())
    createGUI(_Part);
}

void KNCApp::slotSelectionChanged(KNCListView* ListView)
{
  if (!ListView->isSelection()) return slotCursorChanged(ListView);

  QString Information =
       formatLong(ListView->getNumSelectedFiles()) + i18n(" files and ") +
       formatLong(ListView->getNumSelectedDirs()) + i18n(" directories selected using ") +
       formatLong(ListView->getSelectedSize()) + i18n(" bytes space");

  if (ListView == _LeftListView)
    _CursorToolBar->setLeftSide(Information, ListView->getNumSelectedDirs() > 0);
  else
    _CursorToolBar->setRightSide(Information, ListView->getNumSelectedDirs() > 0);
}

void KNCApp::slotLeftSelectionChanged() {slotSelectionChanged(_LeftListView);}
void KNCApp::slotRightSelectionChanged() {slotSelectionChanged(_RightListView);}


void KNCApp::slotCursorChanged(KNCListView* ListView)
{
  QString Information, Help;
  if (ListView->isSelection()) return slotSelectionChanged(ListView);
  else
  {
    KNCListViewItem* Item = (KNCListViewItem*) ListView->currentItem();
    if (!Item) Item = (KNCListViewItem*) ListView->firstChild();
    if (Item)
    {
      Information = Item->getFileItem()->name() + ";  ";
      if (Item->getFileItem()->isDir()) Information += QString("<DIR>");
      else Information += formatLong(Item->getFileItem()->size());
      Information += ";  " + createAttribString(Item->getFileItem()->permissions());
    }
  }
  if (ListView == _LeftListView)
    _CursorToolBar->setLeftSide(Information, false);
  else
    _CursorToolBar->setRightSide(Information, false);
}
void KNCApp::slotLeftCursorChanged() {slotCursorChanged(_LeftListView);}
void KNCApp::slotRightCursorChanged() {slotCursorChanged(_RightListView);}


void KNCApp::slotDirectoryChanged (KNCListView* ListView, const KURL& URL)
{
 QString Information;
 if (ListView->getURL().protocol() != "file")
   Information = ListView->getURL().url();
 else
   Information = ListView->getURL().path();

  if (ListView == _LeftListView)
    _DirectoryToolBar->setLeftText(Information);
  else
    _DirectoryToolBar->setRightText(Information);


 emit directoryChanged(URL);
}
void KNCApp::slotLeftDirectoryChanged(const KURL& URL) {slotDirectoryChanged(_LeftListView, URL);}
void KNCApp::slotRightDirectoryChanged(const KURL& URL) {slotDirectoryChanged(_RightListView, URL);}


void KNCApp::slotLeftReturnPressed()
{
 KURL URL(_DirectoryToolBar->getLeft()->text());
 _LeftListView->openURL(URL);
}

void KNCApp::slotRightReturnPressed()
{
 KURL URL(_DirectoryToolBar->getRight()->text());
 _RightListView->openURL(URL);
}

void KNCApp::slotExecute(const QString& Command)
{
  QString Cmd = Command;
  Cmd.prepend(QString("cd \"") + _ActListView->getURL().path() + "\"; ");
  KRun::runCommand(Cmd,"","");
}

void KNCApp::slotExecuteCommandLine()
{
 slotExecute(_CommandToolBar->getEdit()->text());
}

KNCListView* KNCApp::getInactiveListView()
{
 if (_ActListView == _LeftListView) return _RightListView;
 else return _LeftListView;
}

void KNCApp::addPart(KParts::ReadOnlyPart* Part)
{
 if (_Part) slotRemovePart();

 _Part = Part;
 createGUI(_Part);

 if (!_bShowPartComplete)
 {
   getInactiveListView()->hide();
   if (_ActListView == _RightListView)
   {
     _LeftListView->reparent(NULL, QPoint());
     _RightListView->reparent(NULL, QPoint());
   }

   _Part->widget()->reparent(_LRSplitter,QPoint());

   if (_ActListView == _RightListView)
     _RightListView->reparent(_LRSplitter, QPoint());
  }
  else
  {
    _LeftListView->hide();
    _RightListView->hide();
  }
  setCentralWidget(_Part->widget());
}

void KNCApp::slotRemovePart()
{
 if (!_Part) return;
 delete _Part;
 _Part = 0;

 createGUI(_Part);

 if (!_bShowPartComplete)
 {
   _LeftListView->reparent(NULL, QPoint());
   _RightListView->reparent(NULL, QPoint());
   _LeftListView->reparent(_LRSplitter, QPoint());
   _RightListView->reparent(_LRSplitter, QPoint());
 }

 _LeftListView->show();
 _RightListView->show();

 setCentralWidget(_LRSplitter);
}

void KNCApp::slotExecuteFile(const KURL& URL)
{
 KMimeType::Ptr MT = KMimeType::findByURL(URL);

 if (_bUseParts)
 {
   KTrader::OfferList offers;
   KTrader::OfferList::Iterator it;
   bool bReadOnly = false;

   //first try readwrite
   offers = KTrader::self()->query(MT->name(),"'KParts/ReadWritePart' in ServiceTypes");
   if (offers.isEmpty())
   {
     bReadOnly = true;
     offers = KTrader::self()->query(MT->name(),"'KParts/ReadOnlyPart' in ServiceTypes");
   }

   if (!offers.isEmpty())
   {
     it = offers.begin();
     KLibFactory *factory = KLibLoader::self()->factory( (*it)->library() );
     KParts::ReadOnlyPart* part;
     if (!factory) return;

     if (bReadOnly == false)
       part = static_cast<KParts::ReadWritePart *>(factory->create(this, (*it)->name(), "KParts::ReadWritePart"));
     else
       part = static_cast<KParts::ReadOnlyPart *>(factory->create(this, (*it)->name(), "KParts::ReadWritePart"));

     part->openURL(URL);

     addPart(part);
   }
 }
 else // try to load with krun
 {
   (void)new KFileOpenWithHandler();
   KRun::runURL(URL, MT->name());
 }
}

void KNCApp::openBookmarkURL(const QString& URL)
{
 _ActListView->openURL(URL);
}

QString KNCApp::currentTitle() const
{
 return _ActListView->getURL().url();
}

QString KNCApp::currentURL() const
{
 return _ActListView->getURL().url();
}
