/***************************************************************************
                          newproject1dlg.cpp  -  description
                             -------------------
    begin                : Thu Oct 28 1999
    copyright            : (C) 1999 by Franois Dupoux
    email                : fdupoux@lemel.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "newproject1dlg.h"
#include "kfilereplace.h"
#include "resource.h"

// Qt headers
#include <qfiledialog.h>

// KDE headers
#include <kconfig.h>
#include <kmsgbox.h>


// ===========================================================================================================================
NewProject1Dlg::NewProject1Dlg(QWidget *parent, const char *name) : QDialog(parent,name,true)
{
	initDialog();
	loadComboValues();

	connect(m_btnContinue,SIGNAL(clicked()),this,SLOT(slotContinue()));
 	connect(m_btnCancel,SIGNAL(clicked()),this,SLOT(reject()));
 	connect(m_btnDir,SIGNAL(clicked()),this,SLOT(slotDir()));
}

// ===========================================================================================================================
NewProject1Dlg::~NewProject1Dlg()
{
}

// ===========================================================================================================================
void NewProject1Dlg::loadComboValues()
{
  ///////////////////////////////////////////////////////////////////
  // read the config file entries
  KConfig *config = kapp->getConfig();
	QString str, strTemp;
	int i;

	// Combo box informations
	config->setGroup("Directories");
	for(i = 0; i < MAX_STRINGSINCOMBO; i++)
	{	strTemp.setNum(i+1);
		str = config->readEntry(strTemp, "");		
		if (!str.isEmpty())
			m_comboDirectory -> insertItem(str.data());
  }

	config->setGroup("Filters");
	for(i = 0; i < MAX_STRINGSINCOMBO; i++)
	{	strTemp.setNum(i+1);
		str = config->readEntry(strTemp, "");		
		if (!str.isEmpty())
			m_comboFilter -> insertItem(str.data());
  }
}

// ===========================================================================================================================
void NewProject1Dlg::saveComboValues()
{
  ///////////////////////////////////////////////////////////////////
  // save the config file entries
  KConfig *config = kapp->getConfig();
	QString str, strTemp;
	int i;

	// Combo box informations
	config->setGroup("Directories");
  for(i = 0; i < (int) m_comboDirectory -> count(); i++)
	{	strTemp.setNum(i+1);
		config->writeEntry(strTemp.data(), m_comboDirectory -> text(i));
  }

	config->setGroup("Filters");
  for(i = 0; i < (int) m_comboFilter -> count(); i++)
	{	strTemp.setNum(i+1);
		config->writeEntry(strTemp.data(), m_comboFilter -> text(i));
  }
}

// ===========================================================================================================================
void NewProject1Dlg::addCurrentStringToCombo()
{
	// Get strings from combo Boxes and Insert items to Combo boxes
	bool bAlready;
	QComboBox* combo[2] = {m_comboDirectory, m_comboFilter};
	const char *szString[2] = {m_strDir.data(), m_strFilter.data()};

	for (int i=0; i < 2; i++)
	{	
		// Check string is not already in the combo
		bAlready = false;
		for (int j=0; j < combo[i] -> count(); j++)
		{	if ( strcmp(szString[i], combo[i] -> text(j)) == 0 )
				bAlready = true;
		}

		if (!bAlready) // Add it
		{	if (combo[i] -> count() >= MAX_STRINGSINCOMBO) // If full
				combo[i] -> removeItem(4);
		
			combo[i] -> insertItem(szString[i], 0);
		}
	}
}

// ===========================================================================================================================
void NewProject1Dlg::slotContinue()
{
	// Get the text
	m_strDir.sprintf("%s", m_comboDirectory -> currentText());
	m_strFilter.sprintf("%s", m_comboFilter -> currentText());
	m_bCriters = m_checkCriters -> isChecked();

	// Check the Search text and the Filter are not empty
  if (m_strDir.isEmpty() || m_strFilter.isEmpty())
	{	KMsgBox::message((QWidget *) 0, "KFileReplace", i18n("You must fill the combo boxes (directory and filter) before continue"), KMsgBox::EXCLAMATION, i18n("Cancel"));
  	return;
	}

	// Check the last char of szDir is not '/'
	if (m_strDir.right(1) == "/")
		m_strDir.truncate(m_strDir.length()-1);
	
	// Copy text into variables
	addCurrentStringToCombo();
	saveComboValues();
	accept();
}

// ===========================================================================================================================
void NewProject1Dlg::slotDir()
{	QFileDialog dlg;	
  QString strDir;

	strDir = dlg.getExistingDirectory();
	if (strDir.isEmpty())
		return ;

	m_comboDirectory -> setEditText( (const char *) strDir);
}












