/***************************************************************************
                          kalgodlg.cpp  -  description
                             -------------------
    begin                : Fri Jun 30 2000
    copyright            : (C) 2000 by Franois Dupoux
    email                : fdupoux@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>

#include <qvbox.h>
#include <qframe.h>
#include <qlayout.h>

#include <stdio.h>

#include "kalgodlg.h"
#include "kfilecoder.h"
#include "resource.h"

// ===========================================================================================================================
KAlgoDlg::KAlgoDlg(QWidget* parent, const char* name):QDialog(parent, name, true)
{
	initDialog();
	fillList();

	connect(m_btnOk,SIGNAL(clicked()),this,SLOT(slotOk()));
	connect(m_btnCancel,SIGNAL(clicked()),this,SLOT(reject()));
	connect(m_listAlgo, SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(slotOk()));
}

// ===========================================================================================================================
KAlgoDlg::~KAlgoDlg()
{
}

// ===========================================================================================================================
int KAlgoDlg::getAlgo()
{
	return m_nAlgo;
}

// ===========================================================================================================================
void KAlgoDlg::slotOk()
{
	int i;
	QString strText;
	QString strCurrentAlgo;
	
	m_nAlgo = 0; // Default one

	// get list current item
	strCurrentAlgo = m_listAlgo->currentText();
	
	// get number of chosen algorithm
	for (i=0; i < ALGO_SUPPORTED_NB; i++)
	{	strText.sprintf("%s", g_algo[i].szName);
		if (strCurrentAlgo.left(strText.length()) == strText)
			m_nAlgo = i;
	}

	accept();
}

// ===========================================================================================================================
void KAlgoDlg::doubleClicked(QListBoxItem *)
{
	slotOk();
}

// ===========================================================================================================================
void KAlgoDlg::initDialog()
{
	// resize dialog
	setMinimumSize(300, 200);
	resize(500, 300);
	
	QGridLayout *gbox;
	gbox = new QGridLayout (this, 3, 2, 0, 10);
	gbox -> setMargin(15);

	// widgets
	m_labelAlgo = new QLabel(this,"m_labelAlgo");
  m_labelAlgo->setText(i18n("What algorithm do you want to use to encrypt files of this archive ?"));
	gbox -> addMultiCellWidget (m_labelAlgo, 0, 0, 0, 1);
	
  m_listAlgo = new QListBox(this,"m_listAlgo");
	gbox -> addMultiCellWidget (m_listAlgo, 1, 1, 0, 1);

  // ok / cancel
	m_btnOk = new QPushButton(this,"m_btnOk");
  m_btnOk->setText(i18n("Ok"));
	gbox -> addWidget (m_btnOk, 2, 0);

  m_btnCancel = new QPushButton(this,"m_btnCancel");
  m_btnCancel->setText(i18n("Cancel"));
	gbox -> addWidget (m_btnCancel, 2, 1);
}

// ===========================================================================================================================
void KAlgoDlg::fillList()
{
	int i;
	QString strText;
	
	for (i=0; i < ALGO_SUPPORTED_NB; i++)
	{	strText.sprintf("%s (%s)", g_algo[i].szName, g_algo[i].szDescription);
		if (i == 0) // first algo
			strText += QString(" DEFAULT");
		m_listAlgo -> insertItem(strText);
	}
	
	// set default item
	m_listAlgo -> setCurrentItem(0);
}
