/***************************************************************************
                          kfilecoderdoc.h  -  description                              
                             -------------------                                         
    begin                : ven avr 23 18:58:17 CEST 1999
                                           
    copyright            : (C) 1999 by Franois Dupoux                         
    email                : fdupoux@voila.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KFILECODERDOC_H
#define KFILECODERDOC_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qfile.h>
#include <qwidget.h>
#include <qlistview.h>
#include <qstrlist.h>

#include "kfilecoder.h"
#include "ArchiveHeaders.h"
#include "resource.h"

class KURL;

/**
  * This class provides base functionality for your application document
  */

class KFileCoderDoc
{
 public:
  /** Constructor for the fileclass of the application */
  KFileCoderDoc(QObject*, const char *filename=0L);
  ~KFileCoderDoc();
	
    bool isArchiveOpened()
    {	return m_bArchiveOpened;
    }

  /** Destructor for the fileclass of the application */

  // Pointers to interface elements
    void setMainWnd (QWidget *mainWnd);
    void setListView (QListView *lv);
    QFile *getArchiveFile();
    int getNbFiles();
    int getAlgoUsed();
	
 private: // Datas used for KFileCoder
    QWidget *m_mainWnd;
    QListView *m_List;

    char m_szPassword[MAX_PASSLEN];
    char m_szArchivePath[MAXPATHLEN];
    QFile m_fArchive; // File descriptor of the current archive	
    bool m_bArchiveOpened; // Is there an archive which is opened ?
    int m_nNbFiles; // Number of files in the current archive
    int m_nAlgorithmUsed;
    uint m_nFlags;

 public: // Functions which works for the files: File menu
    int createArchive(const char *szFilename, const char *szPassword, int nAlgorithmUsed); // Create a new archive and write header: put m_szPassword, m_szArchivePAth, m_fdArchive
    int openArchive(const char *szFilename, const char *szPassword = 0); // Open the archive and read header: put m_szPassword, m_szArchivePAth, m_fdArchive
    int closeArchive(bool bClearList = true); // Close the current Archive
	
 public: // List View
    int listView_Fill();
    int listView_AddItem(const char *szName, uint nSize, uint nCRC, const char *szPath);

 public: // Internal Functions
    int writeHeader(); // When creating new archive
    int readHeader();	// When opening an archive		
    bool isFileSelected(const char *szFileName, const char *szFilePath);
    int getNbSelectedFiles(); // number of selected files in the list view
    bool doesFileExistsInArchive(const char *szFileName, const char *szFilePath);
    int encodeString(char *szDest, const char *szSource, int nStrLen, const char *szPassword); // Encode and decode a string using m_szPassword
    uint getPasswordTestCrc();
    int getDiskFreeSpaceForFile(uint *nAvailDiskSpace, const char *szFilename);
    int writeFileString(QFile *qfOut, const char *szString, bool bEncode, const char *szPassword, bool bErrMsg = true);
    int readFileString(QFile *qfIn, char *szString, bool bEncode, const char *szPassword, bool bErrMsg = true);

 public: // Functions which works for the files: Archive menu. ONLY if file is opened
    int addFile(KURL urlFile);
    int extractFiles(const char *szDestPath, bool bOnlySelFiles);
    int deleteSelectedFilesInArchive();

    int addFileAlgo1(const char *szFilename, QFile *fFileToAdd, uint *nOriginalCrc);
    int extractFilesAlgo1(const char *szFullpath, QFile *fFileToDecode, uint *nExtractedCrc, uint nFileSize);
};

#endif // KFILECODERDOC_H





























































