/***************************************************************************
                          mylineedit.h  -  description
                             -------------------
    begin                : Fri Feb 4 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MYLINEEDIT_H
#define MYLINEEDIT_H

#include <klocale.h>

#include <qwidget.h>
#include <qlineedit.h>
#include <qstrlist.h>
#include <qstring.h>
#include <qdragobject.h>
#include <qmessagebox.h>

#include <ktmainwindow.h>

/**
  *@author Frank von Daak
  */

class MyLineEdit : public QLineEdit  {
   Q_OBJECT
public: 
	MyLineEdit(QWidget *parent=0, const char *name=0);
	~MyLineEdit();

	// Every MyLineEdit-Object has it's own index
	int index() { return indx; };
	void setIndex(int idx) { indx = idx; };

private:
	void focusInEvent( QFocusEvent *);
	void dropEvent( QDropEvent *);

	// This will search for the used protocol of a dropped url
	void getProtocol(QString &);
	int indx;

signals:
	void focusIn();
	void multiUrl(QStrList);
	void dropProt(QString);
};

#endif