/////////////////////////////////////////////////////////////////////////////
//
// This file declares data types for mime types.
//
// Time-stamp: <97/05/05 16:58:06 vels>
// Copyright (c) VDOnet Corp. 1996
//
/////////////////////////////////////////////////////////////////////////////
  
#ifndef _MIMETYPE_H_
#define _MIMETYPE_H_

#include <qstring.h>

//
// MIME type: "text/plain"
//
typedef char * MIME_TextPlain;


//
// MIME type: "text/directory"
//
typedef struct _DirItem_
{
  QString    fileName;
  QDateTime  date;
  long       size;
  /* TODO:  add other values from stat() ? */
} DirItem;

typedef struct _MIME_TextDirectory_
{
  QList<DirItem>  file;            // List of files in the dir
  QString         directory;       // Path to the dir
  bool            withDots;        // Contains dot files ?
} MIME_TextDirectory;

#endif // _MIMETYPE_H_
