/////////////////////////////////////////////////////////////////////////////
//
// Directory plugin
//
// Time-stamp: <97/05/06 03:40:40 vels>
// Copyright (c) VDOnet Corp. 1996
//
/////////////////////////////////////////////////////////////////////////////

#include <unistd.h>
#include <dirent.h>
#include <sys/types.h>
#include <errno.h>
#include <limits.h>

#include "dirplug.h"
#include "dirplug.moc"

#define NUM_OPTIONS   2

// Constructor
DirPlugin::DirPlugin() :
  m_directory("."),
  m_dots(FALSE)
{
  // Specify plugin type
  setType(KPlugin::Input);
  
  // Assign a name
  setName("Directory plugin");

  // Specify input MIME types
  // -- input plugin don't have input MIME types

  // Specify output MIME types
  registerOutputMIMEType("text/directory");
  registerOutputMIMEType("text/plain");

  // Create array of member functions for setting/getting options.
  // Every even element points to a 'set' method and every odd element -
  // to a 'get' method.
  m_option = new MemberFunction[NUM_OPTIONS*2];
  MemberFunction *ptr = m_option;

  // Register options
  registerOption("dir");
  *ptr++ = &DirPlugin::setDirectory;
  *ptr++ = &DirPlugin::getDirectory;

  registerOption("dots");
  *ptr++ = &DirPlugin::setDots;
  *ptr++ = &DirPlugin::getDots;
}

DirPlugin::~DirPlugin()
{
  delete m_option;
}

// Start working
int DirPlugin::start()
{
  // Open directory
  DIR *dirStream;
  if ((dirStream=opendir((const char *)m_directory)) == NULL)
  {
    warning("DirPlugin::run() can't open directory '%s'", 
            (const char *)m_directory);
    return -1;
  }
    
  // Look for files in this directory
  struct dirent *entry;
  while ((entry=readdir(dirStream)) != NULL)
  {
    // Skip all dot files
    if (!m_dots && *(entry->d_name) == '.')
      continue;

    // Pass data to the next plugin
    output("text/plain", entry->d_name);
    output("text/plain", "\n");
  }
  closedir(dirStream);

  // Announce that we've finished our job
  finished();
  return 0;
}


//        ------------------------- INPUT --------------------------


//        ------------------------ OPTIONS --------------------------

// Call appropriate action
int DirPlugin::callOptionMemberFunction(int index, void *arg)
{
  return m_option[index](arg);
}

// Change directory
int DirPlugin::setDirectory(void *arg)
{
  if (!arg)
    return -1;

  m_directory = (const char *)arg;
  return 0;
}

// Return directory
int DirPlugin::getDirectory(void *arg)
{
  if (!arg)
    return -1;

  char *dirBuf = (char *)arg;
  strcpy(dirBuf, (const char *)m_directory);
  return 0;
}

// Show dot files ?
int DirPlugin::setDots(void *arg)
{
  m_dots = *(bool *)arg;
  return 0;
}

// Show dot files ?
int DirPlugin::getDots(void *arg)
{
  if (!arg)
    return -1;
  
  bool *ptr = (bool *)arg;
  *ptr = m_dots;
  return 0;
}
