//////////////////////////////////////////////////////////////////////////////
//
//    KEXIFUTILS.CPP
//
//    Copyright (C) 2002-2004 Renchi Raju <renchi at pooh.tam.uiuc.edu>
//                            Gilles CAULIER <caulier dot gilles at free.fr>
//                            Ralf Hoelzer <kde at ralfhoelzer.com>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin Steet, Fifth Floor, Cambridge, MA 02110-1301, USA.
//
//////////////////////////////////////////////////////////////////////////////

#ifndef KEXIFENTRY_H
#define KEXIFENTRY_H

#include <qstring.h>

typedef struct _ExifEntry  ExifEntry;

class KExifEntry {

public:

    KExifEntry();
    KExifEntry(ExifEntry* exifEntry);
    ~KExifEntry();

    KExifEntry(const KExifEntry& entry);
    KExifEntry& operator=(const KExifEntry& entry);

    void setEntry(ExifEntry* exifEntry);

    QString getName()  const;
    QString getTitle() const;
    QString getValue() const;
    QString getDescription() const;

    ExifEntry* exifEntry() {
        return mExifEntry;
    }

private:

    ExifEntry* mExifEntry;

    QString mName;
    QString mTitle;
    QString mValue;
    QString mDescription;

    void readEntry();
};

#endif
