/***************************************************************************
                          main.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sat Apr 24 15:14:00 MEST 1999

    copyright            : (C) 2005 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <dcopclient.h>
#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include "kpl.h"

static const char description[] =
  I18N_NOOP("An application for plotting of data sets and functions");

static KCmdLineOptions options[] = {
  {"+[URL]", I18N_NOOP("Document to open"), 0},
  KCmdLineLastOption
};

int main(int argc, char** argv)
{
  KAboutData about("kpl", I18N_NOOP("Kpl"), VERSION, description,
                   KAboutData::License_GPL, "(c) 2005, Werner Stille", 0, 0,
                   "stille@uni-freiburg.de");
  about.addAuthor("Werner Stille", 0, "stille@uni-freiburg.de");
  KCmdLineArgs::init(argc, argv, &about);
  KCmdLineArgs::addCmdLineOptions(options);
  KApplication app;
  app.dcopClient()->registerAs(app.name(), false);
  if (app.isRestored()) {
    RESTORE(Kpl);
  } else {
    KCmdLineArgs* args = KCmdLineArgs::parsedArgs();
    Kpl* kpl = new Kpl;
    if (args->count()) {
      KURL::List list;
      for (int i = 0; i < args->count(); i++)
        list.append(args->url(i));
        kpl->openList(&list, -1, 0);
    }
    kpl->show();
    args->clear();
  }
  return app.exec();
}
