/***************************************************************************
                          autofitdlg.cpp  -  description
                             -------------------
    begin                : Sat Jun 5 1999
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcheckbox.h>
#include <qfileinfo.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qmultilinedit.h>
#include <qpushbutton.h>
#include <qregexp.h>
#include <qtimer.h>
#include <kapp.h>
#include <kcolorbtn.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "autofitdlg.h"
#include "choosefuncdlg.h"
#include "fitdlg.h"
#include "kpldoc.h"
#include "kpldoubleedit.h"
#include "kplspinbox.h"
#include "sourcewidget.h"
#include "symboldlg.h"

EditFitParameterDlg::EditFitParameterDlg(QWidget* _parent, KplDoc* m,
                                         double* p0, bool* bFit0,
                                         const QString& file,
                                         const QString& func) :
 KDialogBase(Plain, i18n("Fit parameters"), Ok | Cancel, Ok, _parent, 0,
             true, true), bFit(bFit0), p(p0)
{
  QHBoxLayout* hbox = 0;
  QVBoxLayout* vbox;
  QFrame* frame = plainPage();
  if (m->options()->showSource) {
    hbox = new QHBoxLayout(frame, 0, spacingHint());
    vbox = new QVBoxLayout(hbox);
  } else
    vbox = new QVBoxLayout(frame, 0, spacingHint());
  QGroupBox* g = new QGroupBox(0, Qt::Vertical, frame);
  QGridLayout* grid = new QGridLayout(g->layout(), QMIN(KPL_NPMAX, 10),
                                      2 + 3 * ((KPL_NPMAX - 1) / 10),
                                      spacingHint());
  vbox->addWidget(g);
  QString s;
  char frm = m->options()->format;
  int prec = m->options()->prec;
  int w = 0;
  for (int i = 0; i < KPL_NPMAX; i++) {
    int ix = 3 * (i / 10);
    int iy = i % 10;
    grid->addWidget(enFit[i] = new QCheckBox(s.sprintf("p%i", i), g), iy, ix);
    enFit[i]->setChecked(bFit[i]);
    grid->addWidget(par[i] = new KplDoubleEdit(p[i], g, frm, prec), iy,
                    ix + 1);
    if (!i)
      w = par[0]->fontMetrics().width(m->number(-1.0e-123 / 3.0)) + 3;
    par[i]->setMinimumWidth(w);
  }
  for (int i = 0; i < ((KPL_NPMAX - 1) / 10); i++)
    grid->addItem(new QSpacerItem(20, 10), 0, 3 * i + 2);
  if (m->options()->showSource) {
    QFileInfo fi(file);
#if KDE_VERSION_MAJOR > 2
    QRegExp rx2("\\S+__FdPCd");
    QRegExp rx3("_Z\\d+\\S+dPKd");
    int pp2 = rx2.search(func);
    int pp3 = rx3.search(func);
#else
    QRegExp rx2("[^\\s]+__FdPCd");
    QRegExp rx3("_Z\\d+[^\\s]+dPKd");
    int l2, l3;
    int pp2 = rx2.match(func, 0, &l2);
    int pp3 = rx3.match(func, 0, &l3);
#endif
    s = fi.dirPath(true) + "/" + fi.baseName();
    bool guessC = pp2 && pp3;
    QFile f(s + (guessC ? ".c" : ".cpp"));
    bool open = f.open(IO_ReadOnly);
    if (!open) {
      f.setName(s + (guessC ? ".cpp" : ".c"));
      open = f.open(IO_ReadOnly);
    }
    if (open) {
      SourceWidget *sw = new SourceWidget(frame, &f);
      hbox->addWidget(sw, 1);
      sw->setMinimumWidth(400);
      if (!pp2)
#if KDE_VERSION_MAJOR > 2
        sw->highlight(func.left(rx2.matchedLength() - 7));
      else
        if (!pp3)
          sw->highlight(func.mid(3, rx3.matchedLength() - 7));
#else
        sw->highlight(func.left(l2 - 7));
      else
        if (!pp3)
          sw->highlight(func.mid(3, l3 - 7));
#endif
        else
          sw->highlight(func);
      QTimer::singleShot(0, sw, SLOT(slotHighlight()));
    }
  }
}

EditFitParameterDlg::~EditFitParameterDlg()
{
}

void EditFitParameterDlg::slotOk()
{
  for (int i = 0; i < KPL_NPMAX; i++) {
    p[i] = par[i]->value();
    bFit[i] = enFit[i]->isChecked();
  }
  accept();
}

AutoFitDlg::AutoFitDlg(QWidget* _parent, KplDoc* m0) :
 KDialogBase(Plain, i18n("Autofit settings"), Help | Ok | Cancel, Ok, _parent),
 m(m0)
{
  aut = new Kpl::AutoStruct(*m->options());
  QFrame* frame = plainPage();
  QVBoxLayout* vbox = new QVBoxLayout(frame, 0, spacingHint());
  QGroupBox* g = new QGroupBox(0, Qt::Vertical, "y(x)", frame);
  vbox->addWidget(g);
  QGridLayout* grid = new QGridLayout(g->layout(), 3, 2, spacingHint());
  grid->addWidget(new QLabel(i18n("Library"), g), 0, 0);
  QHBoxLayout* hbox = new QHBoxLayout();
  grid->addLayout(hbox, 0, 1);
  hbox->addWidget(fileName = new QLineEdit(aut->fitPath, g));
  QPushButton *b = new QPushButton("...", g);
  b->setFixedWidth(28);
  hbox->addWidget(b);
  connect(b, SIGNAL(clicked()), SLOT(slotFile()));
  grid->addWidget(new QLabel(i18n("Function"), g), 1, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 1, 1);
  hbox->addWidget(func = new QLineEdit(aut->fitName, g));
  hbox->addWidget(b = new QPushButton("...", g));
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotFunc()));
  grid->addWidget(new QLabel(i18n("Parameter"), g), 2, 0);
  grid->addLayout(hbox = new QHBoxLayout(), 2, 1);
  hbox->addWidget(b = new QPushButton(i18n("Edit"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotEditParameter()));
  hbox->addWidget(b = new QPushButton(i18n("Load"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotGetParameter()));
  hbox->addWidget(b = new QPushButton(i18n("Save"), g));
  connect(b, SIGNAL(clicked()), SLOT(slotSaveParameter()));
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, frame));
  QVBoxLayout* vbox2 = new QVBoxLayout(g->layout(), spacingHint());
  vbox2->addLayout(hbox = new QHBoxLayout());
  vbox2->addWidget(nonLin = new QCheckBox(i18n("Nonlinear fit"), g));
  nonLin->setChecked(aut->fitNonLin);
  grid = new QGridLayout(vbox2, 3, 5, 12);
  grid->addWidget(errCol = new QCheckBox(i18n("Error column"), g), 0, 0);
  errCol->setChecked(aut->err.fitErrCol);
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 1);
  grid->addWidget(errMod = new QPushButton(i18n("Model"), g), 0, 4);
  connect(errMod, SIGNAL(clicked()), SLOT(slotErrMod()));
  grid->addWidget(new QLabel(i18n("Maximum iterations"), g), 1, 0);
  grid->addWidget(sItmax = new KplSpinBox(1, 200, 1, g), 1, 1);
  sItmax->setValue(aut->fitMaxIt);
  grid->addWidget(new QLabel(i18n("Tolerance"), g), 1, 3);
  grid->addWidget(eTol = new KplDoubleEdit(aut->fitTol, 0.0, 1.0, g, 'g', 6),
                  1, 4);
  grid->addLayout(hbox = new QHBoxLayout(), 2, 0);
  hbox->addWidget(new QLabel(i18n("Symbol"), g));
  hbox->addWidget(symb = new KplSpinBox(-17, 9, 1, g));
  symb->setValue(aut->fitSymb);
  grid->addWidget(new SymbolButton(g, symb), 2, 1);
  grid->addWidget(new QLabel(i18n("Color"), g), 2, 3);
  grid->addWidget(colData = new KColorButton(aut->fitColor, g), 2, 4);
  vbox2->addWidget(showDlg = new QCheckBox(i18n("Show dialog"), g));
  showDlg->setChecked(aut->fitShowDlg);
  vbox2->addWidget(saveRes = new QCheckBox(i18n("Save parameters"), g));
  saveRes->setChecked(aut->fitSavePar);
  vbox2->addWidget(follow = new QCheckBox(i18n("Follow parameters"), g));
  follow->setChecked(aut->fitFollow);
  resize(minimumSize());
  setHelp("SEC-AUTOFIT");
  connect(errCol, SIGNAL(toggled(bool)), SLOT(disableErrMod(bool)));
  connect(nonLin, SIGNAL(toggled(bool)), SLOT(enableNonLin(bool)));
  disableErrMod(aut->err.fitErrCol);
  enableNonLin(aut->fitNonLin);
}

AutoFitDlg::~AutoFitDlg()
{
  delete aut;
}

void AutoFitDlg::slotFile()
{
  m->getFile(fileName);
}

void AutoFitDlg::slotFunc()
{
  QFileInfo fi(fileName->text());
  QString path = fi.dirPath(true);
  QFile f(path + "/" + fi.baseName() + ".def");
  if (f.open(IO_ReadOnly)) {
    ChooseFuncDlg dlg(this, &f, func);
    dlg.exec();
  } else
    KMessageBox::error(this, i18n("while trying to open "
                                  "module definition file"));
}

void AutoFitDlg::slotGetParameter()
{
  m->getPar(this, aut->pFit);
}

void AutoFitDlg::slotEditParameter()
{
  EditFitParameterDlg dlg(this, m, aut->pFit, aut->fitPar, fileName->text(),
                          func->text());
  dlg.exec();
}

void AutoFitDlg::slotSaveParameter()
{
  m->saveFunPar(this, aut->pFit);
}

void AutoFitDlg::slotErrMod()
{
  ErrModDlg dlg(this, m, &aut->err);
  dlg.exec();
}

void AutoFitDlg::disableErrMod(bool off)
{
  errMod->setEnabled(!off);
}

void AutoFitDlg::enableNonLin(bool on)
{
  eTol->setEnabled(on);
  sItmax->setEnabled(on);
}

void AutoFitDlg::slotOk()
{
  aut->fitNonLin = nonLin->isChecked();
  if (aut->fitNonLin) {
    aut->fitTol = eTol->value();
    aut->fitMaxIt = sItmax->interpretedValue();
  }
  aut->fitPath = fileName->text();
  aut->fitName = func->text();
  aut->err.fitErrCol = errCol->isChecked();
  aut->fitShowDlg = showDlg->isChecked();
  aut->fitSavePar = saveRes->isChecked();
  aut->fitFollow = follow->isChecked();
  aut->fitColor = colData->color().rgb();
  aut->fitSymb = symb->interpretedValue();
  m->setOptions(aut);
  accept();
}
