/***************************************************************************
                          kbeartreeview.h  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEAR_TREEVIEW_H
#define KBEAR_TREEVIEW_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qlistview.h>
#include <qmessagebox.h>
#include <qpixmap.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klistview.h>
#include <kinstance.h>
#include <kglobal.h>
#include <kiconloader.h>


/**
  *@author Bjrn Sahlstrm
  **/

class KBearTreeView : public KListView  {
   Q_OBJECT
	friend class KBearTreeViewItem;
	public:
		KBearTreeView(QWidget * parent = 0, const char * name = 0 ,bool rootDec=true);
		virtual ~KBearTreeView();
		/** Searches the hole tree for specified name
		*@param name is the name to search for
		*@returns a pointer to the found item or NULL
		*/
		QListViewItem* findByName( const QString& name );
		/** adds a parent item to parent directory,
		*@returns a pointer to the item
		 */
		QListViewItem* addDirectory(const QString& name);
		/** adds a parent item to root directory,
		*@returns a pointer to the item
		 */
		QListViewItem* addDirectory(QListViewItem* parent,const QString& name);
		/** adds a child item to root directory,
		*@returns a pointer to the item
		 */
		QListViewItem* addFile( const QString& name );
		/** adds a child item to parent directory,
		*@returns a pointer to the item
		 */
		QListViewItem* addFile(QListViewItem* parent,const QString& name);
	protected: // Protcted methods
		
};
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Class KBearTreeViewItem

class KBearTreeViewItem : public QListViewItem  {
	public:
		KBearTreeViewItem( QListView * parent, const QString& filename,QPixmap* icon );
		KBearTreeViewItem( QListViewItem* parent, const QString& filename,QPixmap* icon );
		virtual ~KBearTreeViewItem(){}
		virtual void setOpen( bool );
		virtual bool isFile( int n) const ;		
		void setPixmap( QPixmap* );
		virtual const QPixmap* pixmap( int ) const;
	private:
		QListViewItem * p;
		QPixmap* myPixmap;
};
#endif
