/***************************************************************************
                          kbearsitemanagerstructs.h  -  description
                             -------------------
    begin                : Fri Sep 15 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KBEARSITEMANAGER_STRUCTS_H
#define KBEARSITEMANAGER_STRUCTS_H

/**
  *This struct holds all information about a specific remote host
  *like login, password etc.
  *@author Bjrn Sahlstrm
  */
///////////////////////////////////////////////////////
typedef struct ConnectInfo;
struct ConnectInfo{
	/** Label for the site */
	QString label;
	/** Name of the server to connect to, like ftp.kde.org */
	QString host;
	/** port number to connect to*/
	int port;
	/** Whether to use anonymous login or not*/
	bool anonym;
	/** Users login name for the remote host */
	QString user;
	/** Users password for the remote host */
	QString pass;
	/** Initial path for the remote host */
	QString path;
};
///////////////////////////////////////////////////////
inline QDataStream& operator << ( QDataStream& s, const bool& b ) {
	QString str;
		if( b )
			str = "true";
		else
			str = "false";
	return s << str;
}		
///////////////////////////////////////////////////////
inline QDataStream& operator >> ( QDataStream& s, bool& b ) {
	QString str;
	s >> str;
	if(str =="true")
		b = true;
	else
		b = false;
	return s;
}
///////////////////////////////////////////////////////
inline QDataStream& operator << ( QDataStream& s, const struct ConnectInfo& inf ) {
	s << inf.label << inf.host << inf.port << inf.anonym << inf.user << inf.pass << inf.path;
	return s;
}		
///////////////////////////////////////////////////////
inline QDataStream& operator >> ( QDataStream& s, struct ConnectInfo& inf ) {
	s >> inf.label;
	s >> inf.host;
	s >> inf.port;
	s >> inf.anonym;
	s >> inf.user;
	s >> inf.pass;
	s >> inf.path;
	return s;
}		
///////////////////////////////////////////////////////////////////////////////////
/**
  *This struct holds all information about a specific site
  *@see ConnectInfo
	*@author Bjrn Sahlstrm
  */
///////////////////////////////////////////////////////
typedef struct SiteInfo;
struct SiteInfo {
	/** name of the sites parent in the SiteManager */
	QString parent;
	/** a @ref ConnectInfo struct for host info */
	ConnectInfo info;
	/** A short description for the site */
	QString description;
};
///////////////////////////////////////////////////////
inline QDataStream& operator << ( QDataStream& s, const struct SiteInfo& inf ) {
	s << inf.parent << inf.info << inf.description;
	return s;
}		
///////////////////////////////////////////////////////
inline QDataStream& operator >> ( QDataStream& s, struct SiteInfo& inf ) {
	s >> inf.parent;
	s >> inf.info;
	s >> inf.description;
	return s;
}		
#endif
