/***************************************************************************
                          kbearsettingsdialog.cpp  -  description
                             -------------------
    begin                : Thu Jul 20 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kbearsettingsdialog.h"
#include "kbear.h"
//-----------------------------------------------
KBearSettingsDialog::KBearSettingsDialog(QWidget *p, const char *name)
	:	KDialogBase(KDialogBase::IconList,i18n("General Settings"),
					KDialogBase::Ok | KDialogBase::Apply | KDialogBase::Cancel,KDialogBase::Ok,
					p,name,true)
{
/////////////////////////////////////////////////////
//	page1
	QFrame* page1Parent = addPage( i18n("Views"), "", BarIcon("view_choose", KIcon::SizeLarge));
	QVBoxLayout* page1Layout = new QVBoxLayout( page1Parent, 0, 6 );
	page1 = new ViewSettingsWidget( page1Parent, "ViewSettingsWidget" );
	page1Layout->addWidget( page1 );
/////////////////////////////////////////////////////
//	page2
	QFrame* page2Parent = addPage( i18n("ChildFrames"), "", BarIcon("window_nofullscreen", KIcon::SizeLarge) );
	QVBoxLayout* page2Layout = new QVBoxLayout( page2Parent, 0, 6 );
	page2 = new ChildFrameModeSettings( page2Parent, "ChildFrameModeSettings" );
	page2Layout->addWidget( page2 );
/////////////////////////////////////////////////////
//	page3
	QFrame* page3Parent = addPage( i18n("Mixed"), "", BarIcon("misc", KIcon::SizeLarge));
	QVBoxLayout* page3Layout = new QVBoxLayout( page3Parent, 0, 6 );
	page3 = new MixedSettingsWidget( page3Parent, "MixedSettingsWidget" );
	page3Layout->addWidget( page3 );
/////////////////////////////////////////////////////
//	page4
	QFrame* page4Parent = addPage( i18n("SiteManager"), i18n("SiteManager"), BarIcon("contents", KIcon::SizeLarge));
	QVBoxLayout* page4Layout = new QVBoxLayout( page4Parent, 0, 6 );
	KBearSiteManager* mySiteManager = new KBearSiteManager( page4Parent,"SiteManager");
	mySiteManager->setConnectEnabled( false );
	page4Layout->addWidget( mySiteManager );
	setFocusPolicy( WheelFocus );
	resize( 600, 560 );
}
//-----------------------------------------------
KBearSettingsDialog::~KBearSettingsDialog(){
}
//-----------------------------------------------
