/***************************************************************************
                          kbear.h  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/********************************************************************************
 *																															*
 *   This program is free software; you can redistribute it and/or modify		*
 *   it under the terms of the GNU General Public License as published by	*
 *   the Free Software Foundation; either version 2 of the License, or			*
 *   (at your option) any later version.																*
 *																															*
 *********************************************************************************/
#ifndef KBEAR_H
#define KBEAR_H
//////////////////////////////////////////////////////
// include files for QT
#include <qapp.h>
#include <qlayout.h>
#include <qfile.h>
#include <qvaluelist.h>
#include <qqueue.h>
#include <qmap.h>
#include <qcursor.h>
#include <qlcdnumber.h>
/////////////////////////////////////////////////////
// include files for KDE
#include <kapp.h>
#include <krun.h>
#include <kopenwith.h>
#include <kaccel.h>
#include <kapp.h>
#include <ktoolbar.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kdialogbase.h>
#include <kmenubar.h>
#include <klocale.h>
#include <ksimpleconfig.h>
#include <kstddirs.h>
#include <kaboutapplication.h>
#include <klineeditdlg.h>
#include <kaboutkde.h>
#include <kbugreport.h>
#include <kpixmap.h>
#include <kstddirs.h>
#include <kstdaction.h>
#include <kaction.h>
#include <kio/jobclasses.h>
#include <kprotocolmanager.h>
//////////////////////////////////////////////////////
// application specific includes
#include "kbearsitemanager.h"
#include "kbearquickconnect.h"
#include "kbearftpview.h"
#include "kbeartransferview.h"
#include "kbeartransferviewitem.h"
#include "kbearqueryexit.h"
#include "kbeardiroperator.h"
#include "kbearclipboard.h"
#include "kbearsearch.h"
#include "kbearsettingsdialog.h"
#include "kbeartipoftoday.h"
#include "kbearwizard.h"
#include "resource.h"
#include "qextmdimainfrm.h"
#include "mixedsettingswidget.h"
#include "childframemodesettings.h"

class QextMdiChildView;
class KBearSiteManager;
class KBearFtpView;
class KBearClipBoard;
class KBearTransferView;
class KBearTransferViewItem;
class ViewSettingsWidget;
class MixedSettingsWidget;
class ChildFrameModeSettings;

/**
	*This struct contains all information needed for a drag operation, this is an item in the @ref KBearTransferQueue
*/
typedef struct KBearTransferQueueItem;
struct KBearTransferQueueItem {
	bool move;
	KURL source;
	KURL dest;
	QString host;	
};
/**
	*The queue type is used when user asked for queing of transfers, contains all pending transfers
*/
typedef QQueue<KBearTransferQueueItem> KBearTransferQueue;
/**
	* This Class is the base class of the KBear application. It sets up the main
	* window and provides a menubar, a toolbar, a statusbar and a transfer view.
	*
	* @short This Class is the base class of the KBear application
	*@author Bjrn Sahlstrm
*/
class KBear : public QextMdiMainFrm {
  Q_OBJECT
public:
    /** Constructor */
    KBear();
    /** Destructor */
    ~KBear();
	/** */
	virtual void show();
	/** initMenuBar creates the menu_bar and inserts the menuitems */
	void initMenuBar();
	/** this creates the toolbars. Change the toolbar look and add new toolbars in this function */
	void initToolBar();
	/** setup the statusbar */
	void initStatusBar();
	/** */
	virtual bool queryExit();
	/** reimplemented for MessageBox on exit */
	virtual bool queryClose();
	/** */
//	virtual bool eventFilter( QObject* object, QEvent* event);
	/**
	* an accessor to a collection of all available Actions. The actions
	* are static, they will be there all the time (no need to connect to
	* the signals @ref KActionCollection::inserted() or @ref KActionCollection::removed().
	*
 	* There are the following actions:
	*
	* @li cut : cut the selected item(s) to the internal clipboard
	* @li copy : copy the selected item(s) to the internal clipboard
	* @li paste : paste the contents from the internal clipboard into the active view
	* @li find : open a search dialog
	* @li select all : select all items in the active view
	* @li clear selection : clears all selected items in the active view
	* @li invert selectin : inverts the selection in the active view
	* @li quick connect : open a quick connect dialog
	* @li close connection : close the connection associated with the active view and clos the view
 	* @li sitemanager : open the SiteManager
	* @li clear recent : clear the recent connection list
	* @li quit : quits the application
	* @li toggle toolbar : toggles the toolbar on or off
	* @li toggle statusbar : toggles the statusbar on or off
	* @li toggle taskbar : toggles the taskbar on or off
	* @li toggle transferview : toggles the transferview on or off
	* @li toggle local : toggles the Local Filesystem View on or off
	* @li settings : opn a settings dialog
	* @li tip of today : run the Tip of today dialog
	* @li wizard : run the KBear Wizard
	* @li kmail : launch KMail
	* @li konqueror: launch Konqueror Web Browser
	* @li help : lauch the KBear help system
	* @li whats this : enter whats this mode
	*
	* @returns all available Actions
	*/
	KActionCollection * actionCollection() const { return myActionCollection; }
	/** sets the meny entry for local file system
	*@param flag holds the new status to be set
	*/
	void setLocalFileSystemEntry( bool flag );
  /**
  *@returns a pointer to the clipboard object
  */
	KBearClipBoard* clipBoard() { return myClipBoard;};
	
	/**
	*@returns a pointer to the @ref KConfig object of the app
	*/
	KConfig* config() { return myConfig; }
	/**
	*@returns true if detailed view mode is set as default
	*/
	bool detailedViewIsSet() const;
   /**
   * Reimplemented from @ref QextMdiMainFrm.
   *You can override this
   * method to insert additional entries there. The popup menu is usually popuped when the user
   * clicks with the right mouse button on a taskbar entry. The default entries are:
   * Undock/Dock, Restore/Maximize/Minimize, Close and a view menu popup
	*@returns A popup menu filled according to the MDI view state and View action menu.
   */
	virtual QPopupMenu* taskBarPopup(QextMdiChildView* pWnd,bool bIncludeWindowPopup = FALSE);
	/**
	*@returns default email adress used as password for anonymous ftp if set
	*/
	const QString emailDefault() const { return str_emailDefault; }
	/** for internal use only*/
	const QextMdiChildView* activeTopLevelView() const { return p_activeView; }
signals: // Signals
	/** Emitted when the view settings are changed */
	void viewSettingsChanged( bool detailMode, bool iconMode, bool showTree );
	/** */
	void deleteItem( KURL );
public slots:
	/** */
	void slotCreateClient( ConnectInfo& info, bool addRecent );
	/** open a new connection */
    void slotFtpQuickConnect();
    /**
    *open the sitemanager
    *@see KBearSiteManager
    */
    void slotFtpSiteManager();
    /** asks if really want to diconnect, then closes the actual connection and window */
    void slotFtpDisconnect();
    /** closes all connections and quits the application. */
    void slotFtpQuit();
    /** toggle the toolbar */
    void slotViewToolBar();
    /** toggle the statusbar */
    void slotViewStatusBar();
	/** toggles the transfer view */
	void slotViewTransferWindow();
	/** toggles the home window */
	void slotLocalFileSys();
	/** toggle the taskbar */
	void slotViewTaskBar();
	/** this function is invoced automatically first time the user
	*starts KBear to setup internal settings
	*/
	void slotWelcome();
	/** change the status message of the whole statusbar temporary */
	void slotStatusHelpMsg(const QString &text);
	/**
	*Copy the selected file(s) to the internal clipboard
	*@see KBearClipBoard
	*/
	void slotCopy();
	/**
	*Cut the selected file(s) to the internal cllipboard
	*@see KBearClipBoard
	*/
	void slotCut();
	/** Paste the file contents from the internal clipboard into current path
	*@see KBearClipBoard
	*/
	void slotPaste();
	/**  */
	void slotFind();

   /** undocks all view windows (unix-like) */
   virtual void switchToToplevelMode();
	/** docks all view windows (Windows-like) */
	virtual void switchToChildframeMode();
	/**  */
	void startTransfer( KBearFtpView* view, KURL::List& lst, bool move = false );
   /**
   * Cascades the windows without resizing them.
   */
   virtual void cascadeWindows();
   /**
   * Cascades the windows resizing them to the maximum available size.
   */
   virtual void cascadeMaximized();
   /**
   * Maximizes only in vertical direction.
   */
   virtual void expandVertical();
   /**
   * Maximizes only in horizontal direction.
   */
   virtual void expandHorizontal();
   /**
   * Tile Pragma
   */
   virtual void tilePragma();
   /**
   * Tile Anodine
   */
   virtual void tileAnodine();
   /**
   * Tile Vertically
   */
   virtual void tileVertically();
	/** for internal use only*/
	void slotSetActiveView( QextMdiChildView* view );
	/** for internal use only*/
	void slotClearActiveView();
   /**
   * Update of the window menu contents.
   */
   virtual void fillWindowMenu();

protected: // Protected methods
	/** Initialize the Local filesystem view*/
	void initLocalFileSys();
	/** just fits the system menu button position to the menu position */
   virtual void resizeEvent ( QResizeEvent * );
	/** */
	void setDialogSettings( ViewSettingsWidget* w, MixedSettingsWidget* m, ChildFrameModeSettings* c );
	/** sets up all actions */
	void setupActions();
	/**  */
	void setChildFrameMode( unsigned int mode );
	/** No descriptions */
	void showActionDisabledInTopLevelMode();

protected slots: // Protected slots
	/** shows an about dialog for KBear */
	void showAboutApplication ();
	/**  */
	void slotShowHelp();
	/** open a dialog for general application settings */
	void slotSettings();
	/**  */
	void slotStartNextTransfer();
	/**
	*Invoke the What's This mode
	*@see QWhatsThis
	*/
	void slotWhatsThis();
	/**  */
	void slotClearSelection();
	/**  */
	void slotSelectAll();
	/**  */
	void slotInvertSelection();
	/**  */
	void slotOpenBrowser();
	/**  */
	void slotOpenKMail();
	/**  */
	void slotSaveToSiteManager( SiteInfo& );

private: //private methods
	void saveOptions();
	void readOptions();
	void addRecentFile(const QString &file);
	void setChildViewPositions();
	void changeChildFrameModeSettings( ChildFrameModeSettings* c );
	void changeMixedSettings( MixedSettingsWidget* m );
	void changeViewSettings( ViewSettingsWidget* w );
	KIO::Job* activateTransfer( KURL source, KURL dest, QString host, bool move );
private slots: // Private slots
	void slotFtpOpenRecent(int id_);
	void slotFtpClearRecent();
	void saveChildViewPositions();
	void slotDeleteItem( KIO::Job* );
	void slotRunTipOfToday();
	void slotApplySettings();

private: // Private attributes
	QextMdiChildView* localFileSys;
	/** contains the recently used connection names */
	QStrList recentConnections;
	/** the recentFtpMenu containing the last ten opened sites */
	QPopupMenu *recentFtpMenu;
	/** ftpMenu contains all items of the menubar entry "FTP" */
	QPopupMenu *ftpMenu;
	/** editMenu contains all edit actions*/
	QPopupMenu *editMenu;
	/** settingsMenu contains all items of the menubar entry "View" */
	QPopupMenu *settingsMenu;
	/** myHelpMenu contains all items of the menubar entry "Help" */
	QPopupMenu *myHelpMenu;
	/**
	*The transfer view object that shows progress information
	* during transfers to or from a remote host
	*@see KBearTransferView
	*/
	KBearTransferView* transferView;
	
	QString myCaption;	
 	/** holds the caption of the local file system window */
	const QString localFileSysCaption;
	/**
	*The clipboard object
	*@see KBearClipBoard
	*/
	KBearClipBoard* myClipBoard;
	KActionSeparator* actionSeparator;
	KAction* cutAction;
	KAction* copyAction;
	KAction* pasteAction;
	KAction* findAction;
	KAction* selectAllAction;
	KAction* clearSelectionAction;
	KAction* invertSelectionAction;
	KAction* quickConnectAction;
	KAction* disConnectAction;
	KAction* siteManagerAction;
	KAction* clearRecentAction;
	KAction* quitAction;
	KAction* settingsAction;
	KAction* runTipAction;
	KAction* wizardAction;
	KAction* helpAction;
	KAction* whatsThisAction;
	KAction* emailAction;
	KAction* browserAction;
	KToggleAction* toolBarToggleAction;
	KToggleAction* statusBarToggleAction;
	KToggleAction* taskBarToggleAction;
	KToggleAction* transferViewToggleAction;
	KToggleAction* localFileSysToggleAction;
	KActionCollection* myActionCollection;
	KToolBar* toolBar;
	KConfig* myConfig;
	QString str_emailDefault;
	bool b_rememberChildPositions;
	QValueList<int> childStartPositions;
	bool b_autoChildFrameMode;
	unsigned int defaultChildFrameMode;
	unsigned int currentChildFrameMode;
	QextMdiChildView* p_activeView;
	bool b_queueTransfers;
	KBearTransferQueue transferQueue;
	QMap<KIO::Job*, KURL> urlDeleteMap;
	KFileOpenWithHandler* openWithHandler;
	KBearSettingsDialog* settingsDialog;
	bool firstRun;
};
#endif

