/***************************************************************************
                          decodlg.cpp  -  description
                             -------------------
    begin                : Fri Apr 20 2001
    copyright            : (C) 2003 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <klocale.h>
#include <kcolorbtn.h>
#include "kpldoubleedit.h"
#include "kplspinbox.h"
#include "kpldoc.h"
#include "decodlg.h"

DecoDlg::DecoDlg(QWidget* _parent, QString caption, QString anchor,
                 KplDoc* model, DecoItem* it0, int nrows) :
 KDialogBase(Plain, caption, Help | Ok | Apply | Cancel, Ok, _parent, 0,
             true, true),
 m(model), it(it0)
{
  grid = new QGridLayout(plainPage(), nrows, 7, 0, spacingHint());
  setHelp(anchor);
  resize(minimumSize());
}

DecoDlg::~DecoDlg()
{
}

void DecoDlg::initEntries(int row)
{
  QFrame* frame = plainPage();
  grid->addWidget(new QLabel("x0", frame), row, 0);
  grid->addWidget(ex0 = new KplDoubleEdit(it->x0, -200.0, 200.0, frame), row, 1);
  grid->addWidget(new QLabel("cm", frame), row, 2);
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), row, 3);
  grid->addWidget(new QLabel("y0", frame), row, 4);
  grid->addWidget(ey0 = new KplDoubleEdit(it->y0, -200.0, 200.0, frame), row, 5);
  grid->addWidget(new QLabel("cm", frame), row++, 6);
  grid->addWidget(lSize = new QLabel(i18n("Size"), frame), row, 0);
  grid->addWidget(eRelSize = new KplSpinBox(10, 800, 1, frame), row, 1);
  eRelSize->setValue(qRound(100 * it->relsiz));
  eRelSize->setSuffix(" %");
  grid->addWidget(new QLabel(i18n("Color"), frame), row, 4);
  grid->addWidget(col = new KColorButton(it->color, frame), row, 5);
}

void DecoDlg::getValues(bool ok)
{
  it->setPos(ex0->value(), ey0->value());
  it->relsiz = 0.01 * eRelSize->interpretedValue();
  it->color = col->color().rgb();
  m->setModified();
  m->backupItems();
  if (ok)
    accept();
}
