/***************************************************************************
                          usrmodem.cpp  -  description                              
                             -------------------                                         
    begin                : Wed Apr 7 1999                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <qstring.h>
#include <qstrlist.h>
#include <qprogressdialog.h>
#include <kapp.h>
#include "usrmodem.h"

#define MODEM_INIT              "ATS43=113\r"
#define MODEM_CLEAR_MEMORY      "AT+MEM\r"
#define MODEM_GET_MEMORY_INFO   "AT+MSR=%i\r"
#define MODEM_GET_MEMORY_INFO2  "AT+MSI\r"
#define MODEM_GET_MEMORY        "AT+MTM\r"
//#define MODEM_RESET             "ATS43=113\r"
#define MODEM_RESET             ""

#define MODEM_DEFAULT_MSG_FILE  "Fax-"
#define MODEM_DEFAULT_TMP_FILE  "FullMemory.tmp"
#define MODEM_USR_PAGE          32768

#define MODEM_ETX	              003
#define MODEM_DLE	              020
#define MODEM_SUB	              032

#define MODEM_NEW_PAGE          100

USRModem::USRModem(char *device, char *baudrate, char *lockfile) :
	ModemConnector(device, baudrate, lockfile)
{
  *memoryFile 	= 0;
  *faxFile    	= 0;
  WasDLE      	= 0;
  tempFile    	= true;
  tempVoiceFile = true;
}

USRModem::~USRModem()
{

  deleteMemoryFile();
  if (tempFile)
    deleteFaxFiles();

  if (tempVoiceFile)
    deleteVoiceFiles();

  resetModem();

}

/** get fax from memoryFile and store separated pages in
    faxFile-<nr> */
bool USRModem::getFax(int id, char *filename=0)
{
  char *tmpStr  = 0;

  if (!memoryFile)
    return false;

  if (tempFile)
    deleteFaxFiles();

	if (!filename)
	{
	  tempFile = true;
    // get temp filename for whole modem memory
	  if (!(tmpStr = tempnam(0,"fxfax")))
  	  return false;
	  strcpy(faxFile,tmpStr);
  	free(tmpStr);
  } else {
    tempFile = false;
	  strcpy(faxFile,filename);
  }
  if (!ExtractMessage(id, Fax))
    return false;

  return true;
}

/** get voice message from memoryFile and store in
    faxFile.gsm */
bool USRModem::getVoice(int id, char *filename=0)
{
  char *tmpStr  = 0;

  if (!memoryFile)
    return false;

  if (tempVoiceFile)
    deleteVoiceFiles();

	if (!filename)
	{
	  tempVoiceFile = true;
    // get temp filename for whole modem memory
	  if (!(tmpStr = tempnam(0,"fxmsg")))
  	  return false;
	  strcpy(voiceFile,tmpStr);
  	free(tmpStr);
  } else {
    tempVoiceFile = false;
	  strcpy(voiceFile,filename);
  }
  if (!ExtractMessage(id, Voice))
    return false;

  return true;
}

/** get used memory and store it in memoryFile */
bool USRModem::getMemory()
{
  FILE *tmpFile    	= 0;
  unsigned char c  	= 0;
  bool loop        	= true;
  int byteCount    	= 0;
  int usrPageInput 	= MODEM_USR_PAGE + 2;
  char *tmpStr     	= 0;
  int	bytesTotal 		= 0;
  int kBytesMemUsed	= 0;

	// get KBytes of Memory used in Modem
	kBytesMemUsed = (modemInfo.memSize * 1024 * modemInfo.memUsed) / 100;
	//debug("(%i * 1024 * %i) / 100 = %i",modemInfo.memSize, modemInfo.memUsed,
	//																		kBytesMemUsed);

  deleteMemoryFile();

  // get temp filename for whole modem memory
  if (!(tmpStr = tempnam(0,"fxmem")))
    return false;

  strcpy(memoryFile,tmpStr);
  free(tmpStr);
  /* terminal settings done, now handle in/ouput */
  tmpFile  = fopen(memoryFile,"wb");
  // debug("MemoryFile -> %s",memoryFile);
  flushSerialLine();
  if (!writeStr(MODEM_GET_MEMORY,strlen(MODEM_GET_MEMORY)))
    return false;

	QProgressDialog progress( "Downloading modem memory", 0,
														kBytesMemUsed, kapp->topWidget(), 0, true );
	progress.setProgress( 0 );
	
  while (loop)
  {
    if (!readChar(&c))
      loop = false;
    else
    {
    	bytesTotal++;
    	if ((bytesTotal % 1024) == 0)
    	{
    		progress.setProgress((int)(bytesTotal / 1024));
    	}
    		
      if (byteCount >= usrPageInput) {
	      byteCount = 0;
      }
      if (byteCount > 1) {
        fputc(c,tmpFile);
      }
      byteCount++;
    }
  }
  fclose(tmpFile);
	progress.setProgress( kBytesMemUsed );
	progress.close();
  return true;
}


/** get memory info about stored faxes */
bool USRModem::getMemoryInfo(struct ModemGeneralInfo &moGeneral,
														 ModemMessageList &moMsgList)
{
  int maxIndex               	= 0;
  int i                      	= 0;
	char cmdout[256] = "";
	int len;
	QString modemStr = "";
	QString memInfo  = "";
	QString listInfo  = "";
	
  struct ModemMsgInfoStruct	*moInfo = 0;

  // new memory info means new files
  deleteMemoryFile();
  if (tempFile)
    deleteFaxFiles();

  memset(cmdout,0,strlen(cmdout));
	modemStr.sprintf(MODEM_GET_MEMORY_INFO, maxIndex);
  debug("Command: %s",modemStr.data());
	if (executeCommand(modemStr.data(),cmdout,256, len,"\nOK"))
	{
		debug("success");
		memInfo.setStr(&cmdout[2]);
		// remove trailing \n OK
		memInfo.setStr(memInfo.left(memInfo.find('\n')).data());
		debug("Result: %s",memInfo.data());
	} else
		return false;

  // now we have a string who says how many messages are stored
	maxIndex = memInfo.mid(8,3).toInt() + memInfo.mid(16,3).toInt();
  debug("%s + %s: maxIndex -> %i",memInfo.mid(8,3).data(),
  																memInfo.mid(16,3).data(),maxIndex);

  if (!maxIndex)
    return false;

  // fill ModemGeneralInfo structure
	moGeneral.memSize 					= memInfo.mid(0,3).toInt();
	modemInfo.memSize 					= memInfo.mid(0,3).toInt();
	moGeneral.memUsed 					= memInfo.mid(4,3).toInt();
	modemInfo.memUsed 					= memInfo.mid(4,3).toInt();
	moGeneral.noVoiceMsg 				= memInfo.mid(8,3).toInt();
	modemInfo.noVoiceMsg 				= memInfo.mid(8,3).toInt();
	moGeneral.noVoiceUnreleased	= memInfo.mid(12,3).toInt();
	modemInfo.noVoiceUnreleased	= memInfo.mid(12,3).toInt();
	moGeneral.noFaxMsg 					= memInfo.mid(16,3).toInt();
	modemInfo.noFaxMsg 					= memInfo.mid(16,3).toInt();
	moGeneral.noFaxUnreleased		= memInfo.mid(20,3).toInt();
	modemInfo.noFaxUnreleased		= memInfo.mid(20,3).toInt();
	if (memInfo.mid(24,3).toInt() == 1)
	{
		moGeneral.outMsgPresent = true;
		modemInfo.outMsgPresent = true;
	} else {
		moGeneral.outMsgPresent = false;
		modemInfo.outMsgPresent = false;
	}
	if (memInfo.mid(28,3).toInt() == 1)
	{
		moGeneral.fullMsgPresent = true;
		modemInfo.fullMsgPresent = true;
	} else {
		moGeneral.fullMsgPresent = false;
		modemInfo.fullMsgPresent = false;
	}

  for (i=1;i<=maxIndex;i++)
  {
    listInfo 	= "";
    modemStr 	= "";
    memset(cmdout,0,strlen(cmdout));
    moInfo = 0;

		modemStr.sprintf(MODEM_GET_MEMORY_INFO, i);
  	debug("Command: %s",modemStr.data());
		if (executeCommand(modemStr.data(),cmdout,256, len,"\nOK"))
		{
			debug("success");
			listInfo.setStr(&cmdout[2]);
			// remove trailing \n OK
			listInfo.setStr(listInfo.left(listInfo.find('\n')).data());
			debug("Result: %s",listInfo.data());
		} else
			return false;

    // now create list with all available faxes
		moInfo = new struct ModemMsgInfoStruct;
		CHECK_PTR(moInfo);

		// fill moInfo
		moInfo->msgIndex =	listInfo.mid(0,3).toInt();
		switch (listInfo.mid(4,3).toInt())
		{
			case 1	: moInfo->msgType = Fax; 			break;
			case 2	: moInfo->msgType = Voice; 		break;
			case 3	: moInfo->msgType = Data; 		break;
			default	: moInfo->msgType = unknown;
		}
		moInfo->msgSize =	listInfo.mid(8,3).toInt();
		switch (listInfo.mid(12,3).toInt())
		{
			case 255	: moInfo->msgAttribute = UnreleasedUnchecked;	break;
			case 253	: moInfo->msgAttribute = UnreleasedChecked; 		break;
			case 252	: moInfo->msgAttribute = ReleasedChecked; 			break;
			default		: moInfo->msgAttribute = Atunknown;
		}
		moInfo->msgStatus =	listInfo.mid(16,3).toInt();
		if (listInfo.mid(20,3).toInt() == 255)
		{
			moInfo->clockValid 	= false;
			moInfo->msgDay			= 0;
			moInfo->msgHour			= 0;
			moInfo->msgMinute		= 0;
		} else {
			moInfo->clockValid = true;
			moInfo->msgDay			= listInfo.mid(20,3).toInt();
			moInfo->msgHour			= listInfo.mid(24,3).toInt();
			moInfo->msgMinute		= listInfo.mid(28,3).toInt();
		}
		moInfo->callerId 			= listInfo.mid(32,20);	
		moInfo->msgStartPage 	= listInfo.mid(53,3).toInt();
		moInfo->msgAddress		=	listInfo.mid(57,3).toInt();
		moInfo->msgAddress		=	moInfo->msgAddress << 8;
		moInfo->msgAddress		+= listInfo.mid(61,3).toInt();
		
		// add entry to ModemMessageList
		moMsgList.append(moInfo);
  }
  return true;
}

bool USRModem::clearMemory()
{
  if (writeStr(MODEM_CLEAR_MEMORY,strlen(MODEM_CLEAR_MEMORY)))
  {
    flushSerialLine();
    return true;
  } else
    return false;
}

bool USRModem::getFaxFileName(char *filename)
{
  if (*faxFile)
  {
    strcpy(filename,faxFile);
    return true;
  } else
    return false;
}

bool USRModem::getVoiceFileName(char *filename)
{
  if (*voiceFile)
  {
    strcpy(filename,voiceFile);
    return true;
  } else
    return false;
}

bool USRModem::getMemoryFileName(char *filename)
{
  if (*memoryFile)
  {
    strcpy(filename,memoryFile);
    return true;
  } else
    return false;
}

int USRModem::getPagesWritten()
{
  return pagesWritten;
}

bool USRModem::initModem()
{
	if (strlen(MODEM_INIT) == 0)
		return true;
		
  if (writeStr(MODEM_INIT,strlen(MODEM_INIT)))
    return true;
  else
    return false;
}

bool USRModem::resetModem()
{
	if (strlen(MODEM_RESET) == 0)
		return true;
		
  if (writeStr(MODEM_RESET,strlen(MODEM_RESET)))
    return true;
  else
    return false;
}

void USRModem::faxFileName(char *filename, int pageNo)
{
  sprintf(filename,"%s-%i.g3",faxFile,pageNo);
}

void USRModem::voiceFileName(char *filename)
{
  sprintf(filename,"%s.gsm",voiceFile);
}

bool USRModem::ExtractMessage(int msgNo, MessageType msgType)
{

  FILE *msgFH, *memFH;
  struct USRMemHdr hdr;
  int bytesRead       = 0;
  unsigned long bytePos = 0;
  unsigned long adr   = 0;
  bool found          = false;
  bool readError      = false;
  unsigned char c     = 0;
  int pageNo          = 1;
  char fileName[255]  = "";

  pagesWritten = 0;

  if (msgType == Fax)
  	faxFileName(fileName,pageNo);
  else
  	voiceFileName(fileName);

  if (!(memFH = fopen(memoryFile,"rb"))) {
    return false;
  }
  if (!(msgFH = fopen(fileName,"wb"))) {
    return false;
  }
  /* find appropriate message */
  while ((!found) && (!readError) && (!feof(memFH)))
  {
    /* read header */
    bytesRead=fread(&hdr,34,1,memFH);
    if (bytesRead == 1) {
      if (hdr.mIndex == msgNo) {
	      found = true;
      } else {
	      adr = hdr.mNextAddr1 * 256;
        adr += hdr.mNextAddr2;
	      /* add pages */
	      adr += (hdr.mNextPage - 4) * MODEM_USR_PAGE;
	      fseek(memFH,adr,SEEK_SET);
      }
    } else {
      readError = true;
    }
  }
  /* now file pointer just read message header of right message */
  if (found) {
    debug("position found");
    /* get address of next message and read up to this point into msgFH */
    adr = hdr.mNextAddr1 * 256;
    adr += hdr.mNextAddr2;
    /* add pages */
    adr += (hdr.mNextPage - 4) * MODEM_USR_PAGE;
    bytePos = ftell(memFH);
    found = false;
    while ((!found) && (!feof(memFH)))
    {
      if (bytePos >= adr) {
	      found = true;
      } else {
	      fread(&c,1,1,memFH);
	      /* fwrite(&c,1,1,msgFH); */
	      if (WritePage(msgFH,c) == MODEM_NEW_PAGE)
	      {
  				if (msgType == Fax)
  				{
	        	if ((bytePos + 1) < adr)
	        	{
            	fclose(msgFH);
	          	pageNo++;
            	faxFileName(fileName,pageNo);
            	if (!(msgFH = fopen(fileName,"wb")))
            	{
              	return false;
            	}
	        	}
	        } else
	        	break;
	      }
	      bytePos++;
      }
    }
  }
  fclose(memFH);
  fclose(msgFH);
  if (msgType == Fax)
  	pagesWritten = pageNo;
  	
  return true;
}

int USRModem::WritePage(FILE *msgFile, unsigned char c)
{
  int EndOfPage = 0;

  if ( !WasDLE )
  {
    if ( c == MODEM_DLE ) WasDLE = 1;
    else fputc( c, msgFile );
  }
  else
  {
    if ( c == MODEM_DLE )
      fputc( c, msgFile );	/* DLE DLE -> DLE */
    else
    {
      if ( c == MODEM_SUB )				/* DLE SUB -> 2x DLE */
      {						                /* (class 2.0) */
        fputc( MODEM_DLE, msgFile ); fputc( MODEM_DLE, msgFile );
      }
      else
      {
        if ( c == MODEM_ETX ) EndOfPage = MODEM_NEW_PAGE; /* DLE ETX -> end */
      }
    }
    WasDLE = 0;
  }
  return EndOfPage;
}

void USRModem::deleteMemoryFile()
{
  // remove temp memory file
  if (memoryFile)
  {
    remove(memoryFile);
    *memoryFile = 0;
  }
}

void USRModem::deleteFaxFiles()
{
  int  i          =0;
  char fname[255] = "";

  if ((faxFile) && (pagesWritten))
  {
    for (i=1; i<=pagesWritten;i++)
    {
      faxFileName(fname,i);
      remove(fname);
    }
    *faxFile = 0;
    pagesWritten = 0;
  }
}

void USRModem::deleteVoiceFiles()
{
  char fname[255] = "";

  if (voiceFile)
  {
  	voiceFileName(fname);
		remove(fname);
	}
  *voiceFile = 0;
}


bool USRModem::playVoiceIntern(int index)
{
	char cmdout[256] = "";
	char cmd[256] = "";
	int len;

	debug("play message index %d",index);
	if (executeCommand("AT+MCS=1\r",cmdout,256, len,"\nOK"))
	{
		sprintf(cmd,"AT+MVP=%d\r",index);
		if (executeCommand(cmd,cmdout,256, len,"\nOK"))
		{
			return true;
		}
	}
	return false;
}

bool USRModem::setStandaloneMode()
{
	debug("switch standalone mode on");
	if (executeSimpleCommand("AT+MCS=1\r","\nOK"))
	{
		debug("success");
		return true;
	}
	debug("error!");
	return false;
}

bool USRModem::unsetStandaloneMode()
{
	debug("switch standalone mode off");
	if (executeSimpleCommand("AT+MCS=0\r","\nOK"))
	{
		debug("success");
		return true;
	}
	debug("error!");
	return false;
}

bool USRModem::resetClock()
{
	debug("reset modem clock");
	if (executeSimpleCommand("AT+MCC\r","\nOK"))
	{
		debug("success");
		return true;
	}
	debug("error!");
	return false;
}

bool USRModem::getFaxReception()
{
	char cmdout[256] = "";
	int len;

	debug("get Fax Reception");
	if (executeCommand("AT+MCF?\r",cmdout,256, len,"\nOK"))
	{
		debug("success");
		cmdout[3] = 0;
		if (atoi(&cmdout[2]) == 1)
			return true;
		else
			return false;
	}
	debug("error!");
	return false;
}

bool USRModem::setFaxReception()
{
	debug("switch fax reception on");
	if (executeSimpleCommand("AT+MCF=1\r","\nOK"))
	{
		debug("success");
		return true;
	}
	debug("error!");
	return false;
}

bool USRModem::unsetFaxReception()
{
	debug("switch fax reception off");
	if (executeSimpleCommand("AT+MCF=0\r","\nOK"))
	{
		debug("success");
		return true;
	}
	debug("error!");
	return false;
}

bool USRModem::getVoiceReception()
{
	char cmdout[256] = "";
	int len;

	debug("get Voice Reception");
	if (executeCommand("AT+MCV?\r",cmdout,256, len,"\nOK"))
	{
		debug("success");
		cmdout[3] = 0;
		if (atoi(&cmdout[2]) == 1)
			return true;
		else
			return false;
	}
	debug("error!");
	return false;
}

bool USRModem::setVoiceReception()
{
	debug("switch voice reception on");
	if (executeSimpleCommand("AT+MCV=1\r","\nOK"))
	{
		debug("success");
		return true;
	}
	debug("error!");
	return false;
}

bool USRModem::unsetVoiceReception()
{
	debug("switch voice reception off");
	if (executeSimpleCommand("AT+MCV=0\r","\nOK"))
	{
		debug("success");
		return true;
	}
	debug("error!");
	return false;
}

bool USRModem::getControlMonitor()
{
	char cmdout[256] = "";
	int len;

	debug("get Control Monitor Status");
	if (executeCommand("AT+MCM?\r",cmdout,256, len,"\nOK"))
	{
		debug("success");
		cmdout[3] = 0;
		if (atoi(&cmdout[2]) == 1)
			return true;
		else
			return false;
	}
	debug("error!");
	return false;
}

bool USRModem::setControlMonitor()
{
	debug("switch control monitor on");
	if (executeSimpleCommand("AT+MCM=1\r","\nOK"))
	{
		debug("success");
		return true;
	}
	debug("error!");
	return false;
}

bool USRModem::unsetControlMonitor()
{
	debug("switch control monitor off");
	if (executeSimpleCommand("AT+MCM=0\r","\nOK"))
	{
		debug("success");
		return true;
	}
	debug("error!");
	return false;
}

bool USRModem::setSetupRings(int rings)
{
	QString tmp;
	if ((rings < 3) || (rings > 6))
		return false;
		
	tmp.sprintf("AT+MCR=%i\r",rings);
	debug("set number of rings");
	if (executeSimpleCommand(tmp.data(),"\nOK"))
	{
		debug("success");
		return true;
	}
	debug("error!");
	return false;
}

int  USRModem::getSetupRings()
{
	char cmdout[256] = "";
	int len;
	int tmp = 0;

	debug("get Number of Rings");
	if (executeCommand("AT+MCR?\r",cmdout,256, len,"\nOK"))
	{
		debug("success");
		cmdout[3] = 0;
		tmp = atoi(&cmdout[2]);
		return tmp;
	}
	debug("error!");
	return 0;
}

bool USRModem::setVoiceDuration(int sec)
{
	QString tmp;
	if ((sec < 0) || (sec > 255))
		return false;
		
	tmp.sprintf("AT+MVD=%i\r\n",sec);
	debug("set voice duration: %s",tmp.data());
	if (executeSimpleCommand(tmp.data(),"\nOK"))
	{
		debug("success");
		return true;
	}
	debug("error!");
	return false;
}

int  USRModem::getVoiceDuration()
{
	char cmdout[256] = "";
	int len;
	QString str;

	debug("get voice duration");
	if (executeCommand("AT+MVD?\r",cmdout,256, len,"\nOK"))
	{
		debug("success");
		str.setStr(&cmdout[2]);
		// remove rtailing \n OK
		str.setStr(str.left(str.find('\n')).data());
		debug("duration %s",str.data());
		return str.toInt();
	}
	debug("error!");
	return 0;
}

bool USRModem::setSetupFaxId(QString id)
{
	QString tmp = "";
	tmp.sprintf("AT+MFI=\"%s\"\r",id.data());
	
	debug("set Fax Id with %s",tmp.data());
	if (executeSimpleCommand(tmp.data(),"\nOK"))
	{
		debug("success");
		return true;
	}
	debug("error!");
	return false;
}

QString *USRModem::getSetupFaxId()
{
	char cmdout[256] = "";
	int len;
	QString *tmp = new QString;

	debug("get Fax Id");
	if (executeCommand("AT+MFI?\r",cmdout,256, len,"\nOK"))
	{
		debug("success");
		tmp->setStr(&cmdout[3]);
		// remove rtailing " OK
		tmp->setStr(tmp->left(tmp->findRev('"')).data());
		return tmp;
	}
	debug("error!");
	tmp->setStr("");
	return tmp;
}

bool USRModem::commitSetup()
{
	debug("commit setup");
	if (executeSimpleCommand("AT+MCW\r","\nOK"))
	{
		debug("success");
		return true;
	}
	debug("error!");
	return false;
}



























