/***************************************************************************
                          messenger.h  -  description                              
                             -------------------                                         
    begin                : Mon Apr  5 09:53:56 MEST 1999
                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef MESSENGER_H
#define MESSENGER_H 
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for QT
#include <qprinter.h>
#include <qpainter.h>
#include <qstrlist.h>
#include <qscrollview.h>

// include files for KDE 
#include <kapp.h> 
#include <ktmainwindow.h>
#include <kaccel.h>
#include <kiconloader.h>
#include <kprocess.h>
#include <kmsgbox.h>

// application specific includes
#include "messengerview.h"
#include "usrmodem.h"
#include "resource.h"
#include "ModemControl.h"

// defaults for configurable values
#define LOCKPATH				"/var/lock"
#define LOCKFILE    		"/var/lock/LCK..modem"
#define MODEMDEVICE 		"/dev/modem"
#define BAUDRATE 				"38400"
#define FAXVIEWER   		"kfax"
#define VOICEPROCESSOR	"tcat"
#define AUDIODEVICE			"/dev/audio"


struct MessengerConfigurator
{
  /** flag if toolbar is visible or not. Used for kconfig and checking the
    * view-menu entry view toolbar. bViewStatusbar does the same for the
    * statusbar.
    */
  bool bViewToolbar;
  bool bViewStatusbar;
  /** used for KConfig to store and restore menubar position. Same with
    * tool_bar_pos. If more menubars or toolbars are created, you should add
    * positions as well and implement them in saveOptions() and readOptions().
    */
  KMenuBar::menuPosition menu_bar_pos;
  KToolBar::BarPosition tool_bar_pos;

  // config values Messenger dependend
  QString serialLine;
  QString baudrate;
  QString faxViewer;
  QString voiceProcessor;
  QString audioDevice;
  QString lockfile;

};

/**
  * This Class is the base class for your application. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class MessengerView is
  * created which creates your view.
  */
class MessengerApp : public KTMainWindow
{
  Q_OBJECT

public:
  /** construtor */
  MessengerApp(); 
  /** destructor */
  ~MessengerApp();
  /** initMenuBar creates the menu_bar and inserts the menuitems */
  void initMenuBar();
  /** this creates the toolbars. Change the toobar look and add new toolbars in this
    * function */
  void initToolBar();
  /** setup the statusbar */
  void initStatusBar();
  /** setup the mainview*/
  void initView();
  /** initialize the modem object */
  void initModem();
  /** save the app-specific options on slotAppExit or by an Options dialog */
  void saveOptions();
  /** read the app-specific options on init() or by an Options dialog */
  void readOptions();
  /** enable menuentries/toolbar items */
  void enableCommand(int id_);
  /** disable menuentries/toolbar items */
  void disableCommand(int id_);
  /** overloaded for Message box on last window exit */
  bool queryExit();

  // stores Configuration values of Messenger
  struct MessengerConfigurator configuration;

 signals:
  void gotData(struct ModemGeneralInfo, ModemMessageList);

 public slots:
  /** switch argument for slot selection by menu or toolbar ID */
  void commandCallback(int id_);
  /** switch argument for Statusbar help entries on slot selection */
  void statusCallback(int id_);
  /** exits the application */
  void slotFileQuit();
  /** toggle the toolbar*/
  void slotViewToolBar();
  /** toggle the statusbar*/
  void slotViewStatusBar();
  /** change the status message to text */
  void slotStatusMsg(const char *text);
  /** change the status message of the whole statusbar temporary */
  void slotStatusHelpMsg(const char *text);
  // OWN SLOTS
  /** open popup menu when right MB was clicked over row */
  void slotOpenPopup(int index, int column);
  /** slots to get Info from modem */
  void slotSetFaxIndex(int index, int column);
  void slotGetMemoryInfo();
  void slotClearMemory();
  void slotGetMemory();
  void slotGetFax(char *filename);
  void slotViewFax();
  void slotSaveFax();
  void slotPrintFax();
  // slots to process voice messages
  void slotGetVoice(char *filename);
  void slotSaveVoice();
  void slotSaveGeneric();
  void slotPlayIntern();
  void slotPlaySoundcard();

	/** slots to control the modems features */
	void slotResetClock();
	void slotCommitSetup();

  /** start the config dialog */
  void slotSettings();
  /** start the modem config dialog */
  void slotModemControl();
  /** disable most settings */
  void slotDisableMost();

private:
	/** faxHandler will get the fax files and store them temporary */
  int faxHandler();
	/** voiceHandler will get the voice file and store it temporary */
  bool voiceHandler();

  int		setModemControlValues(struct ModemControlStruct, struct ModemControlStruct);
  void 	getModemControlValues(struct ModemControlStruct&, struct ModemControlStruct&);

  /** file_menu contains all items of the menubar entry "File" */
  QPopupMenu *file_menu;
  /** view_menu contains all items of the menubar entry "View" */
  QPopupMenu *view_menu;
  /** modem menu contains modem commands */
  QPopupMenu *modem_menu;
  /** config menu contains the setting dialog menu */
  QPopupMenu *config_menu;
  /** help_menu contains all items of the menubar entry "Help" */
  QPopupMenu *help_menu;
  /** fax_popup_menu is the menu that appears when the user presses
    * the right mouse button over a row with a fax message */
  QPopupMenu *fax_popup_menu;
  /** voice_popup_menu is the menu that appears when the user presses
    * the right mouse button over a row with a voice message */
  QPopupMenu *voice_popup_menu;
	/** control_menu stores all control actions to the modem */

  /** view is the main widget which represents your working area. The View
    * class should handle all events of the view widget.  It is kept empty so
    * you can create your view according to your application's needs by
    * changing the view class. */
  MessengerView *view;
  // OWN DEFINITIONS
  USRModem *modem;
  /** process to spawn a kfax child process */
  KProcess proc;
  bool 	_modemInitialized;
  int 	_tabListIndex;
  int 	_faxIndex;
  MessageType _msgType;

};
 
#endif // MESSENGER_H








































