#ifndef KWIN_H 
#define KWIN_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>
#include <ktopwidget.h>
#include <ktreelist.h>
#include <kprocess.h>
#include <kbutton.h>
#include <klined.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <ktablistbox.h>
#include <kmsgbox.h>
#include <kfiledialog.h>
#include <kfileinfo.h>
#include "kwinwidget.h"

class KWin : public KTopLevelWidget
{
	Q_OBJECT

public slots:
	void addResources(KProcess *, char *,int);
	void start();
	void removeitem();
	void mpress();
	void upress();
	void opress();
public:
	KWin(QWidget *parent = 0, const char *name = 0);
	virtual ~KWin();
	void UpdateMountList();

protected slots:
	void invokeHelp();

private:
	KMenuBar   *menuBar;
	KStatusBar *statusBar;
	KToolBar   *toolBar;
	KTreeList  *treeList;
	KTabListBox   *mountList;
	QPixmap *printer, *disk, *computer;
	KWinWidget *view;
	KLined *host,*ip;

	void Browse(char *, char *);
	
};

class KMount : public KTopLevelWidget
{
	Q_OBJECT

public slots:
	void cpress();
	void mpress();
	void pexit(KProcess *);
	void pstdout(KProcess *, char *,int);
	void bpress();

public:
	KMount(QWidget *parent = 0, const char *name = 0, const char *res=0,KWin * p=0);
	virtual ~KMount();
private:
	KWin *kwin;
	KWinWidget *view;
	KLined *mpoint, *uid, *gid, *pwd, *mode1, *mode2;

	QLabel *status;
	char resource[1024];
};


#endif // KWIN_H 
