// -*- c++ -*-

#ifndef KSPEECH_H
#define KSPEECH_H

#include <qstring.h>
#include <qcstring.h>
#include <qobject.h>

class KProcess;

/**
 * A simple API for speech synthesis. This class aims to provide a high
 * level API to speech synthesis which is independent of the underlying
 * synthesiser.
 *
 * At the moment the system will only read plain text, but there is also
 * some code under development to use the SABLE speech markup language
 * to allow fine grained control over the output. In addition to being
 * able to create SABLE markup in application code (already possible),
 * it should also be possible to map QML input directly to SABLE.
 *
 * @version $Id$
 * @author Richard Moore, rich@kde.org
 */
class KSpeech : public QObject
{
  Q_OBJECT

protected:
  KSpeech();
  virtual ~KSpeech();

public:
  static KSpeech *getSynth();

  /**
   * Say a short piece of text (eg. 'File'). This method should not
   * be used for long pieces of text such as the contents of a text
   * editor buffer, use the read() methods instead.
   */
  bool say( const QString &text );

  /**
   * Read a piece of text. This method is intended to be used for
   * texts that are too long for the say() method.
   */
  bool read( const QString &text,
	     const QString &mime = QString::null );  

  bool readFile( const QString &file );

  void stop();

protected slots:
  void done();

private:
  KProcess *process;
  QCString speechText;
};

#endif // KSPEECH_H
