#ifndef ITEMLISTA_H 
#define ITEMLISTA_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>
#include <qlistbox.h>
#include <qpainter.h>
#include <qlistview.h>


class MyListBoxItem : public QListBoxItem    
{    
public:        

	MyListBoxItem( const char *s, const QPixmap p )          
	 : QListBoxItem(), pm(p)            
		{ setText( s ); }    
	
	void setNumSerie(int num){numSerie=num;}
	int getNumSerie(){return numSerie;}
	//void setPredet(bool x){predet=x;}
	//bool isPredet(){return predet;}

protected:  

     	virtual void paint( QPainter * p)

	   {        
   	        p->drawPixmap( 3, 0, pm );        
        	QFontMetrics fm = p->fontMetrics();
   	        int yPos;                 //vertical text position     
         	if ( pm.height() < fm.height() ) 
                  yPos= fm.ascent() + fm.leading()/2;        
      	        else       
                  yPos = pm.height()/2 -fm.height()/2 + fm.ascent();        
         	p->drawText( pm.width() + 5, yPos, text());
	    }    
	
	        
	virtual int height(const QListBox * lb ) const  

	     {       
              return QMAX( pm.height(), lb->fontMetrics().lineSpacing() +1 );
             	}     
   

	virtual int width( const QListBox * lb) const
	    {
	      return pm.width() + lb->fontMetrics().width( text() ) + 6;    
	    }	  

	virtual const QPixmap *pixmap() { return &pm; }    

private:
       QPixmap pm;    
       int numSerie; 
	bool predet;
	};   

//-----------------------------------------------------------
//-----------------------------------------------------------


#endif ITEMLISTA_H 
