/*************************************************************************
 *
 *  Copyright (C) 1998 Neil Hart (nhart@magma.ca)
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Id: kprintappl.h,v 1.9 1998/04/27 19:21:15 nhart Exp $
 *                                                                   
 *************************************************************************/

#ifndef __KPRINTAPPL_H__
#define __KPRINTAPPL_H__

#include "kprintadmin.h"
#include "kprintcap.h"
#include "kgsinfo.h"

#include <qstring.h>

#include <kapp.h>
#include <kcontrol.h>


class KPrinterAdmin;

class KPrinterApplication : public KControlApplication
{
public:

	KPrinterApplication(int& argc, char** argv, const char* name);

	void init();
	void apply();
	void help();
	int numberOfPrinters();
	int addNewLocalPrinter(const QString& name, const QString& model, 
		const QString& spooldir, const QString& filter, const QString& device,
		const QString& note);
	int addNewRemotePrinter(const QString& name, const QString& spooldir,
		const QString& host, const QString& remqueue, const QString& note);
	bool removePrinter(int printerNumber, bool removeDirs);
	bool getPrinterLocation(int printerNumber, bool* isLocal);
	bool getPrinterName(int printerNumber, QString* name);
	bool getPrinterModel(int printerNumber, QString* model);
	bool getPrinterFilter(int printerNumber, QString* filter);
	bool getPrinterSpooldir(int printerNumber, QString* spooldir);
	bool getPrinterDevice(int printerNumber, QString* device);
	bool getPrinterHost(int printerNumber, QString* host);
	bool getPrinterQueue(int printerNumber, QString* remqueue);
	bool getPrinterNote(int printerNumber, QString* note);
	bool getPrinterDescription(int printerNumber, QString* desc);
	bool changePrinterName(int printerNumber, const char* name);
	bool changePrinterModel(int printerNumber, const char* model);
	bool changePrinterFilter(int printerNumber, const char* filter);
	bool changePrinterSpooldir(int printerNumber, const char* spooldir,
		bool removeDirs);
	bool changePrinterDevice(int printerNumber, const char* device);
	bool changePrinterHost(int printerNumber, const char* host);
	bool changePrinterQueue(int printerNumber, const char* remqueue);
	bool changePrinterNote(int printerNumber, const char* note);

	int  numberOfPrinterTypes();
	bool getPrinterGsType(int index, QString** pType);
	bool getPrinterGsFilter(int index, QString** pFilter);
	bool getTypeFromFilter(const QString* filter, QString** pType);
	bool getIndexFromFilter(const QString* filter, int* pIndex);

	bool defaultPrinterName(QString* qs);

	bool getDeviceAvailability(bool* lp0Available, bool* lp1Available, 
		bool* lp2Available);

private:

	KPrinterAdmin* admin;
	KPrintcap kpc;
	KGhostscriptInfo kgi;
	bool deviceAvailable[3];
	void determineDeviceAvailability();

};

#endif
