#include "dlgmove.h"

dlgMove::dlgMove(
						listView *S,
						listView *D,
					   const char *SP,
					   const char *DP,
						QWidget *parent,
						const char *name)
						: QDialog(parent,name,true){

	Source = S;		
	Dest 	 = D;
	SourcePath = SP;
	DestPath = DP;
	
	abbruch = false;
	
	initDialog();
	init();
	
	startTimer(100);
}

void dlgMove::init()
{	
		if(Source->itemsSelected() == 0)
		{
				delDir(*Source->lastItemClicked->text[0]);
		}
		else
		{
			listItem *li = Source->Liste->next;
			while(li != 0)
			{
				if(li->selected)
					delDir( *li->text[0]);
				li = li->next;
				if(abbruch == true) break;
			}
		}
}

void	dlgMove::timerEvent(QTimerEvent *t)
{
  QString labText,source,dest;
	killTimers();
	int counter = 0;
	ProgressBar_1->setValueRange(0,stack.count());
	
	while(!stack.isEmpty())
		{
			movelabel_1->setText(i18n("Move  ") + QString(stack.getFirst()));
		  if (abbruch == true) break;
			kapp->processEvents();
			source = stack.getFirst();
			QDir deldir((const char*)SourcePath+source);
			if (deldir.exists())
				{
					source = stack.getFirst();
					deldir.rename((const char*)SourcePath+source,(const char*)DestPath+source,true);
				}
			 else
				{
						source = stack.getFirst();					
						
						nextfile = false;										
			      proc.clearArguments();
						proc << "mv";
						proc << (const char*)SourcePath+source;
						proc << (const char*)DestPath+source;
						QApplication::connect(&proc, SIGNAL(processExited(KProcess *)),this, SLOT(slotExamine()));
						proc.start(KProcess::Block,KProcess::All);

									while(!nextfile)
									{
									kapp->processEvents();
                  }
				}
			stack.removeFirst();
			counter ++;
			ProgressBar_1->setValue(counter);
			if(abbruch == true) break;
		}
		
	Source->readDir(SourcePath);			// und ListView refreshen
	Dest->readDir(DestPath);			// und ListView refreshen
	close();	
	
}

void dlgMove::delDir(QString ldir)
{
	QDir neu;
	QFile delfile;
	neu.setPath(SourcePath+ldir);

	if(!neu.exists())   //fr den Fall, das es nur ein File ist
		{
			stack.append(ldir);
			return;
		}
	else stack.append(ldir);  // ansonsten Hauptdirectory einbauen !!
	
	if ( !neu.isReadable() )
		{	
		 debug("Permission denied");
		 return;
		}
}

void  dlgMove::initDialog(){
	ProgressBar_1 = new myProgress(0,99,0,myProgress::Horizontal,this,"Balken1");
	ProgressBar_1->setGeometry(10,60,330,20);
	ProgressBar_1->setBarColor(darkBlue);
	
	movelabel_1 = new QLabel(this,"Move");
	movelabel_1->setGeometry(10,20,330,20);
	
	cancelBtn = new QPushButton(i18n("Cancel"),this);
	cancelBtn->setGeometry(110,90,100,30);
  connect(cancelBtn,SIGNAL(clicked()),SLOT(cancelPressed()));
  	
  this->resize(350,130);
  this->setMinimumSize(100,10);
}

void dlgMove::slotExamine()
{
	nextfile = true;
}

void dlgMove::cancelPressed()
{
   abbruch = true;
   close();
}

dlgMove::~dlgMove()
{
	delete ProgressBar_1;
	delete cancelBtn;
	delete movelabel_1;
}