#include "mini-kcommander2.xpm"
#include "resource.h"

// include files for QT
#include <qdir.h>
#include <qstrlist.h>
#include <qprinter.h>
#include <qpainter.h>

// include files for KDE
#include <kiconloader.h>
#include <kmsgbox.h>
#include <kfiledialog.h>
#include <klocale.h>

// application specific includes
#include "kcommander2.h"
#include "mainslots.h"
#include "aboutwindow.h"


KCommander2App::KCommander2App()
{
	config=kapp->getConfig();
	init();
}

KCommander2App::~KCommander2App()
{
	delete linkerListView;
 	delete rechterListView;
	for(int i=0;i<7;i++)
		delete buttonLeiste[i];
	delete cg1;
	delete cg2;
/*		wahrscheinlich wird menu & popupmenu automatisch deleted!!!
	delete popup0;
	delete popup1;
	delete popup2;
	delete popup3;
	delete popup4;
	delete popup5;
	delete popup6;
*/
}

void KCommander2App::initKeyAccel()
{
	key_accel = new KAccel( this );
  key_accel->readSettings();	
}

void KCommander2App::initMenuBar()
{
}

void KCommander2App::initToolBar()
{
/*
  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  toolBar()->insertButton(Icon("filenew.xpm"), ID_FILE_NEW, true, i18n("New File") );
  toolBar()->insertButton(Icon("fileopen.xpm"), ID_FILE_OPEN, true, i18n("Open File") );
  toolBar()->insertButton(Icon("filefloppy.xpm"), ID_FILE_SAVE, true, i18n("Save File") );
  toolBar()->insertButton(Icon("fileprint.xpm"), ID_FILE_PRINT, true, i18n("Print") );
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("editcut.xpm"), ID_EDIT_CUT, true, i18n("Cut") );
  toolBar()->insertButton(Icon("editcopy.xpm"), ID_EDIT_COPY, true, i18n("Copy") );
  toolBar()->insertButton(Icon("editpaste.xpm"), ID_EDIT_PASTE, true, i18n("Paste") );
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("help.xpm"), ID_HELP_CONTENTS, SIGNAL(clicked() ),
  				kapp, SLOT( appHelpActivated() ), true,i18n("Help"));

  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars by their according number
	// connect for invoking the slot actions
  connect(toolBar(), SIGNAL(clicked(int)), SLOT(commandCallback(int)));
	// connect for the status help on holing icons pressed with the mouse button
  connect(toolBar(), SIGNAL(pressed(int)), SLOT(statusCallback(int)));
*/
}



void KCommander2App::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,true);
  toolBar()->setItemEnabled(id_,true);
}

void KCommander2App::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,false);
  toolBar()->setItemEnabled(id_,false);
}




void KCommander2App::saveOptions()										// Optionen speichern
{	
	QString s;
	KConfig *config;
	config = kapp->getConfig();
	
	config->setGroup("KC_GENERAL");
	config->writeEntry("Version:",VERSION);
	config->writeEntry("FensterX",x());
	config->writeEntry("FensterY",y());
	config->writeEntry("FensterB",width());
	config->writeEntry("FensterH",height());
	for(int i=0;(i<commandBox->count()) && (i<30);i++)
	{
		s.sprintf("Kommando%d",i);
		config->writeEntry(s,commandBox->text(i));
	}
	
	config->setGroup("LISTVIEWENTRYS");
	config->writeEntry("BackgroundColor",linkerListView->backgroundColor.rgb());
	config->writeEntry("SelBackgroundColor",linkerListView->selBackgroundColor.rgb());
	config->writeEntry("forgroundColor",linkerListView->forgroundColor.rgb());
	config->writeEntry("selForgroundColor",linkerListView->selForgroundColor.rgb());
  config->writeEntry("LinkerPath",leftDirPath);
  config->writeEntry("rechterPath",rightDirPath);

  config->writeEntry("cursorRand",linkerListView->cursorRand.rgb());
  config->writeEntry("cursorFilled",linkerListView->cursorFilled);
  config->writeEntry("cursorColor",linkerListView->cursorColor.rgb());
  config->writeEntry("cursorColorSelected",linkerListView->cursorColorSelected.rgb());
  config->writeEntry("cursorTextColor",linkerListView->cursorTextColor.rgb());
  config->writeEntry("cursorTextColorSelected",linkerListView->cursorTextColorSelected.rgb());

// Spaltenbreiten speichern
	for(int i=0;i<4;i++)
	{
		s.sprintf("Spalte%d",i);
		config->writeEntry(s,linkerListView->columWidth[i]);
	}
  
  config->sync();
	
}


void KCommander2App::readOptions()                    // Optionen laden
{
	KConfig *config;
	QString s;
	int fx,fy,fb,fh;
	config = kapp->getConfig();
	config->setGroup("KC_GENERAL");
	// Version des KC, der die Optionen geschrieben hat
	s = config->readEntry("Version:","0");
			
	// Fenstereinstellungen
	fx = config->readNumEntry("FensterX",x());
	fy = config->readNumEntry("FensterY",y());
	fb = config->readNumEntry("FensterB",width());
	fh = config->readNumEntry("FensterH",height());
  // mainwindow Koordinaten setzen
  setGeometry(fx,fy,fb,fh);
	
	commandBox->clear();
	for(int i=0;i<30;i++)
	{
    s.sprintf("Kommando%d",i);
    s = config->readEntry(s,"");
    if(s == "") break;
    commandBox->insertItem(s);
	}
	commandBox->setEditText("");
	
//****************************************************************************	
	config->setGroup("LISTVIEWENTRYS");
	QRgb farbe;
	
	farbe = config->readNumEntry("BackgroundColor",0xffffff);
	linkerListView->backgroundColor = QColor(farbe);
	rechterListView->backgroundColor = QColor(farbe);
	
	farbe = config->readNumEntry("SelBackgroundColor",0x0000cc);
	linkerListView->selBackgroundColor = QColor(farbe);
	rechterListView->selBackgroundColor = QColor(farbe);
	
	farbe = config->readNumEntry("forgroundColor",0x000000);
	linkerListView->forgroundColor = QColor(farbe);
	rechterListView->forgroundColor = QColor(farbe);
	
	farbe = config->readNumEntry("selForgroundColor",0xff0000);
	linkerListView->selForgroundColor = QColor(farbe);
	rechterListView->selForgroundColor = QColor(farbe);
	
	farbe = config->readNumEntry("cursorRand",0x0000ff);
	linkerListView->cursorRand = QColor(farbe);
	rechterListView->cursorRand = QColor(farbe);
  
	farbe = config->readNumEntry("cursorColor",0xff00ff);
	linkerListView->cursorColor = QColor(farbe);
	rechterListView->cursorColor = QColor(farbe);

	bool flag = config->readBoolEntry("cursorFilled",false);
	linkerListView->cursorFilled = flag;
	rechterListView->cursorFilled = flag;
	  
	farbe = config->readNumEntry("cursorColorSelected",0xcccccc);
	linkerListView->cursorColorSelected = QColor(farbe);
	rechterListView->cursorColorSelected = QColor(farbe);
  
	farbe = config->readNumEntry("cursorTextColor",0xff00ff);
	linkerListView->cursorTextColor = QColor(farbe);
	rechterListView->cursorTextColor = QColor(farbe);
  
	farbe = config->readNumEntry("cursorTextColorSelected",0xcccccc);
	linkerListView->cursorTextColorSelected = QColor(farbe);
	rechterListView->cursorTextColorSelected = QColor(farbe);
  
  leftDirPath = config->readEntry("LinkerPath","/");
  rightDirPath = config->readEntry("rechterPath","/");
		
// Spaltenbreiten laden
	int n;
	for(int i=0;i<4;i++)
	{
		s.sprintf("Spalte%d",i);
		if(config->hasKey(s))
				n = config->readNumEntry(s,linkerListView->columWidth[i]);
		else
				if(i > 0)
					n = linkerListView->columWidth[i-1]+100;
				else
					n = (i+1)*100;
		linkerListView->columWidth[i] = n;
		rechterListView->columWidth[i] = n;
	}
	
	linkerListView->refreshColums(0);
	rechterListView->refreshColums(0);
	
	linkerListView->readDir(leftDirPath);
	rechterListView->readDir(rightDirPath);
	itemSelected();
	
	config->setGroup("Packer");
	packMethode = config->readEntry("Methode","gzip");
}

void KCommander2App::init()
{
//     KToolBar *file_toolbar = new KToolBar(this);
/*
     KToolBarButton *temp;
     QPixmap *tempPm;
     
//KToolBarButton (const QPixmap& pixmap, int id, QWidget *parent, const char *name=0L, int item_size = 26, const char *txt=0, bool _mb = false)     
    tempPm = new QPixmap((const char **)filenew);
		temp = new KToolBarButton(*tempPm,TB0,this,"New File",26,"text",false);
		temp->setFocusPolicy(NoFocus);
    file_toolbar->insertButton(temp);
		     
    tempPm = new QPixmap((const char **)fileopen);
		temp = new KToolBarButton(*tempPm,TB1,this,"Open File",26,"text",false);
		temp->setFocusPolicy(NoFocus);
		  
    tempPm = new QPixmap((const char **)fileprint);
		temp = new KToolBarButton(*tempPm,TB2,this,"Print File",26,"text",false);
		temp->setFocusPolicy(NoFocus);
     
    tempPm = new QPixmap((const char **)filesave);
		temp = new KToolBarButton(*tempPm,TB3,this,"Save File",26,"text",false);
		temp->setFocusPolicy(NoFocus);
     
    tempPm = new QPixmap((const char **)help);
		temp = new KToolBarButton(*tempPm,TB4,this,"Help",26,"text",false);
		temp->setFocusPolicy(NoFocus);
*/     	



// ************************************************************************************
//								die beiden Balken die ber den Listviews sind
// ************************************************************************************
    leftSelLabel = new QLabel(this);		// selektierte Files anzeigen
    rightSelLabel = new QLabel(this);

// ************************************************************************************
//								die kleine blaue Diskette
// ************************************************************************************
    QPixmap *pm = new QPixmap((const char **)mini);
		setIcon(*pm);
	
// ************************************************************************************
// 								ColorGroup fr aktiven dirPathButton
// ************************************************************************************
// ColorGroup fr aktiven dirPathButton
	cg1 = new QColorGroup(  QColor(0,0,0),//const QColor & foreground,
							QColor(0,0,180),
							QColor(0xf0,0xf0,0xf0),//const QColor & light,
							QColor(0x30,0x30,0x30),//const QColor & dark,
							QColor(0xc0,0xc0,0xc0),//const QColor & mid,
							QColor(0xf0,0xf0,0xf0),//const QColor & text,
							QColor(0xc0,0xc0,0xc0)//const QColor & base )
							);
// ColorGroup fr deaktiven dirPathButton
	cg2 = new QColorGroup(  QColor(0,0,0),//const QColor & foreground,
							backgroundColor(),//const QColor & background,
							QColor(0xf0,0xf0,0xf0),//const QColor & light,
							QColor(0x30,0x30,0x30),//const QColor & dark,
							QColor(0xc0,0xc0,0xc0),//const QColor & mid,
							QColor(0,0,0),//const QColor & text,
							QColor(0xc0,0xc0,0xc0)//const QColor & base )
							);
	leftDirButton =  new QPushButton(leftDirPath,this,"dbtLeft");
	rightDirButton = new QPushButton(rightDirPath,this,"dbtRight");
	
	leftDirButton ->setPalette(QPalette(*cg2,*cg2,*cg2));
	rightDirButton->setPalette(QPalette(*cg2,*cg2,*cg2));
	leftDirButton ->setFocusPolicy(NoFocus);
	rightDirButton->setFocusPolicy(NoFocus);

// ************************************************************************************
//								die beiden Listviews erstellen
// ************************************************************************************
	linkerListView = new listView(10,10,300,450,this,"lv1");
	rechterListView = new listView(320,10,300,400,this,"lv2");
	connect(linkerListView,SIGNAL(itemSelected(const char *,const char *)),SLOT(itemSelected()));
	connect(linkerListView,SIGNAL(itemDeSelected(const char *,const char *)),SLOT(itemDeSelected(const char *,const char *)));
	connect(linkerListView,SIGNAL(itemClicked(const char *,const char *)),SLOT(itemClicked(const char *,const char *)));
	connect(linkerListView,SIGNAL(itemDoubleClicked(const char *,const char *)),SLOT(itemDoubleClicked(const char *,const char *)));
	connect(linkerListView,SIGNAL(gotFocus()),SLOT(LVgotFocus()));
	connect(linkerListView,SIGNAL(lostFocus()),SLOT(LVlostFocus()));
	connect(linkerListView,SIGNAL(keyPressed(const char *)),SLOT(LVkeyPressed(const char *)));
	connect(linkerListView,SIGNAL(columsChanged()),SLOT(LVcolums()));
	
	connect(rechterListView,SIGNAL(itemSelected(const char *,const char *)),SLOT(itemSelected()));
	connect(rechterListView,SIGNAL(itemDeSelected(const char *,const char *)),SLOT(itemDeSelected(const char *,const char *)));
	connect(rechterListView,SIGNAL(itemClicked(const char *,const char *)),SLOT(itemClicked(const char *,const char *)));
	connect(rechterListView,SIGNAL(itemDoubleClicked(const char *,const char *)),SLOT(itemDoubleClicked(const char *,const char *)));
	connect(rechterListView,SIGNAL(gotFocus()),SLOT(LVgotFocus()));
	connect(rechterListView,SIGNAL(gotFocus()),SLOT(LVlostFocus()));
	connect(rechterListView,SIGNAL(keyPressed(const char *)),SLOT(LVkeyPressed(const char *)));
	connect(rechterListView,SIGNAL(columsChanged()),SLOT(LVcolums()));
	
	
// ************************************************************************************
//								Label & Eingabezeile
// ************************************************************************************
	commandLineLabel = new QLabel(this,"kommandolabel");
	commandLineLabel->setAlignment(AlignRight);
	commandLineLabel->setFocusPolicy(NoFocus);
  commandBox = new QComboBox(true,this,"kommandobox");
  connect(commandBox,SIGNAL(activated(const char *)),SLOT(commandBoxActivated()));

// ************************************************************************************
//								die untere Buttonleiste erstellen
// ************************************************************************************
	
	QString s;
	for(int i=0;i<7;i++)
	{
		s.sprintf("bt%d",i);
		buttonLeiste[i] = new QPushButton("",this,s);
		buttonLeiste[i]->setFocusPolicy(NoFocus);
		buttonLeiste[i]->setStyle(WindowsStyle);
		connect(buttonLeiste[i], SIGNAL(clicked()), this, SLOT(buttonLeistePressed()));
	}
	buttonLeiste[0]->setText(i18n("F3 Show"));
	buttonLeiste[1]->setText(i18n("F4 Edit"));
	buttonLeiste[2]->setText(i18n("F5 Copy"));
	buttonLeiste[3]->setText(i18n("F6 Move"));
	buttonLeiste[4]->setText(i18n("F7 MkDir"));
	buttonLeiste[5]->setText(i18n("F8 Delete"));
	buttonLeiste[6]->setText(i18n("F9 Help"));

// ************************************************************************************
//								die Mens erstellen
// ************************************************************************************

      QMenuBar *menubar = new QMenuBar( this );
      menubar->setSeparator( QMenuBar::Never );

      popup0 = new QPopupMenu;
      popup1 = new QPopupMenu;
      popup2 = new QPopupMenu;
      popup3 = new QPopupMenu;
      popup4 = new QPopupMenu;
      popup5 = new QPopupMenu;
      popup6 = new QPopupMenu;
      
      int id;
      id = popup0->insertItem( i18n("&Change Attributes..."), this, SLOT(menuPressed()), 0, ID_MENU_ATTRIBUTES );
      id = popup0->insertItem(i18n("C&ompress..."),this,SLOT(menuPressed()), 0, ID_MENU_PACK );
      id = popup0->insertItem(i18n("&Decompress..."),this,SLOT(menuPressed()), 0, ID_MENU_UNPACK );
      popup0->setItemEnabled(id,false);
      id = popup0->insertItem(i18n("&Test Archieve(s)..."),this,SLOT(menuPressed()), 0, ID_MENU_TESTARC );
      popup0->setItemEnabled(id,false);
      id = popup0->insertItem(i18n("&Symlinks..."),this,SLOT(menuPressed()), 0, ID_MENU_MAKELINK );
      popup0->setItemEnabled(id,false);
      id = popup0->insertItem(i18n("Properties..."),this,SLOT(menuPressed()), 0, ID_MENU_FILEATTR );
      popup0->setItemEnabled(id,false);
      id = popup0->insertItem(i18n("&Get Diskspace..."),this,SLOT(menuPressed()), 0, ID_MENU_GETMEM );
      popup0->setItemEnabled(id,false);
      id = popup0->insertItem(i18n("&Print"),this,SLOT(menuPressed()), 0, ID_MENU_PRINT );
      popup0->setItemEnabled(id,false);
      popup0->insertSeparator();
      id = popup0->insertItem(i18n("Sp&lit Files..."),this,SLOT(menuPressed()), 0, ID_MENU_SPLITFILE );
      id = popup0->insertItem(i18n("&Join Files..."),this,SLOT(menuPressed()), 0, ID_MENU_JOINFILE );
      popup0->setItemEnabled(id,false);
      id = popup0->insertItem(i18n("&Code Files (MIME, UUE, XXE )..."),this,SLOT(menuPressed()), 0, ID_MENU_CODING );
      popup0->setItemEnabled(id,false);
      id = popup0->insertItem(i18n("Decode Files (MIME, UUE, XXE, BinHex)..."),this,SLOT(menuPressed()), 0, ID_MENU_DECODING );
      popup0->setItemEnabled(id,false);
      popup0->insertSeparator();
      id = popup0->insertItem(i18n("E&xit..."),this,SLOT(menuPressed()), 0, ID_MENU_EXIT );
      
      id = popup1->insertItem( i18n("&Mark Group..."), this, SLOT(menuPressed()), 0, ID_MENU_MARKGROUP );
      id = popup1->insertItem( i18n("&Unmark Group..."), this, SLOT(menuPressed()), 0, ID_MENU_REMARKGROUP );
      id = popup1->insertItem( i18n("Mark All Files"), this, SLOT(menuPressed()), 0, ID_MENU_MARKALL );
      id = popup1->insertItem( i18n("Unmark All Files"), this, SLOT(menuPressed()), 0, ID_MENU_MARKNONE );
      id = popup1->insertItem( i18n("Reverse Selection"), this, SLOT(menuPressed()), 0, ID_MENU_MARKREVERSE );
      popup1->insertSeparator();
      id = popup1->insertItem( i18n("Compare Directorys"), this, SLOT(menuPressed()) );
      popup1->setItemEnabled(id,false);
      id = popup1->insertItem( i18n("Mark New, Hide Same"), this, SLOT(menuPressed()) );
      popup1->setItemEnabled(id,false);
      
      id = popup2->insertItem( i18n("&CD-Directory Tree..."), this, SLOT(menuPressed()) );
      popup2->setItemEnabled(id,false);
      id = popup2->insertItem( i18n("&Search..."), this, SLOT(menuPressed()), 0, ID_MENU_SEARCHFILE );
      id = popup2->insertItem( i18n("System &Information..."), this, SLOT(menuPressed()),0,ID_MENU_SYSINFO );
      id = popup2->insertItem( i18n("&Treelist"), this, SLOT(menuPressed()) );
      popup2->setItemEnabled(id,false);
      id = popup2->insertItem( i18n("&Back"), this, SLOT(menuPressed()) );
      popup2->setItemEnabled(id,false);
      popup2->insertSeparator();
      id = popup2->insertItem( i18n("&Start A Shell"), this, SLOT(menuPressed()),0,ID_MENU_STARTTERM );
      popup2->insertSeparator();
      id = popup2->insertItem( i18n("Mount SMB-Drives..."), this, SLOT(menuPressed()) );
      popup2->setItemEnabled(id,false);
      id = popup2->insertItem( i18n("Umount SMB-Drives..."), this, SLOT(menuPressed()) );
      popup2->setItemEnabled(id,false);
      id = popup2->insertItem( i18n("Create SMB-Service..."), this, SLOT(menuPressed()) );
      popup2->setItemEnabled(id,false);
      id = popup2->insertItem( i18n("Close SMB-Service..."), this, SLOT(menuPressed()) );
      popup2->setItemEnabled(id,false);
      popup2->insertSeparator();
      id = popup2->insertItem( i18n("FT&P-Connection..."), this, SLOT(menuPressed()) );
      popup2->setItemEnabled(id,false);
      id = popup2->insertItem( i18n("FTP &New Connection..."), this, SLOT(menuPressed()) );
      popup2->setItemEnabled(id,false);
      id = popup2->insertItem( i18n("FTP-Close Connection..."), this, SLOT(menuPressed()) );
      popup2->setItemEnabled(id,false);
      id = popup2->insertItem( i18n("FTP-View Hidden Files..."), this, SLOT(menuPressed()) );
      popup2->setItemEnabled(id,false);
      popup2->insertSeparator();
      id = popup2->insertItem( i18n("&Swap Listviews"), this, SLOT(menuPressed()),0,ID_MENU_SWAPLISTVIEWS );
      id = popup2->insertItem( i18n("Adjust Listviews "), this, SLOT(menuPressed()) );
      popup2->setItemEnabled(id,false);

      id = popup3->insertItem( i18n("&Short"), this, SLOT(menuPressed()) );
      popup3->setItemEnabled(id,false);
      id = popup3->insertItem( i18n("&Long"), this, SLOT(menuPressed()) );
      popup3->setItemEnabled(id,false);
      id = popup3->insertItem( i18n("&Directory Tree"), this, SLOT(menuPressed()) );
      popup3->setItemEnabled(id,false);
      id = popup3->insertItem( i18n("Fast View"), this, SLOT(menuPressed()) );
      popup3->setItemEnabled(id,false);
      popup3->insertSeparator();
      id = popup3->insertItem( i18n("&All"), this, SLOT(menuPressed()) );
      popup3->setItemEnabled(id,false);
      id = popup3->insertItem( i18n("&Programms"), this, SLOT(menuPressed()) );
      popup3->setItemEnabled(id,false);
      id = popup3->insertItem( i18n("*.*"), this, SLOT(menuPressed()) );
      popup3->setItemEnabled(id,false);
      id = popup3->insertItem( i18n("&User Defined..."), this, SLOT(menuPressed()) );
      popup3->setItemEnabled(id,false);
      popup3->insertSeparator();
      id = popup3->insertItem( i18n("By &Name"), this, SLOT(menuPressed()) );
      popup3->setItemEnabled(id,false);
//      id = popup3->insertItem( "Nach &Erweiterung", this, SLOT(menuPressed()) );
//      popup3->setItemEnabled(id,false);
      id = popup3->insertItem( i18n("By &Date/Time"), this, SLOT(menuPressed()) );
      popup3->setItemEnabled(id,false);
      id = popup3->insertItem( i18n("By &Size"), this, SLOT(menuPressed()) );
      popup3->setItemEnabled(id,false);
      id = popup3->insertItem( i18n("&Unsorted"), this, SLOT(menuPressed()) ,0,ID_MENU_UNSORTED);
      popup3->setItemEnabled(id,false);
      popup3->insertSeparator();
      id = popup3->insertItem( i18n("Descend Sortorder"), this, SLOT(menuPressed()) );
      popup3->setItemEnabled(id,false);
      popup3->insertSeparator();
      id = popup3->insertItem( i18n("&Refresh Source"), this, SLOT(menuPressed()),0,ID_MENU_QUELLE );


      id = popup4->insertItem( i18n("&Options..."), this, SLOT(menuPressed()),0,ID_MENU_OPTIONS);
      id = popup4->insertItem( i18n("Change Buttonbar..."), this, SLOT(menuPressed()) );
      popup4->setItemEnabled(id,false);

      id = popup5->insertItem( i18n("Change Start Menu..."), this, SLOT(menuPressed()),0,ID_MENU_STARTER );
//      popup5->setItemEnabled(id,false);
      id = popup5->insertItem( i18n("Change Main Menu..."), this, SLOT(menuPressed()) );
      popup5->setItemEnabled(id,false);
      popup5->insertSeparator();
//************************************************************************************************************
		config->setGroup("Startmenu");
		bool flag = true;
		int i=0;
		while(flag)
		{
			s.sprintf("Menutitle%d",i);
			QString titel = config->readEntry(s,"");
			if(titel == "") break;
			popup5->insertItem(titel,ID_STARTMENU+i);
			i++;
		}
//************************************************************************************************************

      id = popup6->insertItem( i18n("About..."), this, SLOT(menuPressed()),0,ID_MENU_HELPABOUT );
      popup6->insertSeparator();
      
      
      
		connect(popup0,SIGNAL(activated ( int )),this,SLOT(menuActivated ( int)));
      connect(popup1,SIGNAL(activated ( int )),this,SLOT(menuActivated ( int)));
      connect(popup2,SIGNAL(activated ( int )),this,SLOT(menuActivated ( int)));
      connect(popup3,SIGNAL(activated ( int )),this,SLOT(menuActivated ( int)));
      connect(popup4,SIGNAL(activated ( int )),this,SLOT(menuActivated ( int)));
      connect(popup5,SIGNAL(activated ( int )),this,SLOT(menuActivated ( int)));
      connect(popup6,SIGNAL(activated ( int )),this,SLOT(menuActivated ( int)));
      
      menubar->insertItem(i18n("&Files"), popup0 );
      menubar->insertItem(i18n("&Mark"),popup1);
      menubar->insertItem(i18n("&Commands"),popup2);
      menubar->insertItem(i18n("&View"),popup3);
      menubar->insertItem(i18n("&Configuration"),popup4);
      menubar->insertItem(i18n("&Start Menu"),popup5);
      menubar->insertItem(i18n("&Help"),popup6);

	

// ************************************************************************************
//								die beiden DriveListen erstellen
// ************************************************************************************
		leftDriveList = new QComboBox(  this, "0" );
		  leftDriveList->setFocusPolicy(NoFocus);
		rightDriveList = new QComboBox( this, "1" );	
		  rightDriveList->setFocusPolicy(NoFocus);

		QFile f("/etc/fstab");
		if ( f.open(IO_ReadOnly) ) {    // file opened successfully
			QTextStream t( &f );        // use a text stream
			QString s;
			while ( !t.eof() ) {        // until end of file...
				s = t.readLine();       // line of text excluding '\n'
				s = s.simplifyWhiteSpace();
				if(s.at(0) == '/')
				{
					if(s.find("SwAP",0,false) == -1)
					{
						// in S msste jetzt nur ein Device stehen, was auch Datentrger ist
						// zuerst mal das erste Leerzeichen finden
						int z = s.find(" /");		// nach Leerzeichen suchen
						if(z == -1)							// wenn z immernoch -1, dann raus hier !
						 break;
						s = s.right(s.length()-z-1);
						z = s.find(" ");
						if( z == -1)
						 break;
						s = "[" + s.left(z) + "]";
						leftDriveList->insertItem(s);
						rightDriveList->insertItem(s);
					}
				}
			}
			f.close();
		}
	connect(leftDriveList,SIGNAL( activated( const char * )),SLOT(driveActivated (const char * )));
	connect(rightDriveList,SIGNAL(activated( const char * )),SLOT(driveActivated (const char * )));
// ************************************************************************************
//								die untere Buttonleiste erstellen
// ************************************************************************************
	readOptions();
	linkerListView->setFocus();
}

void KCommander2App::resizeEvent(QResizeEvent *t)
{

	int breite = (width()-15)/7;

	leftDirButton->setGeometry(110,60,(width()/2)-15-100,20);
	rightDirButton->setGeometry((width()/2)+5+100,60,(width()/2)-15-100,20);
	linkerListView->setGeometry(10,85,(width()/2)-15,height()-165);
	rechterListView->setGeometry((width()/2)+5,85,(width()/2)-15,height()-165);
	commandLineLabel->setGeometry(10,height()-52,linkerListView->width(),20);
	
	for(int i=0;i<7;i++)
		buttonLeiste[i]->setGeometry(10+i*breite,height()-27,breite,25);
	
	leftSelLabel->setGeometry(10,height()-80,(width()/2)-15,20);
	rightSelLabel->setGeometry((width()/2)+5,height()-80,(width()/2)-15,20);
	
	commandBox->setGeometry(width()/2,height()-55,width()/2-10,20);
	
	leftDriveList->setGeometry(10,60,95,20);
	rightDriveList->setGeometry((width()/2)+5,60,95,20);

}


void	KCommander2App::writeRecursiveList(QFile *f, const char *Dirname,int cut)
{
//OK  
	QString q;
	q = Dirname;
  QDir d(q);
	d.setFilter( QDir::Dirs | QDir::Files | QDir::Hidden | QDir::NoSymLinks );

	const QFileInfoList *list = d.entryInfoList();
	QFileInfoListIterator it( *list );      // create list iterator
	QFileInfo *fi;                          // pointer for traversing

	while ( (fi=it.current()) )
	{
		if((fi->fileName() != "..") && (fi->fileName() != "."))
		{
			if(fi->isDir())
			{
				QString t(Dirname);
				t += "/";
				t += fi->fileName();
				//recursiv weiter rein !
				writeRecursiveList(f,t,cut);
			}
			else
			{
				QString d2(Dirname);
				d2 += "/";
				d2 += fi->fileName();
				d2 += "\n";
				d2 = d2.right(d2.length()-cut);
				convert(&d2);
				f->writeBlock(d2,strlen(d2));
			}
		}
	
	++it;                               // goto next list element
  }
	
}
void	KCommander2App::convert(QString * kette)
{ //vor jedes " " ein "\" hngen

	int p=0;
	for(int i=0;i<(signed)strlen(*kette);i++)
	{
		if(kette->mid(p,1) == " ")
			kette->insert(p++,"\\");
		p++;
	}
}

void	KCommander2App::closeEvent ( QCloseEvent * e )
{
	if(optionen::askExit())
	{
	   if(QMessageBox::warning( this,  i18n("System"),i18n("Exit KCommander ??\n"),i18n("&Yes"),"&No Way !!",0, 1 ) == 1)
				return;
	}
	saveOptions();
	e->accept();
	
}

unsigned int KCommander2App::getDirSize(QString pfad,const unsigned int size=0)
{
		unsigned int mySize = size;
		QDir d(pfad);
		d.setSorting(QDir::Name | QDir::DirsFirst | QDir::IgnoreCase);
		d.setFilter(QDir::Files | QDir::Dirs | QDir::Hidden);

if ( d.isReadable() )
{	
   const QFileInfoList * files = d.entryInfoList();
   if ( files ) {
      QFileInfoListIterator it( *files );
      QFileInfo * f;
      
      while( (f=it.current()) != 0 ) {
         ++it;
         if ( f->fileName() == "." || f->fileName() == ".." )
         {
         }
         else
         {
          if ( f->isDir())
            {
          		mySize = getDirSize(pfad + f->fileName() + "/",mySize);
            }
         else
            {
              mySize += f->size() ;
            }
         }
			}
			return mySize;
		}
}

}

void	KCommander2App::exec(const char *t)
{
					KProcess proc;
					proc << "xterm" << "-e" << t;
					proc.start(KProcess::DontCare,KProcess::All);
}



char * KCommander2App::upDir(const char *ss)
{
	char *s = (char *)ss;
  for(int i = strlen(s)-2;i > -1;i--)
  {
  		if(s[i] == '/')
  			{
 				s[i+1] = 0;
 				return s;
  			}
  }
	return s;
}


void	KCommander2App::focusInEvent ( QFocusEvent *e )
{
}









