
#include "dlgcopy2.h"
#include <qfile.h>

dlgCopy2::dlgCopy2(
									listView *S,
									listView *D,
								  const char *SP,	// SourcePath
					  			const char *DP,	// DestPath
									QWidget *parent,
									const char *name) : QDialog(parent,name,true)
{

	overwriteFiles = false;
	ABBRUCH = false;
	sourceLV = S;
	destLV = D;
	sourcePath = SP;
	destPath = DP;
  fileCounter = 0;
  		
	QLabel *l;
	
	prog1 = new myProgress(0,99,0,myProgress::Horizontal,this,"Balken1");
	prog1->setGeometry(10,50,280,20);
	prog2 = new myProgress(0,99,0,myProgress::Horizontal,this,"Balken2");
	prog2->setGeometry(10,100,280,20);
	
	l = new QLabel(i18n("Total Process"),this);
	l->setGeometry(10,80,280,20);
	l->setAlignment(AlignVCenter);
	
	button = new QPushButton(i18n("Cancel"),this);
	
	button->setGeometry(110,140,80,30);
  connect(button,SIGNAL(clicked()),SLOT(btClicked()));
		
	resize(300,180);	// Resize fr 2 Balken
	
	// ist keins selektiert ??
	if(sourceLV->itemsSelected() == 0)
	{
   	// es ist keins selektiert, also den mit dem Focus holen
   	listItem *li = sourceLV->lastItemClicked;
		if(li->listviewIcon	 != sourceLV->foldericon)
		{
			// wenn nur ein FILE angeklickt ist, progr. 2 verstecken
			prog2->hide();
			button->setGeometry(110,80,80,30);
			l->hide();
			resize(300,120);	// Resize fr 2 Balken
		}
	
	}
	else if(sourceLV->itemsSelected() == 1)
	{
   	// es ist ein Item selektiert
   	listItem *li = sourceLV->Liste;
		while(li != 0)
		{
			if(li->selected)
				break;
			li = li->next;
		}
		if(li->listviewIcon	 != sourceLV->foldericon)
		{
			// wenn nur ein FILE selektiert ist, progr. 2 verstecken
			prog2->hide();
			button->setGeometry(110,80,80,30);
			l->hide();
			resize(300,120);	// Resize fr 2 Balken
		}
	
	}
	l = new QLabel(i18n("from :"),this);
	l->setGeometry(10,10,80,20);
//	l->resize(l->sizeHint());
	
	l = new QLabel(i18n("to :"),this);
	l->setGeometry(10,30,80,20);
//	l->resize(l->sizeHint());
	lVon = new QLabel("",this);
	lNach = new QLabel("",this);
	lVon->setGeometry(50,10,240,20);
	lNach->setGeometry(50,30,240,20);
	
	startTimer(200);
}
dlgCopy2::~dlgCopy2()
{
}
void dlgCopy2::btClicked()
{
	ABBRUCH = true;
}

//**********************************************************************
//	eigentliche Routine
//**********************************************************************

void dlgCopy2::timerEvent(QTimerEvent *t)
{
	killTimers();		// timer ist nur zum starten da, also wieder ausschalten

	// so, zuerst eine Stringliste der zu kopierenden Files erstellen
	// sourceLV
	// sourcePath
	sizeCounter = 0;
	if(sourceLV->itemsSelected() == 0)
	{
			readDir(*sourceLV->lastItemClicked->text[0]);
	}
	else
	{
		listItem *li = sourceLV->Liste->next;
		while(li != 0)
		{
			if(li->selected)
				readDir( *li->text[0]);
			li = li->next;
		}
	}
	// nun die Fileliste auswerten
	// ist am Ende ein "/" so muss s als destDir erstellt werden
	
	// Gesamtbytes / BlockSize = Anzahl Progress-Steps Bar 2
	if(prog2->isVisible())
		prog2->setValueRange(0,(int)sizeCounter/SIZE);
  
  int tempReaded = 0;
  int permissions;
  	
	QString s;
	for(int i=0;i<(signed int)fileList.count();i++)
	{
		if(i==0)
			s = fileList.first();
		else
			s = fileList.next();
		if(s.right(1) == "/")
		{
			// Dir erstellen
			s = destPath + s;
			s = s.left(s.length()-1);
			QDir d;
			d.mkdir(s,true);
		}
		else
		{
			//Files copieren
			lVon->setText(sourcePath + s);
			lNach->setText(destPath + s);
			
			QFile sourceFile((const char *)sourcePath + s);
			permissions = optionen::getFilePermission(sourcePath + s);
			QFile destFile  ((const char *)destPath + s);
			
// wenn abgefragt werden soll, dann abfragen			
		if(optionen::askOverwrite())	
		{
			if(destFile.exists() && overwriteFiles == false)
	    {  
	      int frage = QMessageBox::warning( this,  destPath + s,
                                               i18n("File exist...\n"),
                                               i18n("&Overwrite"),
                                               i18n("Overwrite &All"),
                                               i18n("&Cancel"),
                                                1, 
                                                2 );
     		if(frage == 1)
     			overwriteFiles = true;
     		else if(frage == 2)
     		{
					destLV->readDir(destPath);
					accept();
					return;
     		}
     	}
		}
// ansonsten gleich alles berschreiben
repeat:
			bool o = sourceFile.open( IO_ReadOnly);
	  	if(!o)
	    {
	      int frage = QMessageBox::warning( this,  destPath + s,
                                               i18n("Cant Open Sourcefile"),
                                               i18n("&Ignore"),
                                               i18n("&Try Again"),
                                               i18n("&Cancel"),
                                                2,2 );
     		if(frage == 2)
     		{
     			close();
     			break;
     		}
     		if(frage == 1) goto repeat;
     		if(frage == 0) goto ignore;
     	}
			
repeat2:
			o = destFile.open( IO_WriteOnly);
	  	if(!o)
	    {
	      int frage = QMessageBox::warning( this,  destPath + s,
                                               i18n("Cant Create Destinationfile"),
                                               i18n("&Ignore"),
                                               i18n("&Try Again"),
                                               i18n("&Cancel"),
                                                2,2 );
     		if(frage == 2)
     		{
     			sourceFile.close();
     			close();
     			break;
     		}
     		if(frage == 1) goto repeat2;
     		if(frage == 0)
     		{
     			sourceFile.close();
     			goto ignore;
     		}
     	}
			
			
			int readed;
			unsigned int flen = sourceFile.size();
			int bloecke = flen/SIZE+1;
			prog1->setValueRange(0,bloecke);
			bloecke = 0;	//jetzt als Zhler verwenden
    
			do
			{
				readed = sourceFile.readBlock((char *)memory,SIZE);
				destFile.writeBlock((char *)memory,readed);
				prog1->setValue(bloecke++);
				tempReaded += readed;
				if(tempReaded >= SIZE)	// wurden SIZE-Bytes gelesen ?
				{
					// ja
					tempReaded -= SIZE;		// in unserem Fall 8192, eigentlich SIZE, abziehen
					if(prog2->isVisible())
						prog2->setValue(prog2->value()+1);
				}
								
				kapp->processEvents();
				if(ABBRUCH)
				{
					sourceFile.close();
					destFile.close();
					// jetzt noch destfile lschen, weils nicht fertig war !
					destFile.remove();
					destLV->readDir(destPath);
					accept();
					break;
				}
			}
			while(readed != 0);
			sourceFile.close();
			destFile.close();
			chmod(destPath + s,permissions);			
		}
ignore:
		kapp->processEvents();
	
	}

	destLV->readDir(destPath);
	accept();

}
//******************* recursives DIR ***************************************
void dlgCopy2::readDir(const char *path)
{
	QDir dir(sourcePath + path);
	if(!dir.exists())
	{
		QFile ff(sourcePath + path);
		fileList.append(QString(path));						// wenn bergebenes kein Dir ist, dann als File eintragen
		fileCounter ++;
		sizeCounter += ff.size();
		return;																		// und zurck !
	}
	else
		fileList.append(QString(path) + "/");			// ansonsten als Dir eintragen, immer "/" am Ende

	dir.setSorting(QDir::Name | QDir::DirsFirst | QDir::IgnoreCase);	// Dirs als erstes, ein MUSS !!
	dir.setFilter(QDir::Files | QDir::Dirs | QDir::Hidden);						// auch Hiddenfiles anzeigen

	if(!dir.isReadable())																							// falls nicht lesbar, trotzdem
	{																																	// im Destpath erstellen
		// ist fraglich ! als User testen !
		fileList.append(QString(path) + "/");
		return;
	}
  const QFileInfoList *files = dir.entryInfoList();
  if(files)	// gibt es files im Dir ??
  {
      QFileInfoListIterator it( *files );
      QFileInfo * f;
      while( (f=it.current()) != 0 )
      {
         ++it;
         if ( f->fileName() == "." || f->fileName() == ".." )
           {//do nothing !
           }
         else
         {
          if ( f->isDir())
          {
            readDir(QString(path) + "/" + f->fileName());
          }
         else
         {
         		fileList.append(QString(path) + "/" + f->fileName());
						sizeCounter += f->size();
         		fileCounter ++;
//						debug("size erhhen");
         }
      }
  }
}		
}


