/***************************************************************************
                          toolbars.cpp  -  all of the programs toolbars
                             -------------------                                         
    begin                : Thu Jun 10 1999                                           
    copyright            : (C) 1999 by Eric Banker                         
    email                : ebanker@gmu.edu                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qfiledlg.h>
#include <qfile.h>
#include <kapp.h>
#include <ktoolbar.h>
#include <kmenubar.h>
#include <kiconloader.h>
#include <qmsgbox.h>
#include <qstring.h>
#include "edit.h"

/* This is where the toolbar starts */

void Edit::initToolBar()
{
// prepare to get the icons.

  KIconLoader *loader = kapp->getIconLoader();

/* Start the main toolbar */

  toolbar = new KToolBar(this);

  toolbar->insertButton(loader->loadIcon("filenew.xpm"),
			ID_NEW, TRUE,
			klocale->translate("Create a new file"));

  toolbar->insertButton(loader->loadIcon("fileopen.xpm"),
			ID_OPEN, FALSE,
			klocale->translate("Open a file"));

  toolbar->insertButton(loader->loadIcon("filefloppy.xpm"),
			ID_SAVE, FALSE,
			klocale->translate("Save the current file"));

 	toolbar->insertButton(loader->loadIcon("fileprint.xpm"),
			ID_PRINT, FALSE,
			klocale->translate("Print The Current File"));

  toolbar->insertSeparator();

	toolbar->insertButton(loader->loadIcon("editcut.xpm"),
			ID_CUT, FALSE,
			klocale->translate("Cut Current Selection"));

	toolbar->insertButton(loader->loadIcon("editcopy.xpm"),
			ID_COPY, FALSE,
			klocale->translate("Copy Current Selection"));

	toolbar->insertButton(loader->loadIcon("editpaste.xpm"),
			ID_PASTE, FALSE,
			klocale->translate("Paste Selection"));

  toolbar->insertSeparator();

	toolbar->insertButton(loader->loadIcon("openbook.xpm"),
			ID_ABOUT, FALSE,
			klocale->translate("About KHtml"));

  addToolBar(toolbar);
  toolbar->setBarPos(KToolBar::Top);
  toolbar->show();
  connect(toolbar, SIGNAL(clicked(int)), SLOT(commandCallback(int)));

/* Start the Html Toolbar */

htmlbar = new KToolBar(this);

  htmlbar->insertButton(loader->loadIcon("kwebdev/html/body.xpm"),
			ID_HTMLBODY, TRUE,
			klocale->translate("Insert Page Body"));

  htmlbar->insertButton(loader->loadIcon("kwebdev/html/bold.xpm"),
			ID_HTMLBOLD, TRUE,
			klocale->translate("Insert Bold Tag"));

  htmlbar->insertButton(loader->loadIcon("kwebdev/html/italic.xpm"),
			ID_HTMLITALIC, TRUE,
			klocale->translate("Insert Italic Tag"));

  htmlbar->insertButton(loader->loadIcon("kwebdev/html/underline.xpm"),
			ID_HTMLULINE, TRUE,
			klocale->translate("Insert Underline Tag"));

	htmlbar->insertButton(loader->loadIcon("kwebdev/html/paragraph.xpm"),
			ID_HTMLPARA, TRUE,
			klocale->translate("Insert Paragraph"));

	htmlbar->insertButton(loader->loadIcon("kwebdev/html/br.xpm"),
			ID_HTMLBR, TRUE,
			klocale->translate("Insert Line Break"));

	htmlbar->insertButton(loader->loadIcon("kwebdev/html/nbs.xpm"),
			ID_HTMLNBS, TRUE,
			klocale->translate("Insert Non-Breaking Space"));

	htmlbar->insertButton(loader->loadIcon("kwebdev/html/hr.xpm"),
			ID_HTMLHR, TRUE,
			klocale->translate("Insert Horizontal Rule"));

	htmlbar->insertButton(loader->loadIcon("kwebdev/html/center.xpm"),
			ID_HTMLCENTER, TRUE,
			klocale->translate("Center Text"));

	htmlbar->insertButton(loader->loadIcon("kwebdev/html/rightalign.xpm"),
			ID_HTMLRIGHT, TRUE,
			klocale->translate("Align Text Right"));

	htmlbar->insertButton(loader->loadIcon("kwebdev/html/image.xpm"),
			ID_HTMLIMAGE, TRUE,
			klocale->translate("Insert Image"));

	htmlbar->insertButton(loader->loadIcon("kwebdev/html/link.xpm"),
			ID_HTMLLINK, TRUE,
			klocale->translate("Insert Link"));

  addToolBar(htmlbar);
  htmlbar->setBarPos(KToolBar::Top);
  htmlbar->show();
  connect(htmlbar, SIGNAL(clicked(int)), SLOT(commandCallback(int)));

// This is the Font Toolbar

fontbar = new KToolBar(this);

  fontbar->insertButton(loader->loadIcon("kwebdev/font/h1.xpm"),
			ID_FONTH1, TRUE,
			klocale->translate("Insert H1 Tag"));
	
	fontbar->insertButton(loader->loadIcon("kwebdev/font/h2.xpm"),
			ID_FONTH2, TRUE,
			klocale->translate("Insert H2 Tag"));
	
	fontbar->insertButton(loader->loadIcon("kwebdev/font/h3.xpm"),
			ID_FONTH3, TRUE,
			klocale->translate("Insert H3 Tag"));

	//fontbar->insertSeparator();

	fontbar->insertButton(loader->loadIcon("kwebdev/font/f+.xpm"),
			ID_FONTFP, TRUE,
			klocale->translate("Insert Font +1"));

	fontbar->insertButton(loader->loadIcon("kwebdev/font/f-.xpm"),
			ID_FONTFM, TRUE,
			klocale->translate("Insert Font -1"));

	//fontbar->insertSeparator();

	fontbar->insertButton(loader->loadIcon("kwebdev/font/super.xpm"),
			ID_FONTSUPER, TRUE,
			klocale->translate("Insert Super Script"));
	
	fontbar->insertButton(loader->loadIcon("kwebdev/font/sub.xpm"),
			ID_FONTSUB, TRUE,
			klocale->translate("Insert Sub Script"));

	fontbar->insertButton(loader->loadIcon("kwebdev/font/pre.xpm"),
			ID_FONTPRE, TRUE,
			klocale->translate("Insert Preformatted Text"));

	fontbar->insertButton(loader->loadIcon("kwebdev/font/strong.xpm"),
			ID_FONTSTRONG, TRUE,
			klocale->translate("Insert Strong Tag"));

  addToolBar(fontbar);
  fontbar->setBarPos(KToolBar::Left);
  fontbar->hide();
  connect(fontbar, SIGNAL(clicked(int)), SLOT(commandCallback(int)));

// This is the Special Toolbar, none of them do anything yet (gotta find codes)

specialbar = new KToolBar(this);

  specialbar->insertButton(loader->loadIcon("kwebdev/special/special1.xpm"),
			ID_Special1, TRUE,
			klocale->translate(""));
	
	specialbar->insertButton(loader->loadIcon("kwebdev/special/special2.xpm"),
			ID_Special2, TRUE,
			klocale->translate(""));
	
	specialbar->insertButton(loader->loadIcon("kwebdev/special/special3.xpm"),
			ID_Special3, TRUE,
			klocale->translate(""));

	specialbar->insertButton(loader->loadIcon("kwebdev/special/special4.xpm"),
			ID_Special4, TRUE,
			klocale->translate(""));

	specialbar->insertButton(loader->loadIcon("kwebdev/special/special5.xpm"),
			ID_Special5, TRUE,
			klocale->translate(""));

	specialbar->insertButton(loader->loadIcon("kwebdev/special/special6.xpm"),
			ID_Special6, TRUE,
			klocale->translate(""));
	
	specialbar->insertButton(loader->loadIcon("kwebdev/special/special7.xpm"),
			ID_Special7, TRUE,
			klocale->translate(""));

	specialbar->insertButton(loader->loadIcon("kwebdev/special/special8.xpm"),
			ID_Special8, TRUE,
			klocale->translate(""));

	specialbar->insertButton(loader->loadIcon("kwebdev/special/special9.xpm"),
			ID_Special9, TRUE,
			klocale->translate(""));

	specialbar->insertButton(loader->loadIcon("kwebdev/special/special10.xpm"),
			ID_Special10, TRUE,
			klocale->translate(""));

	specialbar->insertButton(loader->loadIcon("kwebdev/special/special11.xpm"),
			ID_Special11, TRUE,
			klocale->translate(""));

	specialbar->insertButton(loader->loadIcon("kwebdev/special/special12.xpm"),
			ID_Special12, TRUE,
			klocale->translate(""));

	connect(specialbar, SIGNAL(clicked(int)), this, SLOT(commandCallback(int)));
  addToolBar(specialbar);
  specialbar->setBarPos(KToolBar::Bottom);
  specialbar->hide();

// This is the toolbar for links and tables

ltbar = new KToolBar(this);

  ltbar->insertButton(loader->loadIcon("kwebdev/table/table.xpm"),
			ID_TABLE, TRUE,
			klocale->translate("Table Tag"));

	ltbar->insertButton(loader->loadIcon("kwebdev/table/tr.xpm"),
			ID_TABLE_TR, TRUE,
			klocale->translate("TR Tag"));
	
	ltbar->insertButton(loader->loadIcon("kwebdev/table/td.xpm"),
			ID_TABLE_TD, TRUE,
			klocale->translate("TD Tag"));

	ltbar->insertSeparator();

	ltbar->insertButton(loader->loadIcon("kwebdev/list/ol.xpm"),
			ID_LIST_OL, TRUE,
			klocale->translate("Organized List"));

	ltbar->insertButton(loader->loadIcon("kwebdev/list/ul.xpm"),
			ID_LIST_UL, TRUE,
			klocale->translate("UnOrganized List"));

	ltbar->insertButton(loader->loadIcon("kwebdev/list/li.xpm"),
			ID_LIST_LI, TRUE,
			klocale->translate("List Item"));
	
	connect(ltbar, SIGNAL(clicked(int)), this, SLOT(commandCallback(int)));
  addToolBar(ltbar);
  ltbar->setBarPos(KToolBar::Right);
  ltbar->hide();

// This is the toolbar for Inserting Forms

formbar = new KToolBar(this);

  formbar->insertButton(loader->loadIcon("kwebdev/form/form.xpm"),
			ID_FORM, TRUE,
			klocale->translate("Insert Form"));

	formbar->insertSeparator();

  formbar->insertButton(loader->loadIcon("kwebdev/form/textbox.xpm"),
			ID_FORM_TEXTBOX, TRUE,
			klocale->translate("Insert TextBox"));

	formbar->insertButton(loader->loadIcon("kwebdev/form/textarea.xpm"),
			ID_FORM_TEXTAREA, TRUE,
			klocale->translate("Insert Comments Box"));

	formbar->insertButton(loader->loadIcon("kwebdev/form/listbox.xpm"),
			ID_FORM_LIST, TRUE,
			klocale->translate("Insert Listbox"));

	formbar->insertSeparator();

	formbar->insertButton(loader->loadIcon("kwebdev/form/check.xpm"),
			ID_FORM_CHECK, TRUE,
			klocale->translate("Insert Check Box"));

	formbar->insertButton(loader->loadIcon("kwebdev/form/radio.xpm"),
			ID_FORM_RADIO, TRUE,
			klocale->translate("Insert Radio Button"));

	formbar->insertSeparator();

	formbar->insertButton(loader->loadIcon("kwebdev/form/reset.xpm"),
			ID_FORM_RESET, TRUE,
			klocale->translate("Insert Reset Button"));

	formbar->insertButton(loader->loadIcon("kwebdev/form/submit.xpm"),
			ID_FORM_SUBMIT, TRUE,
			klocale->translate("Insert Submit Button"));
	
	connect(formbar, SIGNAL(clicked(int)), this, SLOT(commandCallback(int)));
  addToolBar(formbar);
  formbar->setBarPos(KToolBar::Top);
  formbar->hide();

// These tell the program if the toolbars are hidden or not.

	hideToolBar = FALSE;
	hideFontBar = TRUE;
	hideFormBar = TRUE;
	hideLTBar = TRUE;
	hideSpecialBar = TRUE;
	hideHtmlToolBar = FALSE;
	hideStatusbar = FALSE;
}