/***************************************************************************
                          edit.h  -  	Here is my header file
                             -------------------
    begin                : Thu Jun 10 1999
    copyright            : (C) 1999 by Eric Banker
    email                : ebanker@gmu.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// -*- c++ -*-

#ifndef EDIT_H
#define EDIT_H

#include <ktopwidget.h>
#include <qmlined.h>

// Define File Menu command codes
#define ID_OPEN 100
#define ID_NEW 101
#define ID_SAVE 102
#define ID_SAVEAS 103
#define ID_NEWWINDOW 104
#define ID_CLOSEWINDOW 105
#define ID_OPTIONS 110
#define ID_EXIT 111
#define ID_PRINT 118
#define ID_NEW_WINDOW 109

// Define Help Contents
#define ID_HELPCONTENTS 112
#define ID_ABOUT 113
#define ID_ABOUTKDE 114

// Define Edit contents
#define ID_CUT 115
#define ID_COPY 116
#define ID_PASTE 117

// Define Font Stuff
#define ID_FONTH1 160
#define ID_FONTH2 161
#define ID_FONTH3 162
#define ID_FONTFP 163
#define ID_FONTFM 164
#define ID_FONTSTRONG 165
#define ID_FONTPRE 166
#define ID_FONTSUB 167
#define ID_FONTSUPER 168

// Define Special Stuff
#define ID_Special1 170
#define ID_Special2 171
#define ID_Special3 172
#define ID_Special4 173
#define ID_Special5 174
#define ID_Special6 175
#define ID_Special7 176
#define ID_Special8 177
#define ID_Special9 178
#define ID_Special10 179
#define ID_Special11 180
#define ID_Special12 181

// Define HTML Stuff
#define ID_HTMLBODY 148
#define ID_HTMLBOLD 149
#define ID_HTMLITALIC 150
#define ID_HTMLULINE 151
#define ID_HTMLPARA 152
#define ID_HTMLBR 153
#define ID_HTMLNBS 154
#define ID_HTMLHR 155
#define ID_HTMLCENTER 156
#define ID_HTMLRIGHT 157
#define ID_HTMLIMAGE 158
#define ID_HTMLLINK 159

// Define Table Toolbar Stuff
#define ID_TABLE 182
#define ID_TABLE_TR 183
#define ID_TABLE_TD 184

// Define List Toolbar Stuff

#define ID_LIST_OL 185
#define ID_LIST_UL 186
#define ID_LIST_LI 187

// Define Form Toolbar Stuff

#define ID_FORM 188
#define ID_FORM_TEXTBOX 189
#define ID_FORM_TEXTAREA	190
#define ID_FORM_LIST	191
#define ID_FORM_CHECK 192
#define ID_FORM_RADIO 193
#define ID_FORM_RESET	106
#define ID_FORM_SUBMIT	107

// For the Status Bar
#define ID_LINECOL 158

/* Temporary until menus are finished */
#define ID_NOIMP 119
#define ID_NOIMP2 120
#define ID_NOIMP3 121
#define ID_NOIMP4 122
#define ID_NOIMP5 123
#define ID_NOIMP6 124
#define ID_NOIMP7 125
#define ID_NOIMP8 126
#define ID_NOIMP9 127
#define ID_NOIMP10 128
#define ID_NOIMP27 129
#define ID_NOIMP28 130
#define ID_NOIMP29 131

// Define status item codes
#define ID_HINTTEXT 300

class Edit : public KTopLevelWidget
{
  Q_OBJECT

public:
  Edit();

  ~Edit();

 public slots:
	// Global used functions
  void commandCallback(int id_);
  void setHint(const char *text);
  void disableCommand(int id);
  void enableCommand(int id);
  void textChanged();

	// File menu Stuff
	void load(const char *filename);
  void saveAs(const char *filename);
  void help();
  void Print();
  void execNetscape();
	void closefile();
	
  // Edit menu stuff
	void cut();
	void copy();
	void paste();
	void select_all();
	
	// Toggles these things
	void toggleMainToolbar();
	void toggleHtmlToolbar();
	void toggleFontToolbar();
	void toggleLTToolbar();
	void toggleFormToolbar();
	void toggleSpecialToolbar();
	void toggleStatusbar();

	// HTML Insert Tools
  void InsertBody();

  void InsertH1();
  void InsertH2();
  void InsertH3();
  void InsertH4();
  void InsertH5();
  void InsertH6();
		
	void InsertBold();
	void InsertItalic();
	void InsertUline();

	void InsertCenter();
	void InsertRight();
	void InsertHRrule();

	void InsertParagraph();
	void InsertBR();
	void InsertNbs();

	void InsertLink();
	void InsertImage();

	void Insertfontp();
	void InsertfontH();
	void InsertfontF();
	void Insertfontm();
	void InsertfontSuper();
	void InsertfontSub();
	void InsertfontPre();
	void InsertfontStrong();

	void InsertFormH();
	void InsertTextB();
	void InsertTextF();
	void InsertRadio();
	void InsertCheck();
	void InsertListB();
	void InsertFormF();
	void InsertReset();
	void InsertSubmit();


	void InsertOLScript();
	void InsertULScript();
	void InsertOL();
	void InsertUL();
	void InsertLI();

	void InsertFrameH();
	void InsertFrameTag();
	void InsertNoFrames();
	void InsertFrameFooter();
	
	void InsertTableHeader();
	void InsertTableTR();
	void InsertTableTD();
	void InsertTableFooter();

  void Special1();
  void Special2();
  void Special3();
  void Special4();
  void Special5();
  void Special6();
  void Special7();
  void Special8();
  void Special9();
  void Special10();
  void Special11();
  void Special12();

// These are the about functions
	void aboutkde();
	void aboutkwebdev();

private:
  // Child widgets
  KMenuBar *menu;
  KToolBar *toolbar, *htmlbar, *fontbar, *specialbar, *ltbar, *formbar;
  KStatusBar *statusbar; 
  QMultiLineEdit *view;
  QString filename_;

	// Some more functions
	void initMenuBar();
  void initToolBar();
  void initStatusBar();
  void closeEvent(QCloseEvent *e);

	// some variables
  int exit();
	int maintool, htmltool;

	// and some true/false stuff
	bool hideToolBar;
	bool hideLTBar;
	bool hideHtmlToolBar;
	bool hideFontBar;
	bool hideFormBar;
	bool hideSpecialBar;
	bool hideStatusbar;
  bool modified;
};

#endif // EDIT_H
