/***************************************************************************
                     knserveroptions.h - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNSERVEROPTIONS_H
#define KNSERVEROPTIONS_H

#include <knoptionswidget.h>
#include <qlineedit.h>
#include <krestrictedline.h>
#include <qgroupbox.h>
#include <qcheckbox.h>

//#define WITHLOGON

class KNServerOptions : public KNOptionsWidget  {

	public:
		KNServerOptions(QWidget *parent=0, const char *name=0);
		~KNServerOptions();
		
		void applyConfig();
		void readConfig();
				
#ifdef WITHLOGON	
	protected:
			
		QGroupBox *gNntp, *gSmtp, *gIden;
		QLineEdit *nntp, *smtp, *from, *email, *replyTo, *orga;
		KRestrictedLine *nPort, *sPort, *tOut;
		QLineEdit *user, *pass;
		QCheckBox *needsLog;

#else

	protected:
		
		QGroupBox *gServer, *gIden;
		QLineEdit *nntp, *smtp, *from, *email, *replyTo, *orga;
		KRestrictedLine *nPort, *sPort, *tOut;
#endif
		
};

#endif






