/***************************************************************************
                     knsenderdialog.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knsenderdialog.h"
#include <qlayout.h>
#include <kapp.h>

KNSenderDialog::KNSenderDialog(QWidget *parent, const char *name ) :
	QDialog(parent,name,true)
{
	listbox=new KNListBox(this);
	
	label=new QLabel(" ", this);
	label->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	label->setMinimumSize(label->sizeHint());
	label->setAlignment(AlignCenter);
	
	closeBtn=new QPushButton(i18n("Close"),this);
	closeBtn->setMinimumSize(closeBtn->sizeHint());
	
	QVBoxLayout *topLayout=new QVBoxLayout(this, 10);
	QHBoxLayout *btnLayout=new QHBoxLayout(10);
	
	topLayout->addWidget(listbox, 1);
	topLayout->addWidget(label);
	topLayout->addLayout(btnLayout);
	
	btnLayout->addStretch(1);
	btnLayout->addWidget(closeBtn);
	
	topLayout->activate();
	
	connect(closeBtn, SIGNAL(clicked()), this, SLOT(accept()));
	
	setCaption(i18n("sending errors"));
}



KNSenderDialog::~KNSenderDialog()
{
}



