/***************************************************************************
                     knsender.h - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNSENDER_H
#define KNSENDER_H


#include "knpostheader.h"
#include "knntpclient.h"
#include "knsmtpclient.h"
#include "knlboxitem.h"
#include "knsenderdialog.h"
#include "knpostingmanager.h"

#include <qobject.h>


class KNSender : public QObject  {

	Q_OBJECT
	
	public:
		
		enum sendStatus { waiting, sent, error };
		enum Encoding { sBit=0, eBit=1, quotedPr=2, unknown=3 };
		
		KNSender(QObject *parent=0, const char *name=0);
		~KNSender();
  	
	  void addToQueue(KNPostHeader *hdr);
	  bool initSender();
	  bool sendQueue();
	  void cleanupSender();
	  int showDlg();
	
	
	protected slots:
		void slotDlgHighlighted(int idx);
		
		  	
	private:
		void createDataString(KNSendMessage *msg);
		
		
		class QueueItem;					
		QList<QueueItem> queue;
		
		NNTP *nntp;
		SMTP *smtp;
		
		DwString DataString;
		Encoding encoding;
		
		KNSenderDialog *dlg;
		
	
	
	
	//=================================================
		
		class QueueItem {
			
			public:
				QueueItem(KNPostHeader *h);
				~QueueItem();
				
				void setListItem(KNLBoxItem *it) { item=it; it->setData(this); }
			
				KNPostHeader *hdr;
				QString error;
				sendStatus stat;
				KNLBoxItem *item;
		};
	//================================================	
	
	
	
	
	
	
	
	signals:
		void msgSent(KNPostHeader *, bool);	
	
};

#endif
























