/***************************************************************************
                     knsender.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knsender.h"
#include "knglobals.h"
#include "utilities.h"


KNSender::KNSender(QObject *parent=0, const char *name=0) :
	QObject(parent,name)
{
	smtp=0;
	nntp=0;
	queue.setAutoDelete(true);
	dlg=0;
	
	CONF()->setGroup("POSTNEWS");
	encoding=(Encoding) CONF()->readNumEntry("Encoding",1);
	
}



KNSender::~KNSender()
{
}



void KNSender:: addToQueue(KNPostHeader *hdr)
{
	QueueItem *it=new QueueItem(hdr);
	
	if(hdr->sMode==KNPostHeader::Post) queue.insert(0,it);
	else queue.append(it);
	
}	



bool KNSender::initSender()
{
	if(queue.first()->hdr->sMode==KNPostHeader::Post) {
		nntp=xTop->nntpClient();
		if(!nntp->cmdConnect()) return false;
	}
	
	if(queue.last()->hdr->sMode==KNPostHeader::Mail) {
		smtp=new SMTP();
		if(!smtp->cmdConnect()) {
			MBox(err, smtp->serverResponse(), "SMTP-Error");
			return false;
		}
	}
	return true;
}



bool KNSender::sendQueue()
{
	
	KNPostHeader *hdr;
	bool ret=true;
	unsigned int cnt=0;
	xTop->setStatusMsg(i18n("sending ..."));
	xTop->setProgrBarSteps(queue.count());
		
	for(QueueItem *var=queue.first(); var; var=queue.next())  {
		
		hdr=var->hdr;
						
		if(hdr->sMode==KNPostHeader::Post) {
				
			hdr->createMsgHead(encoding);
		  createDataString(hdr->message);	
			
			if(!nntp->sendMsg(DataString)) {
				var->error=nntp->serverResponse();
				var->stat=error;
				ret=false;
			}
			
			else var->stat=sent;
			
			emit msgSent(hdr, (var->stat!=error));
			
		}
		else break;
		xTop->setProgress(++cnt);
	}
	
	
	if(cnt<queue.count()) {
		
		for(QueueItem *var=queue.at(cnt); var; var=queue.next()) {
			
			hdr=var->hdr;
			
			if(hdr->sMode==KNPostHeader::Mail) {
							
				hdr->createMsgHead(encoding);
				createDataString(hdr->message);
					
				if(!smtp->sendMsg(hdr->email, hdr->mailTo, DataString)) {
					var->error=smtp->serverResponse();
					var->stat=error;
		  		ret=false;
				}
				else var->stat=sent;
		  	
				xTop->setProgress(++cnt);
				emit msgSent(hdr, (var->stat!=error));
			}
		}
	}

	xTop->setStatusMsg();
	return ret;
}			
		



void KNSender::cleanupSender()
{
	if(smtp) {
		smtp->cmdDisconnect();
		delete smtp;
		smtp=0;
	}
	nntp=0;
	delete dlg;
	dlg=0;
}



void KNSender::createDataString(KNSendMessage *msg)
{
	DataString="";

	for(char *var=msg->header()->first(); var; var=msg->header()->next()) {
		DataString+=var;		
		DataString+="\r\n";
	}
		
	for(char *var=msg->body()->first(); var; var=msg->body()->next()) {
		DataString+="\r\n";
		if(encoding==quotedPr)
			DataString+=encodeQuotedPrintable(QString(var)).data();
		else DataString+=var;
	}
}



int KNSender::showDlg()
{
	dlg=new KNSenderDialog();
	
	connect(dlg->list(), SIGNAL(highlighted(int)),
		this, SLOT(slotDlgHighlighted(int)));
	
	for(QueueItem *var=queue.first(); var; var=queue.next())
		if(var->stat==error){
			QPixmap pm=ICON("snderr.xpm");
			var->setListItem(new KNLBoxItem(var->hdr->subject,0,&pm));
			dlg->addListItem(var->item);
		}
	
	dlg->list()->setSelected(0,true);
	return dlg->exec();	

}



void KNSender::slotDlgHighlighted(int idx)
{
	QueueItem *qitem=(QueueItem*) dlg->list()->itemAt(idx)->data();
	dlg->showErrorString(qitem->error);
}






//======================================================================
//======================================================================

KNSender::QueueItem::QueueItem(KNPostHeader *h)
{
	hdr=h;
	item=0;
	stat=waiting;
}



KNSender::QueueItem::~QueueItem()
{
}




























































