/***************************************************************************
                     knreadheader.h - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNREADHEADER_H
#define KNREADHEADER_H

#include <qbitarray.h>
#include "knheaderbase.h"
#include "knreadmessage.h"



class KNReadHeader : public KNHeaderBase  {
	
	public:
								
		KNReadHeader();
		virtual ~KNReadHeader();
	
		void clearData();
				
		HType Type() 								{ return readHdr; }
		bool hasReferences() 				{ return !references[0].isEmpty(); }
		bool hasGroups() 						{ return false; }
		
		QStrList* msgBody()					{ return message->body(); }
		QStrList* msgHead()					{ return message->header(); }
		KNReadMessage* Message()		{ return message; }
		
		void setFromLine(const QString &fString);
		void setReplyToLine(const char* fString);
		void saneName();
		void initItem();
		void updateItem();
				
		bool isRead()									{ return flags.at(0); }
		bool isExpired()          		{ return flags.at(1); }
		bool isNew()									{ return flags.at(2); }
		bool filterResult()						{ return flags.at(3); }
		bool filtered()								{ return flags.at(4); }
		bool hasNewSubs()							{ return flags.at(5); }
		bool hasUnreadSubs()					{ return (unrSubCnt > 0); }
		bool hasChanged()							{ return flags.at(6); }
		
		
		void setRead(bool b)					{ flags.setBit(0,b); }
		void setExpired(bool b)     	{ flags.setBit(1,b); }
		void setNew(bool b)						{ flags.setBit(2,b); }
		void setFilterResult(bool b)	{ flags.setBit(3,b); }
		void setFiltered(bool b)			{ flags.setBit(4,b); }
	  void setNewSubs(bool b)				{ flags.setBit(5,b); }
	  void setHasChanged(bool b)		{ flags.setBit(6,b); }
	
	
		QString mID;
		QString references[5];
		int idRef, artNr;	
		short thrLevel, score, unrSubCnt, age;
		QBitArray flags;
			
		KNReadMessage *message;
		
		protected:
			
			class FromLineParser {
				
				public:
					FromLineParser();
					~FromLineParser();
					
					void doParse(const QString &fLine);
					void doParse(const char *fLine);
					QString& from()		{ return f_rom; }
					QString& email()		{ return e_mail; }
				
				protected:
					QString f_rom, e_mail;
					
			};
					
						
					
		
};

#endif
























