/***************************************************************************
                     knpostoptions.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knpostoptions.h"
#include "knglobals.h"
#include <qlabel.h>
#include <qlayout.h>


KNPostOptions::KNPostOptions(QWidget *parent, const char *name ) :
	KNOptionsWidget(parent,name)
{
	gGeneral=new QGroupBox(i18n("General"), this);
	
	enc=new QComboBox(gGeneral);
	enc->insertItem("7 bit");
	enc->insertItem("8 bit");
	enc->insertItem("quoted-printable");
	maxLen=new KRestrictedLine(gGeneral); maxLen->setValidChars("0123456789");
	appSig=new QCheckBox(i18n("append own signature automatically"), gGeneral);
	
	SIZE(enc); WIDTH(maxLen,50); SIZE(appSig);
	
	
	QLabel *l1=new QLabel(i18n("encoding:"), gGeneral);
	QLabel *l2=new QLabel(i18n("max length of lines:"), gGeneral);
	
	SIZE(l1); SIZE(l2);
	
	
	gReply=new QGroupBox(i18n("Reply"), this);
	
	intro=new QLineEdit(gReply);
	quot=new QLineEdit(gReply);
	incSig=new QCheckBox(i18n("include the authors signature"), gReply);
	
	WIDTH(quot, 50); SIZE(incSig); SIZE(intro);
	
	
	QLabel *l3=new QLabel(i18n("Introduction: (%NAME=name,%DATE=date,%MSID=msgid)"), gReply);
	QLabel *l4=new QLabel(i18n("begin quoted lines with:"), gReply);
	
	SIZE(l3); SIZE(l4);
	
	
	QVBoxLayout *topL=new QVBoxLayout(this, 10);
	QGridLayout *genL=new QGridLayout(gGeneral, 3,2, 20,10);
	QGridLayout *repL=new QGridLayout(gReply, 5,2, 20,10);
	
	topL->addWidget(gGeneral);
	topL->addWidget(gReply);
	
	genL->addWidget(l1, 0,0);
	genL->addWidget(enc, 0,1);
	
	genL->addWidget(l2, 1,0);
	genL->addWidget(maxLen, 1,1);
	
	genL->addWidget(appSig, 2,0);
	
	genL->setRowStretch(2,1);
	genL->setColStretch(0,10);
	genL->setColStretch(1,2);
	
	
	repL->addWidget(l3, 0,0);
	repL->addMultiCellWidget(intro, 1,1, 0,1);
	repL->addWidget(l4, 2,0);
	repL->addWidget(quot, 2,1);
	repL->addMultiCellWidget(incSig, 4,4, 0,1);
	
	//repL->addRowSpacing(1,50);
	//repL->setRowStretch(1,4);
	repL->setRowStretch(3,1);
	repL->setColStretch(0,10);
	repL->setColStretch(1,1);
		
	topL->activate();
	
	readConfig();	
}



KNPostOptions::~KNPostOptions()
{
}



void KNPostOptions::applyConfig()
{
	KConfig *conf=CONF();
	
	conf->setGroup("POSTNEWS");
		
	conf->writeEntry("Encoding",enc->currentItem());
	conf->writeEntry("maxLength", atoi(maxLen->text()));
	conf->writeEntry("appSig", appSig->isChecked());
	
	if(strlen(intro->text())>0)
		conf->writeEntry("Intro", intro->text());
	
	if(strlen(quot->text())>0)
		conf->writeEntry("QuotSign",quot->text());
	
	conf->writeEntry("incSig", incSig->isChecked());

}



void KNPostOptions::readConfig()
{
	KConfig *conf=CONF();
	
	char tmp[10];
  conf->setGroup("POSTNEWS");

  enc->setCurrentItem(conf->readNumEntry("Encoding",1));

  sprintf(tmp,"%d", conf->readNumEntry("maxLength", 78) );
  maxLen->setText(tmp);

  appSig->setChecked(conf->readBoolEntry("appSig",true));

  intro->setText(conf->readEntry("Intro","%NAME wrote:"));
  quot->setText(conf->readEntry("QuotSign",">"));
  incSig->setChecked(conf->readBoolEntry("incSig",true));

}











