/***************************************************************************
                     knpostingmanager.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knpostingmanager.h"
#include "kngroupentry.h"
#include "resource.h"
#include "utilities.h"
#include "knhdrviewitem.h"
#include "knentryviewitem.h"
#include "knreadheader.h"
#include "knglobals.h"
//#include "knbuffstring.h"
#include "knsender.h"
#include <stdio.h>
#include <stdlib.h>
#include <qheader.h>
#include <mimelib/datetime.h>
#include <kcharsets.h>



KNPostingManager::KNPostingManager(QListView *v, KNFolderManager *fm=0)
{
	readConfig();
	view=v;
	c_urrent=0;
	fManager=fm;
	
	compList=new QList<KNMessageComp>;
	compList->setAutoDelete(true);
}	



KNPostingManager::~KNPostingManager()
{
	delete compList;
}



void KNPostingManager::readConfig()
{
	KConfig *conf=CONF();
	
	QString tmp;
	
	conf->setGroup("IDENTITY");
	
	tmp=conf->readEntry("Name");	
	if(!tmp.isEmpty()) ownName=tmp;
	
	tmp=conf->readEntry("Email");
	if(!tmp.isEmpty()) ownEmail=tmp;
	
	tmp=conf->readEntry("Reply-to");
	if(!tmp.isEmpty()) replyTo=tmp;
	
	tmp=conf->readEntry("Org");
	if(!tmp.isEmpty()) orga=tmp;
	
	
	conf->setGroup("POSTNEWS");
	incSig=conf->readBoolEntry("incSig",true);
	quotSign=conf->readEntry("QuotSign",">");
	intro=conf->readEntry("Intro", "%NAME wrote:");
				
}



bool KNPostingManager::showHdrs()
{
	
	static QPixmap ma=ICON("mail.xpm"), po=ICON("posting.xpm");
	KNPostHeader *hdr;
	
	view->clear();
	
	for(hdr=fManager->initIterator(); hdr; hdr=fManager->nextInFolder()) {
		if(!hdr->hasData()) if(!loadOView(hdr)) return false;
		hdr->setItem(new KNHdrViewItem(view));
		hdr->initItem();
		if(hdr->sMode==KNPostHeader::Mail)hdr->item->setPixmap(0, ma);
		else hdr->item->setPixmap(0, po);
	}
		
	return true;
}



bool KNPostingManager::setCurrent(KNHeaderBase *hdr)
{
	c_urrent=(KNPostHeader*)hdr;
		
	if(!c_urrent->message) {
		
		debug("Posting is not cached. Loading it from file ...   ");
		if(loadBody(c_urrent)) debug("Done\n");
		else c_urrent=0;
	}
	else debug("Posting is cached.\n");
	
	return (c_urrent!=0);
}




bool KNPostingManager::loadOView(KNPostHeader *hdr)
{
	
	QString buff;
	buff.sprintf("%s/Folders/%d", knDir().data(), hdr->id);
	
	QFile f;
	QTextStream s;
	
	f.setName(buff);
		
	
	if(f.open(IO_ReadOnly)) {
	
		s.setDevice(&f);
		
		hdr->from=ownName;
		hdr->email=ownEmail;
	  	
		// subject
		hdr->subject=s.readLine();
	
	  //groups
		hdr->groups=s.readLine();		
	
		//fupTo
		buff=s.readLine();
		if(!buff.isEmpty()) hdr->fupTo=buff;
	  			
		//mailTo
		hdr->mailTo=s.readLine();
		
		//references
		buff=s.readLine();
		if(!buff.isEmpty()) hdr->refLine=buff;
		
		//lines, time, sMode
		buff=s.readLine();
		sscanf(buff,"%d %d %d", &hdr->lines, (uint*) &hdr->time, (int*) &hdr->sMode);
		
		//here begins the body		
		hdr->bodyOffset=f.at();		
	
		f.close();	
		return true;
	}
	
	else {MBox(ferr); return false;}
	
}



bool KNPostingManager::loadBody(KNPostHeader *hdr)
{
	QString buff;
	QFile f;
	QTextStream s;
	
		
	buff.sprintf("%s/Folders/%d", knDir().data(), hdr->id);
	
	f.setName(buff);
	
	if(f.open(IO_ReadOnly)) {
		
	
		//set file pointer
		if(!f.at(hdr->bodyOffset)) {MBox(ferr); return false;}
	
		s.setDevice(&f);
				
		hdr->message=new KNSendMessage;
			
		while(!s.eof())
			hdr->message->body()->append(s.readLine());
		
		f.close();
		return true;
	}
	
	else { MBox(ferr); return false; }	
}



KNPostHeader* KNPostingManager::newHdr()
{
	KNPostHeader *ret=new KNPostHeader();
	
	ret->from=ownName;
	ret->email=ownEmail;
	if(!orga.isEmpty()) ret->orga=orga;
	if(!replyTo.isEmpty()) ret->replyTo=replyTo;
	
	return ret;
}
	


void KNPostingManager::newMsg()
{
	if(!ownName.isNull() && !ownEmail.isNull()) {
		
	
		KNPostHeader *hdr=newHdr();
	  KNGroupEntry *currGroup=xTop->gManager()->current();
					
		if(currGroup)	hdr->groups=currGroup->name();
		hdr->message=new KNSendMessage;
	
		openInComposer(hdr);
		
	}
	else MBox(err,i18n("Please set your name\nand your email first."));	
	
}



void KNPostingManager::replyMsg(KNPostHeader::SendMode sMode)
{
	KNReadHeader *ref=xTop->artManager()->currentHdr();	
  KNPostHeader *hdr;
  char *fup, *replyTo, *references;

	if(!ref) return;	

	if(!ownName.isEmpty() && !ownEmail.isEmpty()) {
	
		hdr=newHdr();
	  hdr->sMode=sMode;
	  		
		//groups, fup2, mailto
		fup=ref->message->getHeaderLine("Followup-To");
		if(fup) {
			if(strcasecmp(fup, "poster")==0) hdr->sMode=KNPostHeader::Mail;
			else hdr->groups=fup;
		}
		else hdr->groups=ref->message->getHeaderLine("Newsgroups");
		
		
		//mailto
		if(hdr->sMode==KNPostHeader::Mail) {
			replyTo=ref->message->getHeaderLine("reply-to");
			if(replyTo) hdr->mailTo=replyTo;
			else hdr->mailTo=ref->email.copy();
		}	
			
			
		//references
		references=ref->message->getHeaderLine("References");
		if(references) {
			hdr->refLine=references;
			hdr->refLine+=" ";
			hdr->refLine+=ref->mID;
		}
		else  hdr->refLine=ref->mID;
	
		
		//Subject
		if(strncasecmp(ref->subject.data(),"re:",3)==0)
			hdr->subject=ref->subject.copy();
		else {
			hdr->subject="Re: ";
			hdr->subject+=ref->subject;
		}
	  	
		
		//open in Composer
	  		
		QString introStr, tmp;
		int start=0, found=0;
	
		while(found!=-1) {
	
			found=intro.find('%',start);
		
			if(found>-1) {
		
		  	introStr+=intro.mid(start,found-start);
				tmp=intro.mid(found+1,4);	
		
				if(tmp=="NAME")	{ introStr+=ref->from; start=found+5; }
				
				else if(tmp=="DATE") { introStr+=ref->message->getHeaderLine("Date"); start=found+5; }
					
				else if(tmp=="MSID") { introStr+=ref->mID; ; start=found+5; }
			
				else  { introStr+='%';  start=found+1; }
							
			}
		
			else introStr+=intro.mid(start, intro.length());
		}
	
		
		hdr->message=new KNSendMessage(ref->message->body(), quotSign,
		introStr, incSig);
		
		openInComposer(hdr);	
		
	}
	
	else MBox(err,i18n("Please set your name\nand your email first."));	
		
}



void KNPostingManager::slotMailTo(const char* email)
{
	if(!ownName.isNull() && !ownEmail.isNull()) {
		
		KNPostHeader *hdr=newHdr();
	  hdr->sMode=KNPostHeader::Mail;
		hdr->mailTo=email;			
		hdr->message=new KNSendMessage;
	
		openInComposer(hdr);
		
	}
	else MBox(err,i18n("Please set your name\nand your email first."));	
}



void KNPostingManager::editCurrent()
{
	if(c_urrent)
		if(c_urrent->message!=0)
			openInComposer(c_urrent);			
}



void KNPostingManager::openInComposer(KNPostHeader *h)
{
	KNMessageComp *composer=new KNMessageComp(h);
	composer->show();
	compList->append(composer);
	connect(composer, SIGNAL(composerDone(KNMessageComp*)),
		this, SLOT(slotComposerDone(KNMessageComp*)));
}



void KNPostingManager::deleteMsg(KNPostHeader *hdr=0)
{
	if(!hdr) hdr=c_urrent;
	
	//if(hdr)
		//if (hdr->folderID==fManager->trash()->id()) {
		if(hdr) {	
			fManager->movePosting(hdr, 0);		
			hdr->clearData();
	 		delete hdr->message;
	 		hdr->message=0;
	 		delete hdr->item;
	 		hdr->item=0;
	 		
	 		if(hdr->bodyOffset>0) {
	 			QString cmd;
	 			cmd.sprintf("rm %sFolders/%d", knDir().data(), hdr->id);
	 			system(cmd);
				debug("file deleted");
			}
	 	
			hdr->id=-1;
			hdr->folderID=-1;
			if(c_urrent==hdr) c_urrent=0;
		}	
						
		/*}
		
		else fManager->movePosting(hdr, fManager->trash()); */
	
} 			



void KNPostingManager::removeMsg(KNPostHeader *hdr=0)
{
	deleteMsg(hdr);
	fManager->rewriteIndex();	
}



void KNPostingManager::sendMsg(KNPostHeader *hdr=0, bool now=true)
{
	if(!hdr)
		if(c_urrent) hdr=c_urrent;
		else return;
	
	if(!now) {
		fManager->movePosting(hdr, fManager->outbox());
		return;
	}		
			
	KNSender *sender=new KNSender();
	connect(sender, SIGNAL(msgSent(KNPostHeader*, bool)), this,
		SLOT(slotMsgSent(KNPostHeader*, bool)));
					
	sender->addToQueue(hdr);
		
	if(!sender->initSender()) {
		if(hdr->folderID==-1) fManager->movePosting(hdr, fManager->outbox());
	}
	else if(!sender->sendQueue()) sender->showDlg();
	
	sender->cleanupSender();
	delete sender;
	
}



void KNPostingManager::sendAllInOutbox()
{
	KNPostHeader *hdr=fManager->initIterator(fManager->outbox());
	
	if(hdr) {
		
		KNSender *sender=new KNSender();
		connect(sender, SIGNAL(msgSent(KNPostHeader*, bool)), this,
			SLOT(slotMsgSent(KNPostHeader*, bool)));	
	
		for(KNPostHeader *var=hdr; var; var=fManager->nextInFolder())
			sender->addToQueue(var);	
		
		if(sender->initSender())
			if(!sender->sendQueue()) sender->showDlg();		
	
		sender->cleanupSender();
		delete sender;
	}
	else debug("Outbox is empty!");

}



void KNPostingManager::slotMsgSent(KNPostHeader *hdr, bool success)
{
	if(success) fManager->movePosting(hdr, fManager->sent());
	else if(hdr->folderID==-1) fManager->movePosting(hdr, fManager->outbox());
}



void KNPostingManager::saveToFile(KNPostHeader *hdr)
{
	QFile f;
	QTextStream s;
	QString fName;
	
	fName.sprintf("%sFolders/%d", knDir().data(), hdr->id);
	
	f.setName(fName);
	
	if(f.open(IO_WriteOnly)) { 	
	
		s.setDevice(&f);
		
		s 	<< hdr->subject << "\n" <<  hdr->groups << "\n" << hdr->fupTo << "\n"
				<< hdr->mailTo  << "\n" <<  hdr->refLine << "\n"
				<< hdr->lines <<" " << hdr->time << " " << (int) hdr->sMode <<"\n";
		

		hdr->bodyOffset=f.at();
			
		for(char *var=hdr->message->body()->first(); var;
		var=hdr->message->body()->next())
			s << var << "\n";	
	
		f.close();
		debug("Posting saved to File.\n");
		
	}
	
	
	else  MBox(ferr);
}


void KNPostingManager::slotComposerDone(KNMessageComp *comp)
{
	
	KNPostHeader *hdr=comp->header();
	KNMessageComp::Action result=comp->getResult();
		
	if(!comp->hasValidData()	&& result!=KNMessageComp::del){
		MBox(err, i18n("You must specify a Subject and\nat least one newsgroup!"));
		return;
	}
	
	else {
			
			comp->setData();
				
			switch(result) {
				
				case KNMessageComp::save :
					if(hdr->isNew()) fManager->movePosting(hdr, fManager->drafts());
				break;
				
				case KNMessageComp::send_now :
					sendMsg(hdr);
				break;
				
				case KNMessageComp::send_later :
					sendMsg(hdr, false);
				break;
				
				case KNMessageComp::del :
					if(hdr->isNew()) {
						delete hdr;
						hdr=0;
					}
					else {
						removeMsg(hdr);
						hdr=0;
					}
				break;
				
				default:
					debug("KNPostingManager::slotComposerDone : Unexpected result !");
				break;
			}
		
			if(hdr) saveToFile(hdr);	
		}	
	
	compList->remove(comp);	
	if(fManager->current()) showHdrs();
	 	
}














