/***************************************************************************
                     knntpclient.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knntpclient.h"
#include "utilities.h"
#include "knglobals.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <mimelib/datetime.h>
#include <mimelib/string.h>
#include <qobject.h>



KNntpObserver::KNntpObserver(NNTP *cl) : DwObserver()
{
	client=cl;
	receivedBuffer=new QStrList(true);
	receivedBuffer->setAutoDelete(true);
}



KNntpObserver::~KNntpObserver()
{
 	delete receivedBuffer;
}



void KNntpObserver::Notify()
{
	receivedBuffer->append(client->TextResponse().c_str());
}




//=========================================================================0


NNTP::NNTP() : DwNntpClient()
{
	readConfig();
	
	bConnected=false;
	first=0; last=0;
	
	observer=new KNntpObserver(this);
	SetObserver(observer);
	
	timer=new QTimer;
	
	QObject::connect(timer, SIGNAL(timeout()), this, SLOT(cmdDisconnect()));
		
}



NNTP::~NNTP()
{
	if(bConnected) {
		Quit();
		Close();
	}
	
	delete observer;
	delete timer;
}



bool NNTP::cmdConnect(bool setGroup=true)
{
	if(!bConnected) {
		KNGroupEntry *currGroup=xTop->gManager()->current();
		if(Open(server,port)!=0) {
			
			if(!logon()) {
				Close();
				bConnected=false;
			}
			else {
		
				bConnected=true;
				sendCommand("MODE READER");
				debug(serverResponse());
				timer->start(timeout, true);	
				if(setGroup && currGroup!=0) cmdGroup(currGroup->name());
			}
			
		}
	
		else  {
			bConnected=false;
			MBox(err, serverResponse());
  	}
  	
  }
  emit connected(bConnected);
  return bConnected;
}



bool NNTP::logon()
{
	
	if(user.isEmpty()) return true;
	
	else {
		
		QString cmd;
		int ret;
		
		cmd.sprintf("authinfo user %s", user.data());
		ret=sendCommand(cmd.data());
		debug(serverResponse());
		cmd.sprintf("authinfo pass %s", pass.data());
		ret=sendCommand(cmd.data());
		debug(serverResponse());
		if(ret<=299) return true;
		else {
			MBox(err, serverResponse());
			return false;
		}
	}		
		
}



bool NNTP::cmdDisconnect()
{
	
	if(bConnected)
	
		if(Quit()!=0) {
			bConnected=false;
			Close();
			debug(serverResponse());
			timer->stop();
			emit connected(false);
		}
		else MBox(err, serverResponse());
				
	return !bConnected;	
}



bool NNTP::cmdGroup(const char *groupname)
{
	if(!cmdConnect(false)) return false;
			
	if (Group(groupname)!=211) {
		MBox(err, serverResponse());
		return false;
	}
	
	else {
		
		char tmp[256];
		strcpy(tmp,StatusResponse().c_str());
		
		strtok(tmp," ");
		strtok(0," ");
		first=atoi(strtok(0," "));
		last=atoi(strtok(0," "));
		
		debug(serverResponse());
	}
	return true;
}



QStrList* NNTP::cmdList()
{
	if(!cmdConnect()) return 0;
	
	observer->clearBuffer();
	
	if (List()!=215) {
		MBox(err, serverResponse());
		return 0;
	}
	
	debug(serverResponse());
			
	return observer->buffer();
}



const char* NNTP::serverResponse()
{
	static QString resp;
	if(!StatusResponse().empty()) resp=StatusResponse().c_str();
	else {
		resp=i18n("Network-Error:\n");
		if(strcasecmp(LastErrorStr(),"no error")==0)
			resp+="connection broken";
		else resp+=LastErrorStr();
	}
	
	return resp.data();
}



int NNTP::sendCommand(const char *com)
{
	int ret=-1;
	char SendBuff[64];
	strcpy(SendBuff,com);
	strcat(SendBuff,"\r\n");
	PSend(SendBuff,strlen(SendBuff));
	PGetStatusResponse();
	ret=ReplyCode();
  return ret;
}	



QStrList* NNTP::cmdXOver(int from, int to)
{
	if(!cmdConnect()) return 0;
	observer->clearBuffer();
	
	QStrList *ret=0;
	QString cmd;
	int replyCode;
	
	cmd.sprintf("xover %d-%d",from,to);
	
	replyCode=sendCommand(cmd);
	
	if(replyCode==224) {
		debug(serverResponse());
		PGetTextResponse();
		ret=observer->buffer();
	}
	
	else	{
    if(replyCode!=420) MBox(err, serverResponse());
		else debug(serverResponse());
		ret=0;
	}
	
	return ret;
	
}


QStrList* NNTP::cmdArticle(const uint artNr)
{
	if(!cmdConnect()) return 0;
	int replyCode;
		
	observer->clearBuffer();
	
	replyCode=Article(artNr);
	//replyCode=200;
	
	if(replyCode==220) return observer->buffer();
		
	else if(replyCode==0) {
		Close();
		bConnected=false;
	}
		
	return 0;	
}


	
QStrList* NNTP::cmdArticle(const char* mID)
{
	
	if(!cmdConnect()) return 0;
	int replyCode;
		
	observer->clearBuffer();
	
	replyCode=Article(mID);
	//replyCode=200;
	
	if(replyCode==220) return observer->buffer();
		
	else if(replyCode==0) {
		Close();
		bConnected=false;
		emit connected(bConnected);
	}
	
	debug(serverResponse());
	
	return 0;	
}



bool NNTP::sendMsg(DwString &msg)
{
	int replyCode;
			
	replyCode=Post();
	
	if(replyCode==340) {
		
		replyCode=SendData(msg);
		
		if(replyCode==240) {
			debug(serverResponse());
			return true;
		}
	}
	
	if (replyCode==0) { 	
    Close();
		bConnected=false;
	}
	
	return false;
}



void NNTP::readConfig()
{
	KConfig *conf=CONF();   	
	conf->setGroup("SERVER");
	server=conf->readEntry("Nntp", "localhost").copy();
	port=conf->readNumEntry("nPort",119);
	timeout=1000*conf->readNumEntry("Timeout",180);
	
	if(conf->readBoolEntry("needsLogon", false)) {
		user=conf->readEntry("user");
		pass=conf->readEntry("pass");
	}
	else {
		user.resize(0);
		pass.resize(0);
	}	
}