/***************************************************************************
                          knmessagefilter.cpp  -  description
                             -------------------
   
    copyright            : (C) 1999 by Christian Thurner
    email                : cthurner@freepage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "knmessagefilter.h"
#include "utilities.h"



KNMessageFilter::KNMessageFilter()
{
	mCount=0;
	mId=-1;
	mLoaded=false;
  mEnabled=true;
  apon=articles;
}



KNMessageFilter::~KNMessageFilter()
{
}



void KNMessageFilter::loadInfo(KSimpleConfig &c)
{
	c.setGroup("GENERAL");
	mId=c.readNumEntry("id", -1);
	mName=c.readEntry("name");
	mEnabled=c.readBoolEntry("enabled", true);
	apon=(ApOn) c.readNumEntry("applyOn", 0);
}



void KNMessageFilter::load()
{
	KSimpleConfig conf(path());
	
	conf.setGroup("STATUS");
	status.load(&conf);
	
	conf.setGroup("SCORE");
	score.load(&conf);
	
	conf.setGroup("AGE");
	age.load(&conf);
	
	conf.setGroup("LINES");
	lines.load(&conf);
	
	conf.setGroup("SUBJECT");
	subject.load(&conf);
	
	conf.setGroup("FROM");
	from.load(&conf);
	
	mLoaded=true;
	
	debug("KNMessageFilter: filter loaded \"%s\" ", mName.data());
		
}



void KNMessageFilter::save()
{
	KSimpleConfig conf(path());
	
	conf.setGroup("GENERAL");
	conf.writeEntry("id", mId);
	conf.writeEntry("name", mName);
	conf.writeEntry("enabled", mEnabled);
	conf.writeEntry("applyOn", (int) apon);
	
	
	conf.setGroup("STATUS");
	status.save(&conf);
	
	conf.setGroup("SCORE");
	score.save(&conf);
	
	conf.setGroup("AGE");
	age.save(&conf);
	
	conf.setGroup("LINES");
	lines.save(&conf);
	
	conf.setGroup("SUBJECT");
	subject.save(&conf);
	
	conf.setGroup("FROM");
	from.save(&conf);
	
	debug("KNMessageFilter: filter saved \"%s\" ", mName.data());
}



QString KNMessageFilter::path()
{
	 QString ret;
	 ret.sprintf("%sFilters/%d.fltr", knDir().data(), mId);
	 return ret;
}



void KNMessageFilter::doFilter(KNReadHeaderList &l)
{
	KNReadHeaderList &list=l;
	mCount=0;
	KNReadHeader *ref;
	int idRef;
	
	if(!mLoaded) load();
	
		
	for(uint idx=0; idx<list.length(); idx++) {
	
		list[idx]->item=0;
	
	  if(!list[idx]->filtered())
	  	
	  	if(applyFilter(list[idx])) {
	  		
	  	 	if(apon==threads) {
	  			idRef=list[idx]->idRef;
	  		
	  			while(idRef!=0) {
	  				ref=list.byID(idRef);
	  				ref->setFilterResult(true);
	  				ref->setFiltered(true);
	  				idRef=ref->idRef;
	  			}
	  		}
	  		else mCount++;
	  	}
	}
	  	
	  	
	 if(apon==threads) {
	 	bool inThread;
	 	for(uint idx=0; idx<list.length(); idx++) {
	 		
	 		
	 		if(!list[idx]->filterResult()) {
	 			inThread=false;
	 			idRef=list[idx]->idRef;
	 			
	 			while(idRef!=0 && !inThread) {
	  			ref=list.byID(idRef);
	  			inThread=ref->filterResult();
	  			idRef=ref->idRef;
	  		}
	  		
	  		list[idx]->setFilterResult(inThread);
	  		if(inThread) mCount++;
	  	}
	  	else mCount++;
	  }
	}
	
	/*int test=0;
	for(uint idx=0; idx<list.length(); idx++)
		if(list[idx]->filterResult()) test++;
		
		
	debug("mCount: %d   test: %d", mCount, test);*/
	 				
	  	
	  		
		
}



bool KNMessageFilter::applyFilter(KNReadHeader *hdr)
{
	bool result=true;
	
	if(result) result=status.doFilter(hdr);
	if(result) result=score.doFilter(hdr->score);
	if(result) result=lines.doFilter(hdr->lines);
	if(result) result=age.doFilter(hdr->age);	
  if(result) result=subject.doFilter(hdr->subject);
  if(result) result=from.doFilter(hdr->from);


	
	hdr->setFilterResult(result);
	hdr->setFiltered(true);
		
	return result;
}






































