/***************************************************************************
                     knheaderlistbase.h - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNHEADERLISTBASE_H
#define KNHEADERLISTBASE_H

#include "knheaderbase.h"


class KNHeaderListBase {
	
	public:
		KNHeaderListBase();
		~KNHeaderListBase();
		
		bool resize(uint s=0);
		bool append(KNHeaderBase *en);
		void clear();
		void setLastID() { if(len>0) lastID=list[len-1]->id; else lastID=0; }
		void setIncrement(uint i) { incr=i; }
		
		
		uint size() { return siz; }
		uint length() { return len; }
		uint increment() { return incr; }
		bool isEmpty() { return (len==0); }
	
	protected:
		uint siz, len, incr;
		int lastID;
		KNHeaderBase **list;
				
};

#endif




