/***************************************************************************
                     kngrouplistwidget.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kngrouplistwidget.h"
#include "knlboxitem.h"
#include "utilities.h"
#include "knglobals.h"
#include <qlabel.h>
#include <qlayout.h>
#include <kapp.h>

#define SIZE(w) w->setMinimumSize(w->sizeHint())

KNGroupListWidget::KNGroupListWidget(QWidget *parent=0, const char *name=0,
	QStrList *subscribed=0) : QWidget(parent,name)
{
	
	//init Dialog
	list=new QListBox(this);
	
	tabs=new KTabBar(this);
	QTab *t1=new QTab;
	t1->label=i18n("subscribed");
	QTab *t2=new QTab;
	t2->label=i18n("all");
	
	
	
	sID=tabs->addTab(t1);
	aID=tabs->addTab(t2);	
	
	SIZE(tabs);	
		
					
	filterEdit=new QLineEdit(this);
	filterEdit->setMinimumSize(filterEdit->sizeHint());
	QLabel *filterLab=new QLabel(i18n("Filter:"), this);
	filterLab->setMinimumSize(filterLab->sizeHint());
		
	QVBoxLayout *topLayout=new QVBoxLayout(this,0,10);
	QHBoxLayout *fltrLayout=new QHBoxLayout(10);
	QVBoxLayout *tabL=new QVBoxLayout(0);
		
	topLayout->addLayout(fltrLayout,0);
	topLayout->addLayout(tabL,1);
			
	fltrLayout->addWidget(filterLab, 0, AlignLeft);
	fltrLayout->addWidget(filterEdit, 1, AlignRight);
	
	tabL->addWidget(tabs,0);
	tabL->addWidget(list,1);	
	
	topLayout->activate();
  	
	connect(tabs, SIGNAL(selected(int)), this, SLOT(slotTabSelected(int)));
	connect(list, SIGNAL(selected(int)),this,SLOT(slotItemSelected(int)));
	connect(filterEdit, SIGNAL(textChanged(const char*)),
		this, SLOT(slotFilter(const char*)));
	
  subList=subscribed;
	allList=new QStrList(true);
	allList->setAutoDelete(true);
			
}



KNGroupListWidget::~KNGroupListWidget()
{
	delete allList;
}



QSize KNGroupListWidget::sizeHint()
{
	QSize ret;
	
	ret.setHeight(200);
	ret.setWidth(tabs->width());
	
	return ret;
	
}



void KNGroupListWidget::loadList()
{
	QString buff=knDir();
	buff+="groups";
	
	QFile f(buff);	

	if(f.open(IO_ReadOnly)) {
		
		QTextStream ts(&f);
	
		xTop->setStatusMsg(i18n("Reading grouplist from file ..."));
		xTop->setCursorBusy();
	  	
		allList->clear();			
			
		while(!ts.eof())   allList->append(ts.readLine());
	 			 			
		f.close();
		
		xTop->setCursorBusy(false);
		xTop->setStatusMsg();
	}
}



void KNGroupListWidget::updPixmaps()
{
	QStrList *subCopy=new QStrList(false);
	*subCopy=*subList;
	
	for (uint idx=0; idx<list->count(); idx++){
	  for (char *var=subCopy->first(); var; var=subCopy->next()) {
			if (strcmp(var,list->text(idx))==0) {
				setPixmap(idx);
				subCopy->removeRef(var);
				break;
			}
		}
		
		if (subCopy->count()==0) break;
	}
	
	delete subCopy;
}



void KNGroupListWidget::slotFilter(const char *filter)
{
	/////////// THIS is "stolen" from KExpress by Peter Wichert !!
	static int status = 0;
	int localStatus;
	status++;
	localStatus = status; 	
  //////////////////////////////////////////////////////////////
	list->setAutoUpdate(false);
	list->clear();
	kapp->processEvents(50);
		
	for(char *var=ListPtr->first(); var; var=ListPtr->next()) {
	  	
	 	/////////// THIS is "stolen" from KExpress by Peter Wichert !!
		if (localStatus != status) return;
	 	//////////////////////////////////////////////////////////////
	 	
	 	else if(strstr(var,filter)!=0) list->insertItem(var);
	 }
		
	updPixmaps();		
	list->setAutoUpdate(true);
	list->repaint();
}



void KNGroupListWidget::slotTabSelected(int id)
{
	kapp->processEvents(50);	

	if(id==aID) {
		ListPtr=allList;
		if(allList->isEmpty()) loadList();
	}
	else {
		ListPtr=subList;
	}
	
	slotFilter(filterEdit->text());
	if(!filterEdit->hasFocus()) filterEdit->setFocus();		
}




void KNGroupListWidget::setPixmap(int idx=-1, bool s=true)
{
	const char *yellowpoint[]={
		"8 8 3 1","# c #000000",". c None","a c #ffff00","..####..",".#aaaa#.",
		"#aaaaaa#","#aaaaaa#","#aaaaaa#","#aaaaaa#",".#aaaa#.","..####.."};
	
	QPixmap pm=QPixmap(yellowpoint);	
		
	if(idx==-1) idx=list->currentItem();	
	QString tmp=list->text(idx);
		
	if(s) list->changeItem(new KNLBoxItem(tmp,0,&pm),idx);
	else list->changeItem(tmp,idx);
	
}
































