/***************************************************************************
                     knfoldermanager.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knpostingmanager.h"
#include "resource.h"
#include "knfoldermanager.h"
#include "knentryviewitem.h"
#include "knhdrviewitem.h"
#include "utilities.h"


KNFolderManager::KNFolderManager(QListView *v, KNPostingManager *p=0)
{
	pManager=p;	
	count=0;
	lastID=0;
	itFID=-1;
	itPOS=0;
	view=v;
	
	fList=new QList<KNFolderEntry>;
	fList->setAutoDelete(true);
	
	addFolder(new KNFolderEntry(i18n("Sent")), false);	
	addFolder(new KNFolderEntry(i18n("Outbox")), false);
	addFolder(new KNFolderEntry(i18n("Drafts")), false);
	
	
	//addFolder(new KNFolderEntry(i18n("Trash")), false);
	
	//load custom Folders here
	
	
	loadIndex();
	showListItems();
	
	
}



KNFolderManager::~KNFolderManager()
{
	hList.clear();
	delete fList;
}



void KNFolderManager::saveYourself()
{
	rewriteIndex();
}



bool KNFolderManager::setCurrent(KNEntryBase *c)
{
	c_urrent=(KNFolderEntry*)c;
  if(c_urrent) return (pManager->showHdrs());
  else return false;
}



void KNFolderManager::showListItems()
{
	
	for(KNFolderEntry *var=fList->first(); var; var=fList->next())
		if(!var->item()) {
			var->setLstItem(new KNEntryViewItem(view));
			var->item()->setPixmap(0,ICON("folder.xpm"));
			var->updLstItem();
		}
}



void KNFolderManager::loadIndex()
{
	uint count=0, size=sizeof(indexData);
	KNPostHeader *hdr;
	KNFolderEntry *fol;
	QString fName;
	QFile f;
	QFileInfo fInfo(f);
			
	fName=knDir();
	fName+="Folders/index";
	
	f.setName(fName);
	
	
	if(f.open(IO_ReadOnly)) {
	
		indexData data;
	  		
		if(!hList.resize(fInfo.size()/size)) {
			f.close();
			return;
		}
		
		while(!f.atEnd()) {
			
			f.readBlock((char*)(&data), size);	
		
		  hdr=new KNPostHeader;
			
			hdr->id=data.id;
			
			switch(data.fID) {
			
				case FOLD_DRAFTS :	hdr->folderID=2; break;
				case FOLD_SENT :    hdr->folderID=0; break;
				case FOLD_OUTB :    hdr->folderID=1; break;
				
				default: hdr->folderID=data.fID;	break;
			}
			
									
			fol=getFolderById(hdr->folderID);
			if(!fol) fol=drafts();
			fol->mCount++;
		
			if(!hList.append(hdr)) {
				f.close();
				return;
			}
		
			count++;
			
		 }
		
		f.close();
	}
	
	debug("FolderManager : %d entries loaded", count);
		
	hList.setLastID();
}



void KNFolderManager::rewriteIndex()
{
	uint size=sizeof(indexData), cnt=0;
	indexData data;
	QString fName;
	QFile f;
	
	fName=knDir();
	fName+="Folders/index";
	
	f.setName(fName);
			
	if(f.open(IO_WriteOnly)) {
		
		for(uint idx=0; idx<hList.length(); idx++)
			if(hList[idx]->folderID!=-1) {
				data.setData(hList[idx]);
				f.writeBlock((char*) &data, size);
				cnt++;
			}		
		
		f.close();
	}
	
	debug("FolderManager : wrote %d entries to index-file", cnt);
	
			
}



void KNFolderManager::syncIndex()
{
	
	uint size=sizeof(indexData), cnt=0;
	indexData data;
	QString fName;
	QFile f;
	
	fName=knDir();
	fName+="Folders/index";
	f.setName(fName);
			
	if(f.open(IO_ReadWrite)) {
				
		for(uint idx=0; idx<hList.length(); idx++)
			
			if(hList[idx]->hasChanged) {
				f.at(idx*size);
				data.setData(hList[idx]);
				f.writeBlock((char*) &data, size);
			
				cnt++;
			}
		
		f.close();
	}
	
	debug("FolderManager : updated %d entries in index-file", cnt);
}



KNFolderEntry* KNFolderManager::getFolderById(int id)
{
		
	for(KNFolderEntry *var=fList->first(); var; var=fList->next())		
		if(var->fID==id) return var;
		
	return 0;
	
}



void KNFolderManager::addFolder(KNFolderEntry *folder, bool updList=true)
{
	if(folder) {
		fList->append(folder);
		folder->fID=lastID++;
		count++;
		if(updList) showListItems();
	}
}



void KNFolderManager::emptyFolder(KNFolderEntry *f=0)
{
	if(!f) f=c_urrent;
	int fid, cnt=0;
	
	if(f) {
		fid=f->id();
	
		for(uint idx=0; idx<hList.length(); idx++)
			if(hList[idx]->folderID==fid) {
				pManager->deleteMsg(hList[idx]);
				cnt++;
			}
			
		if(cnt>0) rewriteIndex();
	}
		
		
			
	/*if(f==trash()) {	
		for(uint idx=0; idx<hList.length(); idx++)
			if(hList[idx]->folderID==fid) pManager->deleteMsg(hList[idx]);
		rewriteIndex();
		loadIndex();
		pManager->showHdrs();
	}
	
	else
		for(uint idx=0; idx<hList.length(); idx++)
			if(hList[idx]->folderID==fid) movePosting(hList[idx], trash());*/
			
	
	
										
}




void KNFolderManager::movePosting(KNPostHeader *h, KNFolderEntry *f=0)
{
	if(f) if(h->folderID==f->fID) return;
  	
	KNFolderEntry *tmp;
			
	
	if(h->id!=-1) {
		tmp=getFolderById(h->folderID);
		tmp->mCount--;
		tmp->updLstItem();
	}
	else if(!hList.append(h)) return;
	
	if(f) {
		f->mCount++;
		h->folderID=f->fID;
		h->hasChanged=true;
  	if(h->item) delete h->item;
  	f->updLstItem();
  }

}



KNPostHeader* KNFolderManager::initIterator(KNFolderEntry *f=0)
{
	KNPostHeader *ret=0;
	if(!f) f=c_urrent;
	itFID=-1;
	itPOS=0;
	
	if(f) {
		itFID=f->fID;
		for(uint idx=0; idx<hList.length(); idx++)
			if(hList[idx]->folderID==itFID) {
				ret=hList[idx];
				itPOS=idx+1;
				break;
			}
	}
	
	return ret;
}




KNPostHeader* KNFolderManager::nextInFolder()
{
	KNPostHeader *ret=0;
	
	for(uint idx=itPOS; idx<hList.length(); idx++)
		if(hList[idx]->folderID==itFID) {
			ret=hList[idx];
			itPOS=idx+1;
			break;
		}
	
	return ret;	
}
				  	




























