/***************************************************************************
                          knfilterdialog.cpp  -  description
                             -------------------
   
    copyright            : (C) 1999 by Christian Thurner
    email                : cthurner@freepage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "knfilterdialog.h"
#include "utilities.h"
#include <qlayout.h>
#include <qlabel.h>
#include <kseparator.h>
#include <qpushbutton.h>
#include <kapp.h>


KNFilterDialog::
	KNFilterDialog(QWidget *parent=0, const char *name=0, KNMessageFilter *f=0)
	: QSemiModal(parent, name, true)
{
	
	fltr=f;
	if(!f->mName.isEmpty()) savedName=f->mName.copy();
	
	QGroupBox *gb=new QGroupBox(this);
	
	QLabel *l1=new QLabel(i18n("Name"), gb);
	QLabel *l2=new QLabel(i18n("apply on"), gb);
	fname=new QLineEdit(gb);
	enabled=new QCheckBox(i18n("show in menu"), gb);
	apon=new QComboBox(gb);
	apon->insertItem(i18n("single articles"));
	apon->insertItem(i18n("whole threads"));	

	SIZE(l1);  SIZE(l2); SIZE(enabled); SIZE(apon); SIZE(fname);
	
	
	scroll=new QScrollView(this);
	scroll->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	scroll->viewport()->setBackgroundColor(kapp->backgroundColor);
	fw=new KNFilterWidget(scroll);
	scroll->addChild(fw);
	scroll->setMinimumSize(200,100);
	
	KSeparator *sep=new KSeparator(this);
		
	QPushButton *ok=new QPushButton(i18n("OK"), this);
	QPushButton *cancel=new QPushButton(i18n("Cancel"), this);
	QPushButton *help=new QPushButton(i18n("Help"), this);
	help->setEnabled(false);
	SIZE(ok); SIZE(cancel); SIZE(help);
	
	QGridLayout *gbL=new QGridLayout(gb, 2,4,10);
	gbL->addWidget(l1, 0,0);
	gbL->addMultiCellWidget(fname, 0,0,1,3);
	gbL->addWidget(enabled, 1,0);
	gbL->addWidget(l2, 1,2);
	gbL->addWidget(apon, 1,3);
	gbL->setColStretch(1,1);
	
	
	QVBoxLayout *topL=new QVBoxLayout(this,10);
	QHBoxLayout *btnL=new QHBoxLayout(10);
	
	topL->addWidget(gb);
	topL->addWidget(scroll,1);
	topL->addWidget(sep);
	topL->addLayout(btnL);
	
	btnL->addWidget(help);
	btnL->addStretch(1);
	btnL->addWidget(ok);
	btnL->addWidget(cancel);
	
	topL->activate();
	
	
	connect(ok, SIGNAL(clicked()), this, SLOT(slotOK()));
	connect(cancel, SIGNAL(clicked()), this, SLOT(slotCancel()));
	
	
	if(f->mName.isEmpty()) setCaption(i18n("new filter"));
	else setCaption(f->mName);
	
	enabled->setChecked(f->mEnabled);
	apon->setCurrentItem((int) f->apon);
	fname->setText(f->mName);
	
	fw->status->setFilter(f->status);
	fw->lines->setFilter(f->lines);
	fw->age->setFilter(f->age);
	fw->score->setFilter(f->score);
	fw->subject->setFilter(f->subject);
	fw->from->setFilter(f->from);
	
}



KNFilterDialog::~KNFilterDialog()
{
}



void KNFilterDialog::apply()
{
	fltr->mName=fname->text();
	
	fltr->mEnabled=enabled->isChecked();
	
	fltr->status=fw->status->filter();
	fltr->score=fw->score->filter();
	fltr->age=fw->age->filter();
	fltr->lines=fw->lines->filter();
	fltr->subject=fw->subject->filter();
	fltr->from=fw->from->filter();
	
	fltr->apon=(KNMessageFilter::ApOn) apon->currentItem();
	
}



void KNFilterDialog::slotOK()
{
	if(strlen(fname->text()) > 0)	{
		apply();
		emit editDone(this);
	}
		
	else MBox(err, i18n("Please provide a name for this filter."));
}



void KNFilterDialog::slotCancel()
{
	if(fltr->mId==-1) delete fltr;
	else fltr->mName=savedName;
	
	delete this;	 	
}




















